/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternEntryDialog;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ExclusionPatternDialog
extends StatusDialog {
    private ListDialogField<String> fExclusionPatternList;
    private CPElement fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;

    public ExclusionPatternDialog(Shell parent, CPElement entryToEdit) {
        super(parent);
        this.fCurrElement = entryToEdit;
        this.setTitle(CPathEntryMessages.ExclusionPatternDialog_title);
        String label = NLS.bind((String)CPathEntryMessages.ExclusionPatternDialog_pattern_label, (Object)entryToEdit.getPath().makeRelative().toString());
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.ExclusionPatternDialog_pattern_add;
        stringArray[1] = CPathEntryMessages.ExclusionPatternDialog_pattern_add_multiple;
        stringArray[2] = CPathEntryMessages.ExclusionPatternDialog_pattern_edit;
        stringArray[4] = CPathEntryMessages.ExclusionPatternDialog_pattern_remove;
        String[] buttonLabels = stringArray;
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        this.fExclusionPatternList = new ListDialogField<String>(adapter, buttonLabels, (IBaseLabelProvider)new ExclusionPatternLabelProvider());
        this.fExclusionPatternList.setDialogFieldListener(adapter);
        this.fExclusionPatternList.setLabelText(label);
        this.fExclusionPatternList.setRemoveButtonIndex(4);
        this.fExclusionPatternList.enableButton(2, false);
        this.fCurrProject = entryToEdit.getCProject().getProject();
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        IResource res = root.findMember(entryToEdit.getPath());
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        IPath[] pattern = (IPath[])entryToEdit.getAttribute("exclusion");
        ArrayList<String> elements = new ArrayList<String>(pattern.length);
        IPath[] iPathArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            IPath element = iPathArray[n2];
            elements.add(element.toString());
            ++n2;
        }
        this.fExclusionPatternList.setElements(elements);
        this.fExclusionPatternList.selectFirstElement();
        this.fExclusionPatternList.enableButton(1, this.fCurrSourceFolder != null);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fExclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        ExclusionPatternDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doCustomButtonPressed(ListDialogField<String> field, int index) {
        if (index == 0) {
            this.addEntry();
        } else if (index == 2) {
            this.editEntry();
        } else if (index == 1) {
            this.addMultipleEntries();
        }
    }

    protected void doDoubleClicked(ListDialogField<String> field) {
        this.editEntry();
    }

    protected void doSelectionChanged(ListDialogField<String> field) {
        List<String> selected = field.getSelectedElements();
        this.fExclusionPatternList.enableButton(2, this.canEdit(selected));
    }

    private boolean canEdit(List<String> selected) {
        return selected.size() == 1;
    }

    private void editEntry() {
        List<String> selElements = this.fExclusionPatternList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        List<String> existing = this.fExclusionPatternList.getElements();
        String entry = selElements.get(0);
        ExclusionPatternEntryDialog dialog = new ExclusionPatternEntryDialog(this.getShell(), entry, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            this.fExclusionPatternList.replaceElement(entry, dialog.getExclusionPattern());
        }
    }

    private void addEntry() {
        List<String> existing = this.fExclusionPatternList.getElements();
        ExclusionPatternEntryDialog dialog = new ExclusionPatternEntryDialog(this.getShell(), null, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            this.fExclusionPatternList.addElement(dialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    public IPath[] getExclusionPattern() {
        IPath[] res = new IPath[this.fExclusionPatternList.getSize()];
        int i = 0;
        while (i < res.length) {
            String entry = this.fExclusionPatternList.getElement(i);
            res[i] = new Path(entry);
            ++i;
        }
        return res;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private void addMultipleEntries() {
        Class[] acceptedClasses = new Class[]{IFolder.class, IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Object initialElement = null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(CPathEntryMessages.ExclusionPatternDialog_ChooseExclusionPattern_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(CPathEntryMessages.ExclusionPatternDialog_ChooseExclusionPattern_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrSourceFolder);
        dialog.setInitialSelection(initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            int existingSegments = this.fCurrSourceFolder.getFullPath().segmentCount();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IResource curr = (IResource)object;
                IPath path = curr.getFullPath().removeFirstSegments(existingSegments).makeRelative();
                String res = curr instanceof IContainer ? path.addTrailingSeparator().toString() : path.toString();
                this.fExclusionPatternList.addElement(res);
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExclusionPatternAdapter
    implements IListAdapter<String>,
    IDialogFieldListener {
        private ExclusionPatternAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<String> field, int index) {
            ExclusionPatternDialog.this.doCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField<String> field) {
            ExclusionPatternDialog.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField<String> field) {
            ExclusionPatternDialog.this.doDoubleClicked(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }

    private static class ExclusionPatternLabelProvider
    extends LabelProvider {
        private ExclusionPatternLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = CUIPlugin.getImageDescriptorRegistry();
            return registry.get(CPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

