/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class IBFile {
    public final ITranslationUnit fTU;
    public final IIndexFileLocation fLocation;
    public final String fName;

    public IBFile(ITranslationUnit tu) {
        this.fTU = tu;
        this.fLocation = IndexLocationFactory.getIFL((ITranslationUnit)tu);
        this.fName = tu.getElementName();
    }

    public IBFile(ICProject preferredProject, IIndexFileLocation location) throws CModelException {
        this.fLocation = location;
        this.fTU = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)location, (ICProject)preferredProject);
        String name = this.fLocation.getURI().getPath();
        this.fName = name.substring(name.lastIndexOf(47) + 1);
    }

    public IBFile(String name) {
        this.fName = name;
        this.fLocation = null;
        this.fTU = null;
    }

    public IIndexFileLocation getLocation() {
        return this.fLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBFile) {
            IBFile file = (IBFile)obj;
            return CoreUtility.safeEquals(this.fLocation, file.fLocation) && CoreUtility.safeEquals(this.fTU, file.fTU);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return CoreUtility.safeHashcode(this.fLocation) + 31 * (CoreUtility.safeHashcode(this.fTU) + 31 * CoreUtility.safeHashcode(this.fName));
    }

    public ITranslationUnit getTranslationUnit() {
        return this.fTU;
    }

    public IFile getResource() {
        IResource file;
        String fullPath;
        if (this.fLocation != null && (fullPath = this.fLocation.getFullPath()) != null && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath)) instanceof IFile) {
            return (IFile)file;
        }
        return null;
    }

    public String getName() {
        return this.fName;
    }
}

