/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterAndSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterInsertEditProvider;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateGettersAndSettersRefactoring
extends CRefactoring {
    private static final String MEMBER_DECLARATION = "MEMBER_DECLARATION";
    private final GetterAndSetterContext context = new GetterAndSetterContext();
    private InsertLocation definitionInsertLocation;

    public GenerateGettersAndSettersRefactoring(IFile file, ISelection selection, ICElement element, ICProject project) {
        super(file, selection, element, project);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (status.hasError()) {
            return status;
        }
        if (!this.initStatus.hasFatalError()) {
            this.initRefactoring(pm);
            if (this.context.existingFields.size() == 0) {
                this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoFields);
            }
        }
        return this.initStatus;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus finalStatus = null;
        try {
            try {
                this.lockIndex();
                finalStatus = super.checkFinalConditions(pm);
                if (!this.context.isImplementationInHeader()) {
                    this.definitionInsertLocation = this.findInsertLocation();
                    if (this.file.equals((Object)this.definitionInsertLocation.getInsertFile())) {
                        finalStatus.addInfo(Messages.GenerateGettersAndSettersRefactoring_NoImplFile);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.unlockIndex();
            }
        }
        finally {
            this.unlockIndex();
        }
        return finalStatus;
    }

    private void initRefactoring(IProgressMonitor pm) {
        this.loadTranslationUnit(this.initStatus, pm);
        this.context.selectedName = this.getSelectedName();
        IASTCompositeTypeSpecifier compositeTypeSpecifier = null;
        compositeTypeSpecifier = this.context.selectedName != null ? this.getCompositeTypeSpecifier(this.context.selectedName) : this.findCurrentCompositeTypeSpecifier();
        if (compositeTypeSpecifier != null) {
            this.findDeclarations(compositeTypeSpecifier);
        } else {
            this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoCassDefFound);
        }
    }

    private IASTCompositeTypeSpecifier findCurrentCompositeTypeSpecifier() {
        int start = this.region.getOffset();
        Container container = new Container();
        this.unit.accept((ASTVisitor)new CompositeTypeSpecFinder(start, container));
        return (IASTCompositeTypeSpecifier)container.getObject();
    }

    private IASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTName selectedName) {
        IASTName node = selectedName;
        while (node != null && !(node instanceof IASTCompositeTypeSpecifier)) {
            node = node.getParent();
        }
        return (IASTCompositeTypeSpecifier)node;
    }

    private IASTName getSelectedName() {
        ArrayList<IASTName> names = this.findAllMarkedNames();
        if (names.size() < 1) {
            return null;
        }
        return names.get(names.size() - 1);
    }

    protected void findDeclarations(IASTCompositeTypeSpecifier compositeTypeSpecifier) {
        compositeTypeSpecifier.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTFunctionDefinition functionDefinition;
                IASTDeclarator[] declarators;
                IASTSimpleDeclaration fieldDeclaration;
                ASTNodeProperty props;
                if (declaration instanceof IASTSimpleDeclaration && (props = (fieldDeclaration = (IASTSimpleDeclaration)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION) && (declarators = fieldDeclaration.getDeclarators()).length > 0) {
                    if (declarators[0] instanceof IASTFunctionDeclarator) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDeclarations.add(fieldDeclaration);
                    } else if (SelectionHelper.isInSameFile((IASTNode)fieldDeclaration, GenerateGettersAndSettersRefactoring.this.file)) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFields.add(fieldDeclaration);
                    }
                }
                if (declaration instanceof IASTFunctionDefinition && (props = (functionDefinition = (IASTFunctionDefinition)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION)) {
                    ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDefinitions.add(functionDefinition);
                }
                return super.visit(declaration);
            }
        });
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        try {
            try {
                this.lockIndex();
                ArrayList<IASTNode> getterAndSetters = new ArrayList<IASTNode>();
                ArrayList<IASTFunctionDefinition> definitions = new ArrayList<IASTFunctionDefinition>();
                for (GetterSetterInsertEditProvider currentProvider : this.context.selectedFunctions) {
                    if (this.context.isImplementationInHeader()) {
                        getterAndSetters.add((IASTNode)currentProvider.getFunctionDefinition(false));
                        continue;
                    }
                    getterAndSetters.add((IASTNode)currentProvider.getFunctionDeclaration());
                    definitions.add(currentProvider.getFunctionDefinition(true));
                }
                if (!this.context.isImplementationInHeader()) {
                    this.addDefinition(collector, definitions);
                }
                ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)this.context.existingFields.get(this.context.existingFields.size() - 1).getParent();
                AddDeclarationNodeToClassChange.createChange(classDefinition, VisibilityEnum.v_public, getterAndSetters, false, collector);
            }
            catch (InterruptedException interruptedException) {
                this.unlockIndex();
            }
        }
        finally {
            this.unlockIndex();
        }
    }

    private void addDefinition(ModificationCollector collector, ArrayList<IASTFunctionDefinition> definitions) throws CoreException {
        InsertLocation location = this.findInsertLocation();
        IASTTranslationUnit targetUnit = location.getTargetTranslationUnit();
        IASTNode parent = location.getPartenOfNodeToInsertBefore();
        ASTRewrite rewrite = collector.rewriterForTranslationUnit(targetUnit);
        IASTNode nodeToInsertBefore = location.getNodeToInsertBefore();
        ContainerNode cont = new ContainerNode(new IASTNode[0]);
        for (IASTFunctionDefinition functionDefinition : definitions) {
            cont.addNode((IASTNode)functionDefinition);
        }
        rewrite = rewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)cont, null);
    }

    public GetterAndSetterContext getContext() {
        return this.context;
    }

    public Region getRegion() {
        return this.region;
    }

    private InsertLocation findInsertLocation() throws CoreException {
        IASTSimpleDeclaration decl = this.context.existingFields.get(0);
        InsertLocation insertLocation = MethodDefinitionInsertLocationFinder.find(decl.getFileLocation(), decl.getParent(), this.file);
        if (!insertLocation.hasFile() || NodeHelper.isContainedInTemplateDeclaration((IASTNode)decl)) {
            insertLocation.setInsertFile(this.file);
            insertLocation.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)decl));
        }
        return insertLocation;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompositeTypeSpecFinder
    extends CPPASTVisitor {
        private final int start;
        private final Container<IASTCompositeTypeSpecifier> container;

        private CompositeTypeSpecFinder(int start, Container<IASTCompositeTypeSpecifier> container) {
            this.shouldVisitDeclSpecifiers = true;
            this.start = start;
            this.container = container;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            IASTFileLocation loc;
            if (declSpec instanceof IASTCompositeTypeSpecifier && this.start > (loc = declSpec.getFileLocation()).getNodeOffset() && this.start < loc.getNodeOffset() + loc.getNodeLength()) {
                this.container.setObject((IASTCompositeTypeSpecifier)declSpec);
                return 2;
            }
            return super.visit(declSpec);
        }
    }
}

