/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.internal.ui.refactoring.rename.Messages;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameCSourceFolderChange;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameSourceFolder
extends RenameParticipant {
    private IFolder oldFolder;
    private String newName;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RenameArguments arg = this.getArguments();
        this.newName = arg.getNewName();
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IPath oldFolderPath = this.oldFolder.getFullPath();
        IPath newFolderPath = this.oldFolder.getFullPath().uptoSegment(this.oldFolder.getFullPath().segmentCount() - 1).append(this.newName);
        return new RenameCSourceFolderChange(oldFolderPath, newFolderPath, this.oldFolder.getProject(), this.oldFolder);
    }

    public String getName() {
        return Messages.getString("RenameSourceFolder.0");
    }

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            this.oldFolder = (IFolder)element;
            return true;
        }
        return false;
    }
}

