/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.utils.DeclarationFinderDO;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class DeclarationFinder {
    public static DeclarationFinderDO getDeclaration(IASTName name, IIndex index) throws CoreException {
        IIndexBinding binding = index.findBinding((IName)name);
        IIndexName[] pdomref = index.findDeclarations((IBinding)binding);
        IIndexName[] allNamesPDom = index.findNames((IBinding)binding, 4);
        if (pdomref == null || pdomref.length < 1) {
            return null;
        }
        String filename2 = pdomref[0].getFileLocation().getFileName();
        IASTTranslationUnit transUnit = TranslationUnitHelper.loadTranslationUnit(filename2, false);
        IASTName declName = DeclarationFinder.findDeclarationInTranslationUnit(transUnit, pdomref[0]);
        return new DeclarationFinderDO(allNamesPDom, transUnit, filename2, declName);
    }

    public static IASTName findDeclarationInTranslationUnit(IASTTranslationUnit transUnit, final IIndexName indexName) {
        final Container defName = new Container();
        transUnit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (name.isDeclaration() && name.getNodeLocations().length > 0) {
                    IASTNodeLocation nodeLocation = name.getNodeLocations()[0];
                    if (indexName.getNodeOffset() == nodeLocation.getNodeOffset() && indexName.getNodeLength() == nodeLocation.getNodeLength() && new Path(indexName.getFileLocation().getFileName()).equals((Object)new Path(nodeLocation.asFileLocation().getFileName()))) {
                        defName.setObject(name);
                        return 2;
                    }
                }
                return 3;
            }
        });
        return (IASTName)defName.getObject();
    }
}

