/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.internal.ui.refactoring.utils.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisibilityEnum {
    v_public(Messages.VisibilityEnum_public),
    v_protected(Messages.VisibilityEnum_protected),
    v_private(Messages.VisibilityEnum_private);

    private final String stringRepresentation;

    private VisibilityEnum(String stringRepresentation) {
        this.stringRepresentation = stringRepresentation;
    }

    public static VisibilityEnum from(ICPPASTVisibilityLabel visibility) {
        switch (visibility.getVisibility()) {
            case 3: {
                return v_private;
            }
            case 2: {
                return v_protected;
            }
            case 1: {
                return v_public;
            }
        }
        return null;
    }

    public int getASTBaseSpecifierVisibility() {
        switch (this) {
            case v_private: {
                return 3;
            }
            case v_protected: {
                return 2;
            }
            case v_public: {
                return 1;
            }
        }
        return 0;
    }

    public int getICPPASTVisiblityLabelVisibility() {
        switch (this) {
            case v_private: {
                return 3;
            }
            case v_protected: {
                return 2;
            }
            case v_public: {
                return 1;
            }
        }
        return 0;
    }

    public static VisibilityEnum getEnumForStringRepresentation(String visibility) {
        if (v_private.toString().equals(visibility)) {
            return v_private;
        }
        if (v_protected.toString().equals(visibility)) {
            return v_protected;
        }
        if (v_public.toString().equals(visibility)) {
            return v_public;
        }
        return null;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

