/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class PDOMSearchElementQuery
extends PDOMSearchQuery {
    private ISourceReference element;
    private String label;

    public PDOMSearchElementQuery(ICElement[] scope, ISourceReference element, int flags) {
        super(scope, flags | 8);
        this.element = element;
        this.label = element instanceof ICElement ? ((ICElement)element).getElementName() : CSearchMessages.PDOMSearchElementQuery_something;
    }

    public IStatus runWithIndex(IIndex index, IProgressMonitor monitor) throws OperationCanceledException {
        try {
            IIndexBinding binding;
            if (this.element instanceof ICElement && (binding = IndexUI.elementToBinding(index, (ICElement)this.element)) != null) {
                this.label = this.labelForBinding(index, (IBinding)binding, this.label);
                this.createMatches(index, (IBinding)binding);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public String getResultLabel(int numMatches) {
        return this.getResultLabel(this.label, numMatches);
    }
}

