/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TokenStore
implements ITokenStore {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map<String, IToken> fTokenMap = new HashMap<String, IToken>();
    private String[] fPropertyNamesColor;
    private boolean fNeedsLazyColorLoading;

    public TokenStore(IColorManager manager, IPreferenceStore store, String[] propertyNamesColor) {
        this.fColorManager = manager;
        this.fPreferenceStore = store;
        this.fPropertyNamesColor = propertyNamesColor;
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        int i = 0;
        while (i < this.fPropertyNamesColor.length) {
            if (this.fPropertyNamesColor[i].endsWith("_bold") || this.fPropertyNamesColor[i].endsWith("_italic") || this.fPropertyNamesColor[i].endsWith("_strikethrough") || this.fPropertyNamesColor[i].endsWith("_underline")) {
                throw new IllegalArgumentException();
            }
            if (this.fNeedsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.fPropertyNamesColor[i]);
            } else {
                this.addToken(this.fPropertyNamesColor[i]);
            }
            ++i;
        }
    }

    public void ensureTokensInitialised() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            int i = 0;
            while (i < this.fPropertyNamesColor.length) {
                this.addToken(this.fPropertyNamesColor[i]);
                ++i;
            }
            this.fNeedsLazyColorLoading = false;
        }
    }

    private void addTokenWithProxyAttribute(String colorKey) {
        this.fTokenMap.put(colorKey, (IToken)new Token((Object)this.createTextAttribute(colorKey, true)));
    }

    private void addToken(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            this.fColorManager.unbindColor(colorKey);
            this.fColorManager.bindColor(colorKey, rgb);
        }
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(colorKey, (IToken)new Token((Object)this.createTextAttribute(colorKey, false)));
        } else {
            Token token = (Token)this.fTokenMap.get(colorKey);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(colorKey, false));
            }
        }
    }

    private TextAttribute createTextAttribute(String colorKey, boolean isNull) {
        int style;
        Color color = null;
        if (!isNull) {
            color = this.fColorManager.getColor(colorKey);
        }
        String boldKey = String.valueOf(colorKey) + "_bold";
        String italicKey = String.valueOf(colorKey) + "_italic";
        String strikethroughKey = String.valueOf(colorKey) + "_strikethrough";
        String underlineKey = String.valueOf(colorKey) + "_underline";
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    public IToken getToken(String key) {
        return this.getTokenInner(key);
    }

    private Token getTokenInner(String key) {
        this.ensureTokensInitialised();
        return (Token)this.fTokenMap.get(key);
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.startsWith(this.fPropertyNamesColor[i])) {
                    String end;
                    int pLength = property.length();
                    if (this.fPropertyNamesColor[i].length() < pLength ? (end = property.substring(this.fPropertyNamesColor[i].length())).equals("_bold") || end.equals("_italic") || end.equals("_strikethrough") || end.equals("_underline") : this.fPropertyNamesColor[i].equals(property)) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        int i;
        String property = event.getProperty();
        if (property.startsWith(this.fPropertyNamesColor[i = this.indexOf(property)])) {
            Token token = this.getTokenInner(this.fPropertyNamesColor[i]);
            if (property.length() == this.fPropertyNamesColor[i].length()) {
                this.adaptToColorChange(token, event);
            } else {
                String end = property.substring(this.fPropertyNamesColor[i].length());
                if (end.equals("_bold")) {
                    this.adaptToStyleChange(token, event, 1);
                } else if (end.equals("_italic")) {
                    this.adaptToStyleChange(token, event, 2);
                } else if (end.equals("_strikethrough")) {
                    this.adaptToStyleChange(token, event, 0x20000000);
                } else if (end.equals("_underline")) {
                    this.adaptToStyleChange(token, event, 0x40000000);
                }
            }
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                this.fColorManager.unbindColor(property);
                this.fColorManager.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }
}

