/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.util.CElementBaseLabels;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.CopyTreeAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.typehierarchy.ITHModelPresenter;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.THContentProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THDropTargetListener;
import org.eclipse.cdt.internal.ui.typehierarchy.THHierarchyModel;
import org.eclipse.cdt.internal.ui.typehierarchy.THHistoryDropDownAction;
import org.eclipse.cdt.internal.ui.typehierarchy.THLabelProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THMemberContentProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THNode;
import org.eclipse.cdt.internal.ui.viewsupport.AdaptingSelectionProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.EditorOpener;
import org.eclipse.cdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class THViewPart
extends ViewPart
implements ITHModelPresenter {
    private static final int MAX_HISTORY_SIZE = 10;
    private static final String TRUE = String.valueOf(true);
    private static final String KEY_WORKING_SET_FILTER = "workingSetFilter";
    private static final String KEY_SHOW_FILES = "showFilesInLabels";
    private static final String KEY_SHOW_INHERITED_MEMBERS = "showInheritedMembers";
    private static final String KEY_FILTER_FIELDS = "filterFields";
    private static final String KEY_FILTER_STATIC = "filterStatic";
    private static final String KEY_FILTER_NON_PUBLIC = "filterNonPublic";
    private static final String KEY_MODE = "hierarchyMode";
    private static final String KEY_ORIENTATION = "viewOrientation";
    private static final String KEY_SPLITTER_W1 = "splitterWeight1";
    private static final String KEY_SPLITTER_W2 = "splitterWeight2";
    private static final int ORIENTATION_AUTOMATIC = 0;
    private static final int ORIENTATION_HORIZONTAL = 1;
    private static final int ORIENTATION_VERTICAL = 2;
    private static final int ORIENTATION_SINGLE = 3;
    private static final int MEMBER_LABEL_OPTIONS_SIMPLE = 1;
    private static final int MEMBER_LABEL_OPTIONS_QUALIFIED = 69210177;
    private static final int MEMBER_ICON_OPTIONS = 1;
    private IMemento fMemento;
    private boolean fShowsMessage = true;
    private int fCurrentViewOrientation = -1;
    private boolean fInComputeOrientation = false;
    private ArrayList<ICElement> fHistoryEntries = new ArrayList(10);
    private int fIgnoreSelectionChanges = 0;
    private Clipboard fClipboard;
    private PageBook fPagebook;
    private Label fInfoText;
    private SashForm fSplitter;
    private ViewForm fHierarchyViewForm;
    private ViewForm fMemberViewForm;
    private CLabel fMemberLabel;
    private THHierarchyModel fModel;
    private THLabelProvider fHierarchyLabelProvider;
    private CUILabelProvider fMemberLabelProvider;
    private TableViewer fMemberViewer;
    private TreeViewer fHierarchyTreeViewer;
    private WorkingSetFilterUI fWorkingSetFilterUI;
    private ViewerFilter fFieldFilter;
    private ViewerFilter fStaticFilter;
    private ViewerFilter fNonPublicFilter;
    private ToolBarManager fMemberToolbarManager;
    private Action fShowSuperTypeHierarchyAction;
    private Action fShowSubTypeHierarchyAction;
    private Action fShowTypeHierarchyAction;
    private Action fShowFilesInLabelsAction;
    private Action fRefreshAction;
    private Action fCancelAction;
    private Action fHistoryAction;
    private Action fOpenElement;
    private CopyTreeAction fCopyAction;
    private Action fHorizontalOrientation;
    private Action fVerticalOrientation;
    private Action fAutomaticOrientation;
    private Action fSingleOrientation;
    private Action fShowInheritedMembersAction;
    private Action fFieldFilterAction;
    private Action fStaticFilterAction;
    private Action fNonPublicFilterAction;
    private OpenViewActionGroup fOpenViewActionGroup;
    private SelectionSearchGroup fSelectionSearchGroup;
    private CRefactoringActionGroup fRefactoringActionGroup;
    private IContextActivation fContextActivation;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setMessage(String msg) {
        this.fInfoText.setText(msg);
        this.fPagebook.showPage((Control)this.fInfoText);
        this.fShowsMessage = true;
        this.updateDescription();
        this.updateActionEnablement();
    }

    void setInput(ICElement inputType, ICElement inputMember) {
        if (inputType == null) {
            this.setMessage(Messages.THViewPart_instruction);
            this.fHierarchyTreeViewer.setInput(null);
            this.fMemberViewer.setInput(null);
            return;
        }
        this.fShowsMessage = false;
        this.fModel.setInput(inputType, inputMember);
        this.fHierarchyTreeViewer.setInput((Object)this.fModel);
        this.fMemberViewer.setInput((Object)this.fModel);
        this.fPagebook.showPage((Control)this.fSplitter);
        this.updateDescription();
        this.updateHistory(inputType);
        this.updateActionEnablement();
        this.fModel.computeGraph();
    }

    public void createPartControl(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.createInfoPage();
        this.createViewerPage();
        this.initSelectionProvider();
        this.fClipboard = new Clipboard(parent.getDisplay());
        this.initDragAndDrop();
        this.createActions();
        this.createContextMenu();
        this.setMessage(Messages.THViewPart_instruction);
        this.initializeActionStates();
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.cdt.ui.cViewScope");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.cdt.ui.type_hierarchy_view_context");
    }

    public void dispose() {
        IContextService ctxService;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        if (this.fOpenViewActionGroup != null) {
            this.fOpenViewActionGroup.dispose();
            this.fOpenViewActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fWorkingSetFilterUI != null) {
            this.fWorkingSetFilterUI.dispose();
            this.fWorkingSetFilterUI = null;
        }
        super.dispose();
    }

    private void initSelectionProvider() {
        SelectionProviderMediator mediator = new SelectionProviderMediator();
        mediator.addViewer((Viewer)this.fHierarchyTreeViewer);
        mediator.addViewer((Viewer)this.fMemberViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)new AdaptingSelectionProvider(ICElement.class, mediator));
    }

    private void initializeActionStates() {
        int mode = 0;
        int orientation = 0;
        boolean showFiles = false;
        boolean showInheritedMembers = false;
        boolean hideFields = false;
        boolean hideStatic = false;
        boolean hideNonPublic = false;
        int[] weights = new int[]{35, 65};
        if (this.fMemento != null) {
            showFiles = TRUE.equals(this.fMemento.getString(KEY_SHOW_FILES));
            showInheritedMembers = TRUE.equals(this.fMemento.getString(KEY_SHOW_INHERITED_MEMBERS));
            hideFields = TRUE.equals(this.fMemento.getString(KEY_FILTER_FIELDS));
            hideStatic = TRUE.equals(this.fMemento.getString(KEY_FILTER_STATIC));
            hideNonPublic = TRUE.equals(this.fMemento.getString(KEY_FILTER_NON_PUBLIC));
            Integer intval = this.fMemento.getInteger(KEY_MODE);
            if (intval != null) {
                mode = intval;
            }
            if ((intval = this.fMemento.getInteger(KEY_ORIENTATION)) != null) {
                orientation = intval;
            }
            intval = this.fMemento.getInteger(KEY_SPLITTER_W1);
            Integer intval2 = this.fMemento.getInteger(KEY_SPLITTER_W2);
            if (intval != null && intval2 != null) {
                weights[0] = intval;
                weights[1] = intval2;
            }
        }
        this.restoreOrientation(orientation);
        this.restoreHierarchyKind(mode);
        this.fSplitter.setWeights(weights);
        this.fShowInheritedMembersAction.setChecked(showInheritedMembers);
        this.fShowInheritedMembersAction.run();
        this.fFieldFilterAction.setChecked(hideFields);
        this.fFieldFilterAction.run();
        this.fStaticFilterAction.setChecked(hideStatic);
        this.fStaticFilterAction.run();
        this.fNonPublicFilterAction.setChecked(hideNonPublic);
        this.fNonPublicFilterAction.run();
        this.fHierarchyLabelProvider.setShowFiles(showFiles);
        this.fShowFilesInLabelsAction.setChecked(showFiles);
        this.fMemberToolbarManager.update(true);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.fMemento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        if (this.fWorkingSetFilterUI != null) {
            this.fWorkingSetFilterUI.saveState(memento, KEY_WORKING_SET_FILTER);
        }
        memento.putString(KEY_SHOW_INHERITED_MEMBERS, String.valueOf(this.fShowInheritedMembersAction.isChecked()));
        memento.putString(KEY_SHOW_FILES, String.valueOf(this.fShowFilesInLabelsAction.isChecked()));
        memento.putString(KEY_FILTER_FIELDS, String.valueOf(this.fFieldFilterAction.isChecked()));
        memento.putString(KEY_FILTER_STATIC, String.valueOf(this.fStaticFilterAction.isChecked()));
        memento.putString(KEY_FILTER_NON_PUBLIC, String.valueOf(this.fNonPublicFilterAction.isChecked()));
        int[] weights = this.fSplitter.getWeights();
        memento.putInteger(KEY_SPLITTER_W1, weights[0]);
        memento.putInteger(KEY_SPLITTER_W2, weights[1]);
        if (this.fAutomaticOrientation.isChecked()) {
            memento.putInteger(KEY_ORIENTATION, 0);
        } else {
            memento.putInteger(KEY_ORIENTATION, this.fCurrentViewOrientation);
        }
        super.saveState(memento);
    }

    private void createContextMenu() {
        IWorkbenchPartSite site = this.getSite();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                THViewPart.this.onContextMenuAboutToShow(m, true);
            }
        });
        Menu menu = manager.createContextMenu(this.fHierarchyTreeViewer.getControl());
        this.fHierarchyTreeViewer.getControl().setMenu(menu);
        site.registerContextMenu("org.eclipse.cdt.ui.typeHierarchy", manager, (ISelectionProvider)this.fHierarchyTreeViewer);
        manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                THViewPart.this.onContextMenuAboutToShow(m, false);
            }
        });
        menu = manager.createContextMenu(this.fMemberViewer.getControl());
        this.fMemberViewer.getControl().setMenu(menu);
        site.registerContextMenu("org.eclipse.cdt.ui.typeHierarchy.members", manager, (ISelectionProvider)this.fMemberViewer);
    }

    protected void onContextMenuAboutToShow(IMenuManager menu, boolean hierarchyView) {
        ISelection selection;
        CUIPlugin.createStandardGroups(menu);
        TreeViewer viewer = hierarchyView ? this.fHierarchyTreeViewer : this.fMemberViewer;
        final ICElement elem = this.selectionToElement(viewer.getSelection());
        if (elem != null) {
            menu.appendToGroup("group.open", (IAction)this.fOpenElement);
            if (hierarchyView && !elem.equals(this.fModel.getInput())) {
                String label = MessageFormat.format((String)Messages.THViewPart_FocusOn, (Object[])new Object[]{CElementLabels.getTextLabel(elem, 34613281)});
                menu.appendToGroup("group.open", (IAction)new Action(label){

                    public void run() {
                        THViewPart.this.setInput(elem, null);
                    }
                });
            }
        }
        if (OpenViewActionGroup.canActionBeAdded(selection = this.getSite().getSelectionProvider().getSelection())) {
            this.fOpenViewActionGroup.fillContextMenu(menu);
        }
        if (hierarchyView && this.fCopyAction.canActionBeAdded()) {
            menu.appendToGroup("group.edit", (IAction)this.fCopyAction);
        }
        if (SelectionSearchGroup.canActionBeAdded(selection)) {
            this.fSelectionSearchGroup.fillContextMenu(menu);
        }
        this.fRefactoringActionGroup.fillContextMenu(menu);
    }

    private void createViewerPage() {
        this.fSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fSplitter.setLayoutData((Object)new GridData(1808));
        this.fSplitter.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (THViewPart.this.fAutomaticOrientation.isChecked()) {
                    THViewPart.this.setOrientation(0);
                }
            }
        });
        this.fHierarchyViewForm = new ViewForm((Composite)this.fSplitter, 0);
        Control hierarchyControl = this.createHierarchyControl(this.fHierarchyViewForm);
        this.fHierarchyViewForm.setContent(hierarchyControl);
        this.fMemberViewForm = new ViewForm((Composite)this.fSplitter, 0);
        Control memberControl = this.createMemberControl(this.fMemberViewForm);
        this.fMemberViewForm.setContent(memberControl);
        this.fMemberLabel = new CLabel((Composite)this.fMemberViewForm, 0);
        this.fMemberLabel.setText(Messages.THViewPart_MethodPane_title);
        this.fMemberViewForm.setTopLeft((Control)this.fMemberLabel);
    }

    private Control createMemberControl(ViewForm parent) {
        this.fMemberLabelProvider = new CUILabelProvider(1, 1);
        this.fMemberViewer = new TableViewer((Composite)parent, 2816);
        this.fMemberViewer.setContentProvider((IContentProvider)new THMemberContentProvider());
        this.fMemberViewer.setLabelProvider((IBaseLabelProvider)this.fMemberLabelProvider);
        this.fMemberViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                THViewPart.this.onOpenElement(event.getSelection());
            }
        });
        this.fMemberViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                THViewPart.this.onMemberSelectionChanged(event);
            }
        });
        this.fMemberViewer.setSorter(new ViewerSorter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public int category(Object element) {
                if (!(element instanceof ICElement)) return 10;
                ICElement celem = (ICElement)element;
                switch (celem.getElementType()) {
                    case 72: {
                        return 1;
                    }
                    case 70: 
                    case 71: {
                        IMethodDeclaration md = (IMethodDeclaration)celem;
                        try {
                            if (md.isConstructor()) {
                                return 2;
                            }
                            if (!md.isDestructor()) return 10;
                            return 3;
                        }
                        catch (CModelException e) {
                            CUIPlugin.log(e);
                        }
                        return 10;
                    }
                }
                return 10;
            }
        });
        final ToolBar memberToolBar = new ToolBar((Composite)parent, 0x800040);
        parent.setTopCenter((Control)memberToolBar);
        memberToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTip;
                ToolItem item;
                if (e.childID != -1 && (item = memberToolBar.getItem(e.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                    e.result = toolTip;
                }
            }
        });
        this.fMemberToolbarManager = new ToolBarManager(memberToolBar);
        return this.fMemberViewer.getControl();
    }

    protected void onMemberSelectionChanged(SelectionChangedEvent event) {
        if (this.fIgnoreSelectionChanges == 0) {
            ICElement elem = this.selectionToElement(event.getSelection());
            this.fModel.onMemberSelectionChanged(elem);
            this.fHierarchyTreeViewer.refresh();
        }
    }

    private Control createHierarchyControl(ViewForm parent) {
        Display display = this.getSite().getShell().getDisplay();
        this.fModel = new THHierarchyModel(this, display);
        this.fHierarchyLabelProvider = new THLabelProvider(display, this.fModel);
        this.fHierarchyTreeViewer = new TreeViewer((Composite)parent, 2816);
        this.fHierarchyTreeViewer.setContentProvider((IContentProvider)new THContentProvider());
        this.fHierarchyTreeViewer.setLabelProvider((IBaseLabelProvider)this.fHierarchyLabelProvider);
        this.fHierarchyTreeViewer.setSorter(new ViewerSorter());
        this.fHierarchyTreeViewer.setUseHashlookup(true);
        this.fHierarchyTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                THViewPart.this.onOpenElement(event.getSelection());
            }
        });
        this.fHierarchyTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                THViewPart.this.onHierarchySelectionChanged(event);
            }
        });
        return this.fHierarchyTreeViewer.getControl();
    }

    protected void onHierarchySelectionChanged(SelectionChangedEvent event) {
        if (this.fIgnoreSelectionChanges == 0) {
            THNode node = this.selectionToNode(event.getSelection());
            this.fModel.onHierarchySelectionChanged(node);
            this.updateView();
        }
    }

    private void createInfoPage() {
        this.fInfoText = new Label((Composite)this.fPagebook, 16576);
    }

    private void initDragAndDrop() {
        THDropTargetListener dropListener = new THDropTargetListener(this);
        Transfer[] localSelectionTransfer = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(localSelectionTransfer);
        dropTarget.addDropListener((DropTargetListener)dropListener);
    }

    private void createActions() {
        this.fOpenViewActionGroup = new OpenViewActionGroup((IWorkbenchPart)this);
        this.fOpenViewActionGroup.setSuppressTypeHierarchy(true);
        this.fOpenViewActionGroup.setSuppressProperties(true);
        this.fOpenViewActionGroup.setEnableIncludeBrowser(true);
        this.fSelectionSearchGroup = new SelectionSearchGroup((IWorkbenchSite)this.getSite());
        this.fRefactoringActionGroup = new CRefactoringActionGroup((IWorkbenchPart)this);
        this.fWorkingSetFilterUI = new WorkingSetFilterUI((IViewPart)this, this.fMemento, KEY_WORKING_SET_FILTER){

            protected void onWorkingSetChange() {
                THViewPart.this.updateWorkingSetFilter(this);
            }

            protected void onWorkingSetNameChange() {
                THViewPart.this.updateDescription();
            }
        };
        this.fHorizontalOrientation = new Action(Messages.THViewPart_HorizontalOrientation, 8){

            public void run() {
                THViewPart.this.setOrientation(1);
            }
        };
        CPluginImages.setImageDescriptors((IAction)this.fHorizontalOrientation, "lcl16/", "org.eclipse.cdt.ui.th_horizontal.gif");
        this.fVerticalOrientation = new Action(Messages.THViewPart_VerticalOrientation, 8){

            public void run() {
                THViewPart.this.setOrientation(2);
            }
        };
        CPluginImages.setImageDescriptors((IAction)this.fVerticalOrientation, "lcl16/", "org.eclipse.cdt.ui.th_vertical.gif");
        this.fAutomaticOrientation = new Action(Messages.THViewPart_AutomaticOrientation, 8){

            public void run() {
                THViewPart.this.setOrientation(0);
            }
        };
        CPluginImages.setImageDescriptors((IAction)this.fAutomaticOrientation, "lcl16/", "org.eclipse.cdt.ui.th_automatic.gif");
        this.fSingleOrientation = new Action(Messages.THViewPart_SinglePaneOrientation, 8){

            public void run() {
                THViewPart.this.setOrientation(3);
            }
        };
        CPluginImages.setImageDescriptors((IAction)this.fSingleOrientation, "lcl16/", "org.eclipse.cdt.ui.th_single.gif");
        this.fShowTypeHierarchyAction = new Action(Messages.THViewPart_CompleteTypeHierarchy, 8){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.onSetHierarchyKind(0);
                }
            }
        };
        this.fShowTypeHierarchyAction.setToolTipText(Messages.THViewPart_CompleteTypeHierarchy_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fShowTypeHierarchyAction, "lcl16/", "org.eclipse.cdt.ui.hierarchy_co.gif");
        this.fShowSubTypeHierarchyAction = new Action(Messages.THViewPart_SubtypeHierarchy, 8){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.onSetHierarchyKind(1);
                }
            }
        };
        this.fShowSubTypeHierarchyAction.setToolTipText(Messages.THViewPart_SubtypeHierarchy_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fShowSubTypeHierarchyAction, "lcl16/", "org.eclipse.cdt.ui.sub_co.gif");
        this.fShowSuperTypeHierarchyAction = new Action(Messages.THViewPart_SupertypeHierarchy, 8){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.onSetHierarchyKind(2);
                }
            }
        };
        this.fShowSuperTypeHierarchyAction.setToolTipText(Messages.THViewPart_SupertypeHierarchy_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fShowSuperTypeHierarchyAction, "lcl16/", "org.eclipse.cdt.ui.super_co.gif");
        this.fShowInheritedMembersAction = new Action(Messages.THViewPart_ShowInherited_label, 2){

            public void run() {
                THViewPart.this.onShowInheritedMembers(this.isChecked());
            }
        };
        this.fShowInheritedMembersAction.setToolTipText(Messages.THViewPart_ShowInherited_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fShowInheritedMembersAction, "lcl16/", "org.eclipse.cdt.ui.inher_co.gif");
        this.fFieldFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ICElement) {
                    ICElement node = (ICElement)element;
                    switch (node.getElementType()) {
                        case 72: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 81: 
                        case 92: {
                            return false;
                        }
                    }
                }
                return true;
            }
        };
        this.fStaticFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDeclaration) {
                    IDeclaration node = (IDeclaration)element;
                    try {
                        return !node.isStatic();
                    }
                    catch (CModelException e) {
                        CUIPlugin.log(e);
                    }
                }
                return true;
            }
        };
        this.fNonPublicFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IMember) {
                    IMember node = (IMember)element;
                    try {
                        return ASTAccessVisibility.PUBLIC.equals((Object)node.getVisibility());
                    }
                    catch (CModelException e) {
                        CUIPlugin.log(e);
                    }
                }
                return true;
            }
        };
        this.fFieldFilterAction = new Action(Messages.THViewPart_HideFields_label, 2){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.fMemberViewer.addFilter(THViewPart.this.fFieldFilter);
                } else {
                    THViewPart.this.fMemberViewer.removeFilter(THViewPart.this.fFieldFilter);
                }
            }
        };
        this.fFieldFilterAction.setToolTipText(Messages.THViewPart_HideFields_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fFieldFilterAction, "lcl16/", "org.eclipse.cdt.ui.fields_co.gif");
        this.fStaticFilterAction = new Action(Messages.THViewPart_HideStatic_label, 2){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.fMemberViewer.addFilter(THViewPart.this.fStaticFilter);
                } else {
                    THViewPart.this.fMemberViewer.removeFilter(THViewPart.this.fStaticFilter);
                }
            }
        };
        this.fStaticFilterAction.setToolTipText(Messages.THViewPart_HideStatic_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fStaticFilterAction, "lcl16/", "org.eclipse.cdt.ui.static_co.gif");
        this.fNonPublicFilterAction = new Action(Messages.THViewPart_HideNonPublic_label, 2){

            public void run() {
                if (this.isChecked()) {
                    THViewPart.this.fMemberViewer.addFilter(THViewPart.this.fNonPublicFilter);
                } else {
                    THViewPart.this.fMemberViewer.removeFilter(THViewPart.this.fNonPublicFilter);
                }
            }
        };
        this.fNonPublicFilterAction.setToolTipText(Messages.THViewPart_HideNonPublic_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fNonPublicFilterAction, "lcl16/", "org.eclipse.cdt.ui.public_co.gif");
        this.fOpenElement = new Action(Messages.THViewPart_Open){

            public void run() {
                THViewPart.this.onOpenElement(THViewPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
        this.fOpenElement.setToolTipText(Messages.THViewPart_Open_tooltip);
        this.fOpenElement.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        this.fShowFilesInLabelsAction = new Action(Messages.THViewPart_ShowFileNames, 2){

            public void run() {
                THViewPart.this.onShowFilesInLabels(this.isChecked());
            }
        };
        this.fShowFilesInLabelsAction.setToolTipText(Messages.THViewPart_ShowFileNames_tooltip);
        this.fRefreshAction = new Action(Messages.THViewPart_Refresh){

            public void run() {
                THViewPart.this.onRefresh();
            }
        };
        this.fRefreshAction.setToolTipText(Messages.THViewPart_Refresh_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fRefreshAction, "lcl16/", "org.eclipse.cdt.ui.refresh_nav.gif");
        this.fCancelAction = new Action(Messages.THViewPart_Cancel){

            public void run() {
                THViewPart.this.onCancel();
            }
        };
        this.fCancelAction.setToolTipText(Messages.THViewPart_Cancel_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fCancelAction, "lcl16/", "org.eclipse.cdt.ui.progress_stop.gif");
        this.fHistoryAction = new THHistoryDropDownAction(this);
        this.fCopyAction = new CopyTypeHierarchyAction(this, this.fClipboard, this.fHierarchyTreeViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fRefactoringActionGroup.fillActionBars(actionBars);
        this.fOpenViewActionGroup.fillActionBars(actionBars);
        this.fSelectionSearchGroup.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.OpenDeclaration", (IAction)this.fOpenElement);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        actionBars.updateActionBars();
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.add((IAction)this.fShowTypeHierarchyAction);
        tm.add((IAction)this.fShowSuperTypeHierarchyAction);
        tm.add((IAction)this.fShowSubTypeHierarchyAction);
        tm.add((IAction)this.fHistoryAction);
        tm.add((IAction)this.fRefreshAction);
        tm.add((IAction)this.fCancelAction);
        IMenuManager mm = actionBars.getMenuManager();
        this.fWorkingSetFilterUI.fillActionBars(actionBars);
        mm.add((IContributionItem)new Separator("group.show"));
        mm.add((IAction)this.fShowTypeHierarchyAction);
        mm.add((IAction)this.fShowSuperTypeHierarchyAction);
        mm.add((IAction)this.fShowSubTypeHierarchyAction);
        mm.add((IContributionItem)new Separator("group.viewerSetup"));
        MenuManager submenu = new MenuManager(Messages.THViewPart_LayoutMenu);
        submenu.add((IAction)this.fHorizontalOrientation);
        submenu.add((IAction)this.fVerticalOrientation);
        submenu.add((IAction)this.fAutomaticOrientation);
        submenu.add((IAction)this.fSingleOrientation);
        mm.appendToGroup("group.viewerSetup", (IContributionItem)submenu);
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)this.fShowFilesInLabelsAction);
        this.fMemberToolbarManager.add((IAction)this.fShowInheritedMembersAction);
        this.fMemberToolbarManager.add((IContributionItem)new Separator());
        this.fMemberToolbarManager.add((IAction)this.fFieldFilterAction);
        this.fMemberToolbarManager.add((IAction)this.fStaticFilterAction);
        this.fMemberToolbarManager.add((IAction)this.fNonPublicFilterAction);
    }

    protected void onOpenElement(ISelection selection) {
        ICElement elem = this.selectionToElement(selection);
        this.openElement(elem);
    }

    private void openElement(ICElement elem) {
        if (elem != null) {
            IWorkbenchPage page = this.getSite().getPage();
            try {
                EditorOpener.open(page, elem);
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    protected void onRefresh() {
        this.fModel.refresh();
        this.updateActionEnablement();
    }

    protected void onCancel() {
        this.fModel.stopGraphComputation();
        this.updateView();
    }

    protected void onShowFilesInLabels(boolean show) {
        this.fHierarchyLabelProvider.setShowFiles(show);
        this.fHierarchyTreeViewer.refresh();
    }

    private void updateHistory(ICElement input) {
        if (input != null) {
            this.fHistoryEntries.remove(input);
            this.fHistoryEntries.add(0, input);
            if (this.fHistoryEntries.size() > 10) {
                this.fHistoryEntries.remove(9);
            }
        }
    }

    private void updateDescription() {
        ICElement elem;
        String message = "";
        if (!this.fShowsMessage && (elem = this.getInput()) != null) {
            String label = CElementBaseLabels.getElementLabel((ICElement)elem, (int)0);
            IWorkingSet workingSet = this.fWorkingSetFilterUI.getWorkingSet();
            if (workingSet == null) {
                message = label;
            } else {
                String scope = workingSet.getLabel();
                message = MessageFormat.format((String)"{0} - {1}", (Object[])new Object[]{label, scope});
            }
            label = "";
            Image image = null;
            THNode node = this.fModel.getSelectionInHierarchy();
            if (node != null && (elem = node.getElement()) != null) {
                label = CElementBaseLabels.getElementLabel((ICElement)elem, (int)0);
                image = this.fHierarchyLabelProvider.getImage(elem);
            }
            this.fMemberLabel.setText(label);
            this.fMemberLabel.setImage(image);
        }
        this.setContentDescription(message);
    }

    private void updateActionEnablement() {
        this.fHistoryAction.setEnabled(!this.fHistoryEntries.isEmpty());
        this.fRefreshAction.setEnabled(!this.fShowsMessage);
        this.fCancelAction.setEnabled(!this.fShowsMessage && !this.fModel.isComputed());
        this.fShowSubTypeHierarchyAction.setEnabled(!this.fShowsMessage);
        this.fShowSuperTypeHierarchyAction.setEnabled(!this.fShowsMessage);
        this.fShowTypeHierarchyAction.setEnabled(!this.fShowsMessage);
    }

    private void updateWorkingSetFilter(WorkingSetFilterUI filterUI) {
        this.fModel.setWorkingSetFilter(filterUI);
        this.updateView();
    }

    public void onSetHierarchyKind(int kind) {
        if (this.fModel.getHierarchyKind() != kind) {
            this.fModel.setHierarchyKind(kind);
            this.updateView();
        }
    }

    protected void onShowInheritedMembers(boolean show) {
        if (this.fModel.isShowInheritedMembers() != show) {
            this.fModel.setShowInheritedMembers(show);
            this.fMemberLabelProvider.setTextFlags(show ? 69210177 : 1);
            this.updateViewers();
        }
    }

    private void updateViewers() {
        if (!this.fShowsMessage) {
            ++this.fIgnoreSelectionChanges;
            try {
                this.fHierarchyLabelProvider.setMarkImplementers(!this.fModel.hasTrivialHierarchy());
                this.fHierarchyTreeViewer.refresh();
                this.fMemberViewer.refresh();
                this.setSelections();
            }
            finally {
                --this.fIgnoreSelectionChanges;
            }
        }
    }

    private void updateView() {
        if (!this.fShowsMessage) {
            ++this.fIgnoreSelectionChanges;
            try {
                this.updateViewers();
                this.updateDescription();
                this.updateActionEnablement();
            }
            finally {
                --this.fIgnoreSelectionChanges;
            }
        }
    }

    private void setSelections() {
        ++this.fIgnoreSelectionChanges;
        try {
            ICElement elem;
            THNode node = this.fModel.getSelectionInHierarchy();
            if (node != null) {
                this.fHierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
                this.fHierarchyTreeViewer.expandToLevel((Object)node, 1);
            }
            if ((elem = this.fModel.getSelectedMember()) != null) {
                this.fMemberViewer.setSelection((ISelection)new StructuredSelection((Object)elem));
            }
        }
        finally {
            --this.fIgnoreSelectionChanges;
        }
    }

    private ICElement selectionToElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object cand : ss) {
                ICElement elem;
                if (cand instanceof ICElement) {
                    return (ICElement)cand;
                }
                if (!(cand instanceof IAdaptable) || (elem = (ICElement)((IAdaptable)cand).getAdapter(ICElement.class)) == null) continue;
                return elem;
            }
        }
        return null;
    }

    private THNode selectionToNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object cand : ss) {
                if (!(cand instanceof THNode)) continue;
                return (THNode)cand;
            }
        }
        return null;
    }

    public Control getPageBook() {
        return this.fPagebook;
    }

    public ICElement[] getHistoryEntries() {
        return this.fHistoryEntries.toArray(new ICElement[this.fHistoryEntries.size()]);
    }

    public void setHistoryEntries(ICElement[] remaining) {
        this.fHistoryEntries.clear();
        this.fHistoryEntries.addAll(Arrays.asList(remaining));
    }

    ICElement getInput() {
        ICElement input = this.fModel.getInput();
        if (input instanceof ICElement) {
            return input;
        }
        return null;
    }

    public TreeViewer getHiearchyViewer() {
        return this.fHierarchyTreeViewer;
    }

    public TableViewer getMemberViewer() {
        return this.fMemberViewer;
    }

    private void restoreOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                this.fHorizontalOrientation.setChecked(true);
                break;
            }
            case 2: {
                this.fVerticalOrientation.setChecked(true);
                break;
            }
            case 3: {
                this.fSingleOrientation.setChecked(true);
                break;
            }
            default: {
                orientation = 0;
                this.fAutomaticOrientation.setChecked(true);
            }
        }
        this.setOrientation(orientation);
    }

    private void restoreHierarchyKind(int kind) {
        switch (kind) {
            case 1: {
                this.fShowSubTypeHierarchyAction.setChecked(true);
                break;
            }
            case 2: {
                this.fShowSuperTypeHierarchyAction.setChecked(true);
                break;
            }
            default: {
                kind = 0;
                this.fShowTypeHierarchyAction.setChecked(true);
            }
        }
        this.fModel.setHierarchyKind(kind);
    }

    public void setOrientation(int orientation) {
        if (this.fInComputeOrientation) {
            return;
        }
        this.fInComputeOrientation = true;
        try {
            if (this.fCurrentViewOrientation != orientation) {
                if (this.fSplitter != null && !this.fSplitter.isDisposed()) {
                    if (orientation == 0) {
                        orientation = this.getBestOrientation();
                    }
                    if (orientation == 3) {
                        this.fMemberViewForm.setVisible(false);
                    } else {
                        if (this.fCurrentViewOrientation == 3) {
                            this.fMemberViewForm.setVisible(true);
                        }
                        boolean horizontal = orientation == 1;
                        this.fSplitter.setOrientation(horizontal ? 256 : 512);
                    }
                    this.fSplitter.layout();
                }
                this.fCurrentViewOrientation = orientation;
            }
        }
        finally {
            this.fInComputeOrientation = false;
        }
    }

    private int getBestOrientation() {
        Point size = this.fSplitter.getSize();
        if (size.x != 0 && size.y != 0 && 3 * size.x < 2 * size.y) {
            return 2;
        }
        return 1;
    }

    public void onEvent(int event) {
        switch (event) {
            case 0: {
                this.updateView();
            }
        }
    }

    public IWorkbenchSiteProgressService getProgressService() {
        return (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
    }

    private static class CopyTypeHierarchyAction
    extends CopyTreeAction {
        public CopyTypeHierarchyAction(ViewPart view, Clipboard clipboard, TreeViewer viewer) {
            super(Messages.THViewPart_CopyTypeHierarchy, view, clipboard, viewer);
        }
    }
}

