/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.ProjectConfigsController;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

class WorkingSetConfigsController
implements SelectionListener,
ISelectionChangedListener {
    private TreeViewer tree;
    private Button addButton;
    private Button removeButton;
    private Button renameButton;
    private Button activateButton;
    private Button buildButton;
    private IWorkingSetProxy.ISnapshot initialWorkingSet;
    private IWorkingSetProxy.ISnapshot currentWorkingSet;
    private IWorkingSetConfiguration.ISnapshot currentConfig;
    private final WorkspaceSnapshot workspace;
    private ProjectConfigsController projectsController;

    WorkingSetConfigsController(WorkspaceSnapshot workspace, IWorkingSetProxy.ISnapshot initialWorkingSet) {
        this.workspace = workspace;
        if (initialWorkingSet != null) {
            this.initialWorkingSet = initialWorkingSet;
        } else {
            IWorkingSet[] recent = WorkingSetConfigurationManager.WS_MGR.getRecentWorkingSets();
            if (recent != null && recent.length > 0) {
                this.initialWorkingSet = workspace.getWorkingSet(recent[0].getName());
            }
        }
    }

    WorkingSetConfigsController(WorkspaceSnapshot workspace) {
        this(workspace, null);
    }

    void setTreeViewer(final TreeViewer tree) {
        if (this.tree != null) {
            this.tree.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.tree = tree;
        if (this.tree != null) {
            this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
            this.tree.setInput(this.workspace.getWorkingSets());
            if (!this.workspace.getWorkingSets().isEmpty()) {
                tree.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StructuredSelection sel;
                        Object initialSelection;
                        ITreeContentProvider content = (ITreeContentProvider)tree.getContentProvider();
                        Object[] children = content.getChildren(initialSelection = WorkingSetConfigsController.this.initialWorkingSet != null && Arrays.asList(content.getElements(tree.getInput())).contains(WorkingSetConfigsController.this.initialWorkingSet) ? WorkingSetConfigsController.this.initialWorkingSet : tree.getTree().getItem(0).getData());
                        if (children == null || children.length == 0) {
                            sel = new StructuredSelection(initialSelection);
                        } else {
                            Object[] toSort = new Object[children.length];
                            System.arraycopy(children, 0, toSort, 0, children.length);
                            tree.getComparator().sort((Viewer)tree, toSort);
                            sel = new StructuredSelection(toSort[0]);
                        }
                        tree.setSelection((ISelection)sel, true);
                    }
                });
            }
        }
    }

    private Button updateButton(Button oldButton, Button newButton) {
        if (oldButton != null) {
            oldButton.removeSelectionListener((SelectionListener)this);
        }
        if (newButton != null) {
            newButton.addSelectionListener((SelectionListener)this);
        }
        return newButton;
    }

    void setAddButton(Button addButton) {
        this.addButton = this.updateButton(this.addButton, addButton);
    }

    void setRemoveButton(Button removeButton) {
        this.removeButton = this.updateButton(this.removeButton, removeButton);
    }

    void setRenameButton(Button renameButton) {
        this.renameButton = this.updateButton(this.renameButton, renameButton);
    }

    void setActivateButton(Button activateButton) {
        this.activateButton = this.updateButton(this.activateButton, activateButton);
    }

    void setBuildButton(Button buildButton) {
        this.buildButton = this.updateButton(this.buildButton, buildButton);
    }

    void setProjectConfigsController(ProjectConfigsController controller) {
        this.projectsController = controller;
        if (controller != null) {
            controller.setWorkingSetConfiguration(this.currentConfig);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.addConfig();
        } else if (e.widget == this.removeButton) {
            this.removeConfig();
        } else if (e.widget == this.renameButton) {
            this.renameConfig();
        } else if (e.widget == this.activateButton) {
            this.activateConfig();
        } else if (e.widget == this.buildButton) {
            this.buildConfig();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel;
        this.currentConfig = null;
        this.currentWorkingSet = null;
        if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
            Object first = sel.getFirstElement();
            if (first instanceof IWorkingSetConfiguration) {
                this.currentConfig = (IWorkingSetConfiguration.ISnapshot)first;
                this.currentWorkingSet = this.currentConfig.getWorkingSet();
            } else if (first instanceof IWorkingSetProxy) {
                this.currentWorkingSet = (IWorkingSetProxy.ISnapshot)first;
            }
        }
        if (this.projectsController != null) {
            this.projectsController.setWorkingSetConfiguration(this.currentConfig);
        }
        this.updateButtons();
    }

    private void addConfig() {
        InputDialog dlg = new InputDialog(this.tree.getTree().getShell(), WorkingSetMessages.WSConfigsController_addDlg_title, WorkingSetMessages.WSConfigsController_addDlg_msg, WorkingSetMessages.WSConfigsController_addDlg_defaultName, new IInputValidator(){

            public String isValid(String newText) {
                if (WorkingSetConfigsController.this.currentWorkingSet.getConfiguration(newText) != null) {
                    return WorkingSetMessages.WSConfigsController_addDlg_nameExists;
                }
                if (newText.length() == 0) {
                    return WorkingSetMessages.WSConfigsController_addDlg_emptyName;
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            IWorkingSetConfiguration.ISnapshot newConfig = this.currentWorkingSet.createConfiguration(dlg.getValue());
            this.tree.refresh((Object)this.currentWorkingSet);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)newConfig), true);
            this.currentConfig = newConfig;
            this.currentWorkingSet = this.currentConfig.getWorkingSet();
            IWorkingSet ws = this.currentWorkingSet.resolve();
            if (ws != null) {
                WorkingSetConfigurationManager.WS_MGR.addRecentWorkingSet(ws);
            }
        }
    }

    private void removeConfig() {
        this.currentWorkingSet.removeConfiguration(this.currentConfig);
        this.tree.refresh((Object)this.currentWorkingSet);
    }

    private void renameConfig() {
        InputDialog dlg = new InputDialog(this.tree.getTree().getShell(), WorkingSetMessages.WSConfigsController_renameDlg_title, WorkingSetMessages.WSConfigsController_renameDlg_msg, this.currentConfig.getName(), new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals(WorkingSetConfigsController.this.currentConfig.getName())) {
                    return "";
                }
                if (WorkingSetConfigsController.this.currentWorkingSet.getConfiguration(newText) != null) {
                    return WorkingSetMessages.WSConfigsController_addDlg_nameExists;
                }
                if (newText.length() == 0) {
                    return WorkingSetMessages.WSConfigsController_addDlg_emptyName;
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            this.currentConfig.setName(dlg.getValue());
            this.tree.refresh((Object)this.currentWorkingSet);
        }
    }

    private void activateConfig() {
        this.currentConfig.activate();
        this.projectsController.update();
        this.updateForActivation();
    }

    private void updateForActivation() {
        HashSet<IWorkingSetProxy.ISnapshot> unaffectedWorkingSets = new HashSet<IWorkingSetProxy.ISnapshot>(this.workspace.getWorkingSets());
        for (IProject project : this.currentConfig.getWorkingSet().resolveProjects()) {
            Iterator iter = unaffectedWorkingSets.iterator();
            while (iter.hasNext()) {
                IWorkingSetProxy.ISnapshot next = (IWorkingSetProxy.ISnapshot)iter.next();
                if (!next.resolveProjects().contains(project)) continue;
                iter.remove();
                if (next.updateActiveConfigurations()) {
                    this.tree.refresh((Object)next);
                    continue;
                }
                for (IWorkingSetConfiguration config : next.getConfigurations()) {
                    this.tree.update((Object)config, null);
                }
            }
        }
        this.updateButtons();
    }

    private void buildConfig() {
        final IStatus[] problem = new IStatus[1];
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.tree.getControl().getShell());
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    IStatus status = WorkingSetConfigsController.this.currentConfig.build(monitor);
                    if (status.matches(6)) {
                        problem[0] = status;
                    }
                }
            });
        }
        catch (Exception e) {
            CUIPlugin.log(WorkingSetMessages.WSConfigsController_buildFailedLog, e);
        }
        this.updateForActivation();
        if (problem[0] != null) {
            ErrorDialog.openError((Shell)this.tree.getControl().getShell(), (String)WorkingSetMessages.WSConfigsController_buildFailedDlgTitle, (String)WorkingSetMessages.WSConfigsController_buildFailedDlgMsg, (IStatus)problem[0]);
        }
    }

    private void updateButtons() {
        if (this.addButton != null) {
            this.addButton.setEnabled(this.currentWorkingSet != null);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(this.currentConfig != null && !this.currentConfig.isReadOnly());
        }
        if (this.renameButton != null) {
            this.renameButton.setEnabled(this.currentConfig != null && !this.currentConfig.isReadOnly());
        }
        if (this.activateButton != null) {
            this.activateButton.setEnabled(this.currentConfig != null && !this.currentConfig.isActive());
        }
        if (this.buildButton != null) {
            this.buildButton.setEnabled(this.currentConfig != null);
        }
    }

    void projectSelectionsChanged(IWorkingSetProjectConfiguration project) {
        this.tree.update((Object)this.currentConfig, null);
        this.updateButtons();
    }
}

