/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.RegularExpressionStatusDialog;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class RegexErrorParserOptionPage
extends AbstractCOptionPage {
    private static final String WORKSPACE_PREFERENCE_PAGE = "org.eclipse.cdt.make.ui.preferences.BuildSettings";
    private static final int BUTTON_ADD = 0;
    private static final int BUTTON_DELETE = 1;
    private static final int BUTTON_MOVEUP = 2;
    private static final int BUTTON_MOVEDOWN = 3;
    private static final String[] BUTTONS = new String[]{AbstractCPropertyTab.ADD_STR, AbstractCPropertyTab.DEL_STR, AbstractCPropertyTab.MOVEUP_STR, AbstractCPropertyTab.MOVEDOWN_STR};
    private static final String OOPS = "OOPS";
    private Table fTable;
    private TableViewer fTableViewer;
    private Button[] fButtons = null;
    private RegexErrorParser fErrorParser;
    private boolean fEditable;

    public RegexErrorParserOptionPage(RegexErrorParser errorparser, boolean editable) {
        this.fErrorParser = errorparser;
        this.fEditable = editable;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(DialogsMessages.RegexErrorParserOptionPage_Title);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginRight = -10;
        gridLayout.marginLeft = -4;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.marginRight = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        if (!this.fEditable) {
            this.createLinkToPreferences(composite);
        }
        this.createPatternsTable(group, composite);
        if (this.fEditable) {
            this.createButtons(composite);
        }
        this.setControl((Control)group);
        group.update();
    }

    private void createLinkToPreferences(final Composite parent) {
        Assert.isTrue((!this.fEditable ? 1 : 0) != 0);
        Link link = new Link(parent, 0);
        link.setText(DialogsMessages.RegexErrorParserOptionPage_LinkToPreferencesMessage);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)RegexErrorParserOptionPage.WORKSPACE_PREFERENCE_PAGE, null, null).open();
                IErrorParserNamed errorParser = ErrorParserManager.getErrorParserCopy((String)RegexErrorParserOptionPage.this.fErrorParser.getId());
                if (errorParser instanceof RegexErrorParser) {
                    RegexErrorParserOptionPage.this.fErrorParser = (RegexErrorParser)errorParser;
                } else {
                    RegexErrorParserOptionPage.this.fErrorParser = null;
                }
                RegexErrorParserOptionPage.this.initializeTable();
            }
        });
        GridData gridData = new GridData(4, 1024, true, false);
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
    }

    private static RegexErrorPattern newDummyPattern() {
        return new RegexErrorPattern(null, null, null, null, null, 2, true);
    }

    private static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return DialogsMessages.RegexErrorParserOptionPage_SeverityInfo;
            }
            case 1: {
                return DialogsMessages.RegexErrorParserOptionPage_SeverityWarning;
            }
            case 2: 
            case 3: {
                return DialogsMessages.RegexErrorParserOptionPage_SeverityError;
            }
        }
        return DialogsMessages.RegexErrorParserOptionPage_SeverityIgnore;
    }

    private void initializeTable() {
        int len;
        RegexErrorPattern[] errorParserPatterns;
        errorParserPatterns = this.fErrorParser != null ? (errorParserPatterns = this.fErrorParser.getPatterns()) : new RegexErrorPattern[]{};
        int newLen = len = errorParserPatterns.length;
        RegexErrorPattern[] tablePatterns = new RegexErrorPattern[newLen];
        System.arraycopy(errorParserPatterns, 0, tablePatterns, 0, len);
        this.fTableViewer.setInput((Object)tablePatterns);
        this.fTableViewer.refresh();
    }

    private void createPatternsTable(Group group, Composite parent) {
        TableLayoutComposite tableLayouter = new TableLayoutComposite(parent, 0);
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        tableLayouter.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        int style = 2816;
        if (this.fEditable) {
            style |= 0x10000;
        }
        this.fTable = new Table((Composite)tableLayouter, style);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.fTable.setEnabled(this.fEditable);
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint(this.fTable, 10);
        gridData.widthHint = new PixelConverter((Control)group).convertWidthInCharsToPixels(100);
        tableLayouter.setLayoutData(gridData);
        this.fTable.setLayout((Layout)new TableLayout());
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegexErrorParserOptionPage.this.updateButtons();
            }
        });
        this.fTableViewer = new TableViewer(this.fTable);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createSeverityColumn();
        this.createPatternColumn();
        this.createFileColumn();
        this.createLineColumn();
        this.createDescriptionColumn();
        this.createEatLineColumn();
        this.initializeTable();
    }

    private void createSeverityColumn() {
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_SeverityColumn);
        columnViewer.getColumn().setResizable(true);
        columnViewer.getColumn().setToolTipText(DialogsMessages.RegexErrorParserOptionPage_TooltipSeverity);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            final ISharedImages images = PlatformUI.getWorkbench().getSharedImages();

            public Image getImage(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regexErrorPattern = (RegexErrorPattern)element;
                    switch (regexErrorPattern.getSeverity()) {
                        case 0: {
                            return this.images.getImage("IMG_OBJS_INFO_TSK");
                        }
                        case 1: {
                            return this.images.getImage("IMG_OBJS_WARN_TSK");
                        }
                        case 2: 
                        case 3: {
                            return this.images.getImage("IMG_OBJS_ERROR_TSK");
                        }
                        case -1: {
                            return this.images.getImage("IMG_ELCL_REMOVE_DISABLED");
                        }
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regex = (RegexErrorPattern)element;
                    return RegexErrorParserOptionPage.severityToString(regex.getSeverity());
                }
                return RegexErrorParserOptionPage.severityToString(-1);
            }
        });
        columnViewer.setEditingSupport(new EditingSupport((ColumnViewer)this.fTableViewer){
            final String[] severityComboBoxArray;
            {
                this.severityComboBoxArray = new String[]{RegexErrorParserOptionPage.severityToString(2), RegexErrorParserOptionPage.severityToString(1), RegexErrorParserOptionPage.severityToString(0), RegexErrorParserOptionPage.severityToString(-1)};
            }

            private int severityToIndex(int severity) {
                String strSeverity = RegexErrorParserOptionPage.severityToString(severity);
                int i = 0;
                while (i < this.severityComboBoxArray.length) {
                    if (strSeverity.equals(this.severityComboBoxArray[i])) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }

            private int indexToSeverity(int index) {
                String strCombo = this.severityComboBoxArray[index];
                int i = 0;
                while (i < this.severityComboBoxArray.length) {
                    if (RegexErrorParserOptionPage.severityToString(i).equals(strCombo)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            protected boolean canEdit(Object element) {
                return element instanceof RegexErrorPattern && RegexErrorParserOptionPage.this.fEditable;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)RegexErrorParserOptionPage.this.fTableViewer.getTable(), this.severityComboBoxArray, 8);
            }

            protected Object getValue(Object element) {
                if (element instanceof RegexErrorPattern) {
                    return this.severityToIndex(((RegexErrorPattern)element).getSeverity());
                }
                return -1;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof RegexErrorPattern && value instanceof Integer) {
                    ((RegexErrorPattern)element).setSeverity(this.indexToSeverity((Integer)value));
                    RegexErrorParserOptionPage.this.fTableViewer.update(element, null);
                }
            }
        });
    }

    private void createPatternColumn() {
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_Pattern_Column);
        columnViewer.getColumn().setResizable(true);
        columnViewer.getColumn().setToolTipText(DialogsMessages.RegexErrorParserOptionPage_TooltipPattern);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regex = (RegexErrorPattern)element;
                    String pattern = regex.getPattern();
                    return pattern;
                }
                return RegexErrorParserOptionPage.OOPS;
            }
        });
        columnViewer.setEditingSupport((EditingSupport)new RegexPatternEditingSupport(this.fTableViewer, true){

            protected Object getFromPattern(RegexErrorPattern regexErrorPattern) {
                return regexErrorPattern.getPattern();
            }

            protected void setToPattern(RegexErrorPattern regexErrorPattern, String value) {
                if (!RegexErrorParserOptionPage.this.fEditable) {
                    return;
                }
                try {
                    regexErrorPattern.setPattern(value);
                }
                catch (Exception exception) {
                    RegexErrorParserOptionPage.this.fEditable = false;
                    RegularExpressionStatusDialog dialog = new RegularExpressionStatusDialog(RegexErrorParserOptionPage.this.getShell(), value);
                    if (dialog.open() == 0) {
                        regexErrorPattern.setPattern(dialog.getValue());
                    }
                    RegexErrorParserOptionPage.this.fEditable = true;
                }
            }
        });
    }

    private void createFileColumn() {
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_FileColumn);
        columnViewer.getColumn().setToolTipText(DialogsMessages.RegexErrorParserOptionPage_TooltipFile);
        columnViewer.getColumn().setResizable(true);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regex = (RegexErrorPattern)element;
                    return regex.getFileExpression();
                }
                return RegexErrorParserOptionPage.OOPS;
            }
        });
        columnViewer.setEditingSupport((EditingSupport)new RegexPatternEditingSupport(this.fTableViewer, false){

            protected Object getFromPattern(RegexErrorPattern regexErrorPattern) {
                return regexErrorPattern.getFileExpression();
            }

            protected void setToPattern(RegexErrorPattern regexErrorPattern, String value) {
                regexErrorPattern.setFileExpression(value);
            }
        });
    }

    private void createLineColumn() {
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_LineColumn);
        columnViewer.getColumn().setResizable(true);
        columnViewer.getColumn().setToolTipText(DialogsMessages.RegexErrorParserOptionPage_TooltipLine);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regex = (RegexErrorPattern)element;
                    return regex.getLineExpression();
                }
                return RegexErrorParserOptionPage.OOPS;
            }
        });
        columnViewer.setEditingSupport((EditingSupport)new RegexPatternEditingSupport(this.fTableViewer, false){

            protected Object getFromPattern(RegexErrorPattern regexErrorPattern) {
                return regexErrorPattern.getLineExpression();
            }

            protected void setToPattern(RegexErrorPattern regexErrorPattern, String value) {
                regexErrorPattern.setLineExpression(value);
            }
        });
    }

    private void createDescriptionColumn() {
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_DescriptionColumn);
        columnViewer.getColumn().setResizable(true);
        columnViewer.getColumn().setToolTipText(DialogsMessages.RegexErrorParserOptionPage_TooltipDescription);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RegexErrorPattern) {
                    RegexErrorPattern regex = (RegexErrorPattern)element;
                    return regex.getDescriptionExpression();
                }
                return RegexErrorParserOptionPage.OOPS;
            }
        });
        columnViewer.setEditingSupport((EditingSupport)new RegexPatternEditingSupport(this.fTableViewer, false){

            protected Object getFromPattern(RegexErrorPattern regexErrorPattern) {
                return regexErrorPattern.getDescriptionExpression();
            }

            protected void setToPattern(RegexErrorPattern regexErrorPattern, String value) {
                regexErrorPattern.setDescriptionExpression(value);
            }
        });
    }

    private void createEatLineColumn() {
        final String EAT_NO = DialogsMessages.RegexErrorParserOptionPage_ConsumeNo;
        final String EAT_YES = DialogsMessages.RegexErrorParserOptionPage_ConsumeYes;
        final String[] eatLineComboBoxArray = new String[]{EAT_YES, EAT_NO};
        TableViewerColumn columnViewer = new TableViewerColumn(this.fTableViewer, 0);
        columnViewer.getColumn().setText(DialogsMessages.RegexErrorParserOptionPage_EatColumn);
        columnViewer.getColumn().setResizable(true);
        String message = MessageFormat.format((String)DialogsMessages.RegexErrorParserOptionPage_TooltipConsume, (Object[])new Object[]{EAT_NO});
        columnViewer.getColumn().setToolTipText(message);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RegexErrorPattern regex;
                if (element instanceof RegexErrorPattern && !(regex = (RegexErrorPattern)element).isEatProcessedLine()) {
                    return EAT_NO;
                }
                return EAT_YES;
            }
        });
        columnViewer.setEditingSupport(new EditingSupport((ColumnViewer)this.fTableViewer){

            protected boolean canEdit(Object element) {
                return element instanceof RegexErrorPattern && RegexErrorParserOptionPage.this.fEditable;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)RegexErrorParserOptionPage.this.fTableViewer.getTable(), eatLineComboBoxArray, 8);
            }

            protected Object getValue(Object element) {
                if (element instanceof RegexErrorPattern && !((RegexErrorPattern)element).isEatProcessedLine()) {
                    return 1;
                }
                return 0;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof RegexErrorPattern && value instanceof Integer) {
                    ((RegexErrorPattern)element).setEatProcessedLine((Integer)value != 1);
                    RegexErrorParserOptionPage.this.fTableViewer.update(element, null);
                }
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fButtons = new Button[BUTTONS.length];
        int i = 0;
        while (i < BUTTONS.length) {
            this.fButtons[i] = new Button(composite, 8);
            GridData gridData = new GridData(4, 0x1000000, false, false);
            gridData.minimumWidth = 80;
            if (BUTTONS[i] != null) {
                this.fButtons[i].setText(BUTTONS[i]);
                this.fButtons[i].setEnabled(false);
            } else {
                this.fButtons[i].setVisible(false);
                this.fButtons[i].setEnabled(false);
                gridData.heightHint = 10;
            }
            this.fButtons[i].setLayoutData((Object)gridData);
            this.fButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int i = 0;
                    while (i < RegexErrorParserOptionPage.this.fButtons.length) {
                        if (RegexErrorParserOptionPage.this.fButtons[i].equals(event.widget)) {
                            RegexErrorParserOptionPage.this.buttonPressed(i);
                            return;
                        }
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.fButtons != null) {
            int pos = this.fTable.getSelectionIndex();
            int count = this.fTable.getItemCount();
            int last = count - 1;
            boolean selected = pos >= 0 && pos <= last;
            this.fButtons[0].setEnabled(true);
            this.fButtons[1].setEnabled(selected);
            this.fButtons[2].setEnabled(selected && pos != 0);
            this.fButtons[3].setEnabled(selected && pos != last);
        }
    }

    private void buttonPressed(int button) {
        switch (button) {
            case 0: {
                this.addErrorPattern();
                break;
            }
            case 1: {
                this.deleteErrorPattern();
                break;
            }
            case 2: {
                this.moveItem(true);
                break;
            }
            case 3: {
                this.moveItem(false);
                break;
            }
        }
        this.updateButtons();
    }

    private void addErrorPattern() {
        int pos = this.fTable.getSelectionIndex();
        int last = this.fTable.getItemCount() - 1;
        if (pos < 0 || pos > last) {
            pos = last;
        }
        int newPos = pos + 1;
        this.fTableViewer.insert((Object)RegexErrorParserOptionPage.newDummyPattern(), newPos);
        this.fTable.setSelection(newPos);
    }

    private void deleteErrorPattern() {
        int pos = this.fTable.getSelectionIndex();
        int last = this.fTable.getItemCount() - 1;
        if (pos >= 0 && pos <= last) {
            this.fTableViewer.remove(this.fTableViewer.getElementAt(pos));
            this.fTable.setSelection(pos);
        }
    }

    private void moveItem(boolean up) {
        boolean selected;
        int pos = this.fTable.getSelectionIndex();
        int count = this.fTable.getItemCount();
        int last = count - 1;
        boolean bl = selected = pos >= 0 && pos <= last;
        if (!selected || up && pos == 0 || !up && pos == last) {
            return;
        }
        Object item = this.fTableViewer.getElementAt(pos);
        this.fTableViewer.remove(item);
        int newPos = up ? pos - 1 : pos + 1;
        this.fTableViewer.insert(item, newPos);
        this.fTable.setSelection(newPos);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.fErrorParser != null && this.fEditable) {
            this.fErrorParser.clearPatterns();
            TableItem[] tableItemArray = this.fTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                Object item = tableItem.getData();
                if (item instanceof RegexErrorPattern) {
                    this.fErrorParser.addPattern((RegexErrorPattern)item);
                }
                ++n2;
            }
        }
    }

    public void performDefaults() {
    }

    private abstract class RegexPatternEditingSupport
    extends EditingSupport {
        private final TableViewer tableViewer;

        public RegexPatternEditingSupport(TableViewer viewer, boolean isFindStyle) {
            super((ColumnViewer)viewer);
            this.tableViewer = viewer;
        }

        protected boolean canEdit(Object element) {
            return RegexErrorParserOptionPage.this.fEditable;
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor editor = new TextCellEditor((Composite)this.tableViewer.getTable());
            return editor;
        }

        protected abstract Object getFromPattern(RegexErrorPattern var1);

        protected Object getValue(Object element) {
            if (element instanceof RegexErrorPattern) {
                RegexErrorPattern regexErrorPattern = (RegexErrorPattern)element;
                return this.getFromPattern(regexErrorPattern);
            }
            return RegexErrorParserOptionPage.OOPS;
        }

        protected abstract void setToPattern(RegexErrorPattern var1, String var2);

        protected void setValue(Object element, Object value) {
            if (element instanceof RegexErrorPattern && value instanceof String) {
                String stringValue = (String)value;
                RegexErrorPattern errorPattern = (RegexErrorPattern)element;
                this.setToPattern(errorPattern, stringValue);
                this.tableViewer.update(element, null);
            }
        }
    }
}

