/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.ExPatternEntryDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExPatternDialog
extends StatusDialog {
    private ListDialogField<String> fExclusionPatternList;
    private IProject fCurrProject;
    private IPath[] pattern;
    private IPath path;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;

    public ExPatternDialog(Shell parent, IPath[] _data, IPath _path, IProject proj) {
        super(parent);
        this.fCurrProject = proj;
        this.pattern = _data;
        this.path = _path;
        this.setTitle(CPathEntryMessages.ExclusionPatternDialog_title);
        String label = NLS.bind((String)CPathEntryMessages.ExclusionPatternDialog_pattern_label, (Object)this.path.makeRelative().toString());
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.ExclusionPatternDialog_pattern_add;
        stringArray[1] = CPathEntryMessages.ExclusionPatternDialog_pattern_add_multiple;
        stringArray[2] = CPathEntryMessages.ExclusionPatternDialog_pattern_edit;
        stringArray[4] = CPathEntryMessages.ExclusionPatternDialog_pattern_remove;
        String[] buttonLabels = stringArray;
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        this.fExclusionPatternList = new ListDialogField<String>(adapter, buttonLabels, (IBaseLabelProvider)new ExPatternLabelProvider());
        this.fExclusionPatternList.setDialogFieldListener(adapter);
        this.fExclusionPatternList.setLabelText(label);
        this.fExclusionPatternList.setRemoveButtonIndex(4);
        this.fExclusionPatternList.enableButton(2, false);
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        IResource res = root.findMember(this.path);
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        ArrayList<String> elements = new ArrayList<String>(this.pattern.length);
        IPath[] iPathArray = this.pattern;
        int n = this.pattern.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            elements.add(p.toString());
            ++n2;
        }
        this.fExclusionPatternList.setElements(elements);
        this.fExclusionPatternList.selectFirstElement();
        this.fExclusionPatternList.enableButton(1, this.fCurrSourceFolder != null);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.fExclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        ExPatternDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doCustomButtonPressed(ListDialogField<String> field, int index) {
        if (index == 0) {
            this.addEntry();
        } else if (index == 2) {
            this.editEntry();
        } else if (index == 1) {
            this.addMultipleEntries();
        }
    }

    protected void doDoubleClicked(ListDialogField<String> field) {
        this.editEntry();
    }

    protected void doSelectionChanged(ListDialogField<String> field) {
        List<String> selected = field.getSelectedElements();
        this.fExclusionPatternList.enableButton(2, this.canEdit(selected));
    }

    private boolean canEdit(List<?> selected) {
        return selected.size() == 1;
    }

    private void editEntry() {
        List<String> selElements = this.fExclusionPatternList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        List<String> existing = this.fExclusionPatternList.getElements();
        String entry = selElements.get(0);
        ExPatternEntryDialog dialog = new ExPatternEntryDialog(this.getShell(), entry, existing, this.fCurrProject, this.path);
        if (dialog.open() == 0) {
            this.fExclusionPatternList.replaceElement(entry, dialog.getExclusionPattern());
        }
    }

    private void addEntry() {
        List<String> existing = this.fExclusionPatternList.getElements();
        ExPatternEntryDialog dialog = new ExPatternEntryDialog(this.getShell(), null, existing, this.fCurrProject, this.path);
        if (dialog.open() == 0) {
            this.fExclusionPatternList.addElement(dialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    public IPath[] getExclusionPattern() {
        IPath[] res = new IPath[this.fExclusionPatternList.getSize()];
        int i = 0;
        while (i < res.length) {
            String entry = this.fExclusionPatternList.getElement(i);
            res[i] = new Path(entry);
            ++i;
        }
        return res;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected boolean isResizable() {
        return true;
    }

    private void addMultipleEntries() {
        Class[] acceptedClasses = new Class[]{IFolder.class, IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Object initialElement = null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(CPathEntryMessages.ExclusionPatternDialog_ChooseExclusionPattern_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(CPathEntryMessages.ExclusionPatternDialog_ChooseExclusionPattern_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrSourceFolder);
        dialog.setInitialSelection(initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            int existingSegments = this.fCurrSourceFolder.getFullPath().segmentCount();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IResource curr = (IResource)object;
                IPath path = curr.getFullPath().removeFirstSegments(existingSegments).makeRelative();
                String res = curr instanceof IContainer ? path.addTrailingSeparator().toString() : path.toString();
                this.fExclusionPatternList.addElement(res);
                ++n2;
            }
        }
    }

    private static class ExPatternLabelProvider
    extends LabelProvider {
        private ExPatternLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = CUIPlugin.getImageDescriptorRegistry();
            return registry.get(CPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
        }

        public String getText(Object element) {
            return (String)element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExclusionPatternAdapter
    implements IListAdapter<String>,
    IDialogFieldListener {
        private ExclusionPatternAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<String> field, int index) {
            ExPatternDialog.this.doCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField<String> field) {
            ExPatternDialog.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField<String> field) {
            ExPatternDialog.this.doDoubleClicked(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

