/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.ui.newui.INewCfgDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends Dialog
implements INewCfgDialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String GROUP = "NewConfiguration.label.group";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private static final String CASE = "NewConfiguration.error.caseName";
    private static final String INVALID = "NewConfiguration.error.invalidName";
    private static final String DESCRIPTION = "NewConfiguration.label.description";
    private Text configName;
    private Text configDescription;
    private Combo cloneConfigSelector;
    private Label statusLabel;
    private ICProjectDescription des;
    private ICConfigurationDescription[] cfgds;
    private ICConfigurationDescription parentConfig;
    private String newName;
    private String newDescription;
    private String title;

    protected NewConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.newDescription = new String();
    }

    public void setProject(ICProjectDescription prj) {
        this.des = prj;
        this.cfgds = this.des.getConfigurations();
    }

    public void setTitle(String _title) {
        this.title = _title;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String description = new String();
            String nameAndDescription = new String();
            String baseConfigNameAndDescription = new String();
            this.newName = this.configName.getText().trim();
            this.newDescription = this.configDescription.getText().trim();
            baseConfigNameAndDescription = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
            int i = 0;
            while (i < this.cfgds.length) {
                description = this.cfgds[i].getDescription();
                nameAndDescription = description == null || description.equals("") ? this.cfgds[i].getName() : String.valueOf(this.cfgds[i].getName()) + "( " + description + " )";
                if (nameAndDescription.equals(baseConfigNameAndDescription)) {
                    this.parentConfig = this.cfgds[i];
                    break;
                }
                ++i;
            }
            this.newConfiguration();
        } else {
            this.newName = null;
            this.newDescription = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Group group1 = new Group(composite, 0);
        group1.setFont(composite.getFont());
        GridLayout layout1 = new GridLayout(3, false);
        group1.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group1.setLayoutData((Object)gd);
        Label warningLabel = new Label((Composite)group1, 65);
        warningLabel.setFont(parent.getFont());
        warningLabel.setText(UIMessages.getString("NewConfiguration.label.warning"));
        gd = new GridData(4, 1, true, false, 3, 1);
        gd.widthHint = 300;
        warningLabel.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)group1, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(UIMessages.getString(NAME));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text((Composite)group1, 2052);
        this.configName.setFont(group1.getFont());
        this.configName.setText(this.getNewName());
        this.configName.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        Label descriptionLabel = new Label((Composite)group1, 16384);
        descriptionLabel.setFont(parent.getFont());
        descriptionLabel.setText(UIMessages.getString(DESCRIPTION));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        descriptionLabel.setLayoutData((Object)gd);
        this.configDescription = new Text((Composite)group1, 2052);
        this.configDescription.setFont(group1.getFont());
        this.configDescription.setText(this.getNewDescription());
        this.configDescription.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configDescription.setLayoutData((Object)gd);
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(UIMessages.getString(GROUP));
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNamesAndDescriptions());
        int index = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        this.cloneConfigSelector.setLayoutData((Object)gd);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        this.statusLabel = new Label(composite, 0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusLabel.setFont(composite.getFont());
        this.statusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        return composite;
    }

    private String[] getDefinedConfigNamesAndDescriptions() {
        String[] namesAndDescriptions = new String[this.cfgds.length];
        int i = 0;
        while (i < this.cfgds.length) {
            namesAndDescriptions[i] = this.cfgds[i].getDescription() == null || this.cfgds[i].getDescription().equals("") ? this.cfgds[i].getName() : String.valueOf(this.cfgds[i].getName()) + "( " + this.cfgds[i].getDescription() + " )";
            ++i;
        }
        return namesAndDescriptions;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equals(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSimilarName(String newName) {
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean validateName(String name) {
        if (name.trim().length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        String s = null;
        String currentName = this.configName.getText();
        while (currentName.length() > 0 && Character.isWhitespace(currentName.charAt(currentName.length() - 1))) {
            currentName = currentName.substring(0, currentName.length() - 1);
        }
        if (currentName.length() == 0) {
            s = "";
        } else if (this.cfgds.length == 0) {
            s = "";
        } else if (this.isDuplicateName(currentName)) {
            s = UIMessages.getFormattedString(DUPLICATE, currentName);
        } else if (this.isSimilarName(currentName)) {
            s = UIMessages.getFormattedString(CASE, currentName);
        } else if (!this.validateName(currentName)) {
            s = UIMessages.getFormattedString(INVALID, currentName);
        }
        if (this.statusLabel == null) {
            return;
        }
        Button b = this.getButton(0);
        if (s != null) {
            this.statusLabel.setText(s);
            this.statusLabel.setVisible(true);
            if (b != null) {
                b.setEnabled(false);
            }
        } else {
            this.statusLabel.setVisible(false);
            if (b != null) {
                b.setEnabled(true);
            }
        }
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    private void newConfiguration() {
        String id = CDataUtil.genId((String)this.parentConfig.getId());
        try {
            ICConfigurationDescription newcfg = this.des.createConfiguration(id, this.newName, this.parentConfig);
            newcfg.setDescription(this.newDescription);
        }
        catch (CoreException e) {
            System.out.println("Cannot create config\n" + e.getLocalizedMessage());
        }
    }

    public void setShell(Shell shell) {
    }
}

