/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectContentsArea {
    private static final String ERROR_INVALID_PATH = UIMessages.getString("ProjectContentsArea.3");
    private static final String ERROR_PATH_EMPTY = UIMessages.getString("ProjectContentsArea.4");
    private static final String ERROR_NOT_ABSOLUTE = UIMessages.getString("ProjectContentsArea.6");
    private static final String ERROR_NOT_VALID = UIMessages.getString("ProjectContentsArea.7");
    private static final String ERROR_CANNOT_CREATE = UIMessages.getString("ProjectContentsArea.8");
    private static final String ERROR_FILE_EXISTS = UIMessages.getString("ProjectContentsArea.9");
    private static final String BROWSE_LABEL = UIMessages.getString("ProjectContentsArea.0");
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String FILE_SCHEME = "file";
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private IErrorMessageReporter errorReporter;
    private String projectName = "";
    private String userPath = "";
    private Button useDefaultsButton;
    private IProject existingProject;

    public ProjectContentsArea(IErrorMessageReporter er, Composite composite) {
        this.errorReporter = er;
        this.createContents(composite, true);
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(UIMessages.getString("ProjectContentsArea.1"));
        this.useDefaultsButton.setSelection(defaultEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 4;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserEntryArea(projectGroup, defaultEnabled);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = ProjectContentsArea.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    ProjectContentsArea.this.userPath = ProjectContentsArea.this.locationPathField.getText();
                    ProjectContentsArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsArea.this.getDefaultPathDisplayString()));
                } else {
                    ProjectContentsArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsArea.this.userPath));
                }
                ProjectContentsArea.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(UIMessages.getString("ProjectContentsArea.2"));
        this.locationPathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectContentsArea.this.handleLocationBrowseButtonPressed();
            }
        });
        if (defaultEnabled) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else if (this.existingProject == null) {
            this.locationPathField.setText("");
        } else {
            this.locationPathField.setText(TextProcessor.process((String)this.existingProject.getLocation().toString()));
        }
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectContentsArea.this.errorReporter.reportError(ProjectContentsArea.this.checkValidLocation());
            }
        });
    }

    private String getDefaultPathDisplayString() {
        URI defaultURI = null;
        if (this.existingProject != null) {
            defaultURI = this.existingProject.getLocationURI();
        }
        if (defaultURI == null || defaultURI.getScheme().equals(FILE_SCHEME)) {
            return Platform.getLocation().append(this.projectName).toString();
        }
        return defaultURI.toString();
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private void handleLocationBrowseButtonPressed() {
        File f;
        String selectedDirectory = null;
        String dirName = this.getPathFromLocationField();
        if (!dirName.equals("") && !(f = new Path(dirName).toFile()).exists()) {
            dirName = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(UIMessages.getString("ProjectContentsArea.5"));
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateLocationField(selectedDirectory);
        }
    }

    private void updateLocationField(String selectedPath) {
        this.locationPathField.setText(TextProcessor.process((String)selectedPath));
    }

    private String getPathFromLocationField() {
        URI fieldURI;
        try {
            fieldURI = new URI(this.locationPathField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        return fieldURI.getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkValidLocation() {
        URI projectPath;
        IStatus locationStatus;
        if (this.isDefault()) {
            return null;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.length() == 0) {
            return ERROR_PATH_EMPTY;
        }
        URI newPath = this.getProjectLocationURI();
        if (newPath == null) {
            return ERROR_INVALID_PATH;
        }
        if (!Path.EMPTY.isValidPath(locationFieldContents)) {
            return ERROR_NOT_VALID;
        }
        Path p = new Path(locationFieldContents);
        if (!p.isAbsolute()) {
            return ERROR_NOT_ABSOLUTE;
        }
        File f = p.toFile();
        if (!f.exists()) {
            boolean result = false;
            try {
                result = f.createNewFile();
            }
            catch (IOException iOException) {}
            if (!result) return ERROR_CANNOT_CREATE;
            f.delete();
        } else if (f.isFile()) {
            return ERROR_FILE_EXISTS;
        }
        IProject project = this.existingProject;
        if (project == null) {
            String name = new Path(locationFieldContents).lastSegment();
            if (name == null || !Path.EMPTY.isValidSegment(name)) return ERROR_INVALID_PATH;
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        if (!(locationStatus = project.getWorkspace().validateProjectLocationURI(project, newPath)).isOK()) {
            return locationStatus.getMessage();
        }
        if (this.existingProject == null || (projectPath = this.existingProject.getLocationURI()) == null || !URIUtil.equals((URI)projectPath, (URI)newPath)) return null;
        return ERROR_INVALID_PATH;
    }

    public URI getProjectLocationURI() {
        return URIUtil.toURI((String)this.locationPathField.getText());
    }

    public void updateProjectName(String newName) {
        this.projectName = newName;
        if (this.isDefault()) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    public String getProjectLocation() {
        return this.isDefault() ? Platform.getLocation().toString() : this.locationPathField.getText();
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1);
    }
}

