/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tm.internal.tcf.debug.ui.model.ICastToType;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchWindow;

public class CastToArrayCommand
extends AbstractActionDelegate {
    protected void run() {
        final TCFNode node = this.getCastToTypeNode();
        if (node == null) {
            return;
        }
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final String base_type_name = this.getBaseTypeName();
        if (base_type_name == null) {
            return;
        }
        CastToTypeDialog dialog = new CastToTypeDialog(window.getShell(), node.getModel().getCastToType(node.getID()));
        if (dialog.open() != 0) {
            return;
        }
        final String new_type = dialog.getValue().trim();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                node.getModel().setCastToType(node.getID(), String.valueOf(base_type_name) + "[" + new_type + "]");
            }
        });
    }

    private String getBaseTypeName() {
        final TCFNode node = this.getCastToTypeNode();
        if (node == null) {
            return null;
        }
        return (String)new TCFTask<String>(node.getChannel()){

            public void run() {
                TCFDataCache<ISymbols.Symbol> type_cache = ((ICastToType)((Object)node)).getType();
                if (!type_cache.validate((Runnable)((Object)this))) {
                    return;
                }
                ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
                if (type_data == null || type_data.getTypeClass() != ISymbols.TypeClass.pointer) {
                    this.done(null);
                } else {
                    String ptrs = "****";
                    int i = 0;
                    while (i <= ptrs.length()) {
                        TCFDataCache<ISymbols.Symbol> base_type_cache = node.getModel().getSymbolInfoCache(type_data.getBaseTypeID());
                        if (!base_type_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                        if (base_type_data == null) {
                            this.done(null);
                        } else {
                            if (base_type_data.getName() != null) {
                                this.done(String.valueOf(base_type_data.getName()) + ptrs.substring(0, i));
                                return;
                            }
                            if (base_type_data.getTypeClass() == ISymbols.TypeClass.pointer) {
                                type_data = base_type_data;
                            } else {
                                this.done("\"" + base_type_data.getID() + "\"" + ptrs.substring(0, i));
                                return;
                            }
                        }
                        ++i;
                    }
                }
            }
        }.getE();
    }

    protected void selectionChanged() {
        this.getAction().setEnabled(this.getBaseTypeName() != null);
    }

    private TCFNode getCastToTypeNode() {
        TCFNode node = this.getSelectedNode();
        if (node instanceof ICastToType) {
            return node;
        }
        return null;
    }

    private class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell shell, String initial_value) {
            super(shell, "Cast To Array", "Enter array length", initial_value, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(ImageCache.getImage("icons/tcf.gif"));
        }
    }

    private class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String new_text) {
            block4: {
                try {
                    if (new_text.length() != 0) break block4;
                    return "";
                }
                catch (Exception exception) {
                    return "Invalid number";
                }
            }
            int i = Integer.parseInt(new_text);
            if (i < 1) {
                return "Array length must be >= 1";
            }
            return null;
        }
    }
}

