/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.commands.DisconnectCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.ResumeCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepIntoCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepOverCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepReturnCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.SuspendCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.TerminateCommand;
import org.eclipse.tm.internal.tcf.debug.ui.model.ICastToType;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFColumnPresentationExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFColumnPresentationRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFMemoryBlockRetrieval;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelPresentation;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelProxy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelSelectionPolicy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFModel
implements IElementContentProvider,
IElementLabelProvider,
IModelProxyFactory,
IColumnPresentationFactory,
ISourceDisplay,
ISuspendTrigger {
    private final TCFLaunch launch;
    private final Display display;
    private final List<ISuspendTriggerListener> suspend_trigger_listeners = new LinkedList<ISuspendTriggerListener>();
    private int suspend_trigger_generation;
    private final Set<String> running_actions = new HashSet<String>();
    private final Map<String, String> finished_actions = new HashMap<String, String>();
    private final Map<IPresentationContext, TCFModelProxy> model_proxies = new HashMap<IPresentationContext, TCFModelProxy>();
    private final Map<String, TCFNode> id2node = new HashMap<String, TCFNode>();
    private final Map<Class, Object> adapters = new HashMap<Class, Object>();
    private final Map<String, IMemoryBlockRetrievalExtension> mem_retrieval = new HashMap<String, IMemoryBlockRetrievalExtension>();
    private final Map<String, String> cast_to_type_map = new HashMap<String, String>();
    private Console console;
    private static final Map<ILaunchConfiguration, IEditorInput> editor_not_found = new HashMap<ILaunchConfiguration, IEditorInput>();
    private final IModelSelectionPolicyFactory model_selection_factory = new IModelSelectionPolicyFactory(){

        public IModelSelectionPolicy createModelSelectionPolicyAdapter(Object element, IPresentationContext context) {
            return TCFModel.this.selection_policy;
        }
    };
    private final IModelSelectionPolicy selection_policy;
    private IChannel channel;
    private TCFNodeLaunch launch_node;
    private boolean disposed;
    private static int display_source_cnt;
    private final IMemory.MemoryListener mem_listener = new IMemory.MemoryListener(){

        public void contextAdded(IMemory.MemoryContext[] contexts) {
            int i = 0;
            while (i < contexts.length) {
                String id = contexts[i].getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(contexts[i]);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(contexts[i]);
                    }
                }
                ++i;
            }
        }

        public void contextChanged(IMemory.MemoryContext[] contexts) {
            int i = 0;
            while (i < contexts.length) {
                TCFNode node = TCFModel.this.getNode(contexts[i].getID());
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(contexts[i]);
                }
                ++i;
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void memoryChanged(String context_id, Number[] addr, long[] size) {
            TCFNode node = TCFModel.this.getNode(context_id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onMemoryChanged(addr, size);
            }
        }
    };
    private final IRunControl.RunControlListener run_listener = new IRunControl.RunControlListener(){

        public void containerResumed(String[] context_ids) {
            int i = 0;
            while (i < context_ids.length) {
                TCFNode node = TCFModel.this.getNode(context_ids[i]);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerResumed();
                }
                ++i;
            }
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            int i = 0;
            while (i < suspended_ids.length) {
                TCFNode node = TCFModel.this.getNode(suspended_ids[i]);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerSuspended();
                }
                ++i;
            }
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextSuspended(pc, reason, params);
            }
            TCFModel.this.runSuspendTrigger(node);
            TCFModel.this.finished_actions.remove(context);
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            int i = 0;
            while (i < contexts.length) {
                String id = contexts[i].getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(contexts[i]);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(contexts[i]);
                    }
                }
                ++i;
            }
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
            int i = 0;
            while (i < contexts.length) {
                TCFNode node = TCFModel.this.getNode(contexts[i].getID());
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(contexts[i]);
                }
                ++i;
            }
        }

        public void contextException(String context, String msg) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextException(msg);
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void contextResumed(final String context) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextResumed();
            }
            TCFModel.this.display.asyncExec(new Runnable(){

                public void run() {
                    Activator.getAnnotationManager().onContextResumed(TCFModel.this, context);
                }
            });
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                TCFNodeExecContext exe = (TCFNodeExecContext)node;
                exe.onContextSuspended(pc, reason, params);
            }
            TCFModel.this.setDebugViewSelection(context);
            TCFModel.this.runSuspendTrigger(node);
            TCFModel.this.finished_actions.remove(context);
        }
    };
    private final IMemoryMap.MemoryMapListener mmap_listenr = new IMemoryMap.MemoryMapListener(){

        public void changed(String context) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                TCFNodeExecContext exe = (TCFNodeExecContext)node;
                exe.onMemoryMapChanged();
            }
        }
    };
    private final IRegisters.RegistersListener reg_listener = new IRegisters.RegistersListener(){

        public void contextChanged() {
            for (TCFNode node : TCFModel.this.id2node.values()) {
                if (!(node instanceof TCFNodeExecContext)) continue;
                ((TCFNodeExecContext)node).onRegistersChanged();
            }
        }

        public void registerChanged(String context) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeRegister) {
                ((TCFNodeRegister)node).onValueChanged();
            }
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            IProcesses.ProcessContext prs = TCFModel.this.launch.getProcessContext();
            if (prs != null && process_id.equals(prs.getID())) {
                TCFModel.this.onLastContextRemoved();
            }
        }
    };
    private final IDebugModelProvider debug_model_provider = new IDebugModelProvider(){

        public String[] getModelIdentifiers() {
            return new String[]{"org.eclipse.tm.tcf.debug"};
        }
    };

    TCFModel(TCFLaunch launch) {
        this.launch = launch;
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.selection_policy = new TCFModelSelectionPolicy(this);
        this.adapters.put(ILaunch.class, launch);
        this.adapters.put(IModelSelectionPolicy.class, this.selection_policy);
        this.adapters.put(IModelSelectionPolicyFactory.class, this.model_selection_factory);
        this.adapters.put(IDebugModelProvider.class, this.debug_model_provider);
        this.adapters.put(ISuspendHandler.class, new SuspendCommand(this));
        this.adapters.put(IResumeHandler.class, new ResumeCommand(this));
        this.adapters.put(ITerminateHandler.class, new TerminateCommand(this));
        this.adapters.put(IDisconnectHandler.class, new DisconnectCommand(this));
        this.adapters.put(IStepIntoHandler.class, new StepIntoCommand(this));
        this.adapters.put(IStepOverHandler.class, new StepOverCommand(this));
        this.adapters.put(IStepReturnHandler.class, new StepReturnCommand(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(final Class adapter, final TCFNode node) {
        Map<Class, Object> map = this.adapters;
        synchronized (map) {
            Object o = this.adapters.get(adapter);
            if (o != null) {
                return o;
            }
        }
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return new TCFTask<Object>(){

                public void run() {
                    TCFMemoryBlockRetrieval o = null;
                    TCFNode n = node;
                    while (n != null && !n.isDisposed()) {
                        if (n instanceof TCFNodeExecContext) {
                            TCFNodeExecContext e = (TCFNodeExecContext)n;
                            TCFDataCache<IMemory.MemoryContext> cache = e.getMemoryContext();
                            if (!cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (cache.getData() != null) {
                                o = (TCFMemoryBlockRetrieval)TCFModel.this.mem_retrieval.get(e.id);
                                if (o != null) break;
                                TCFMemoryBlockRetrieval m = new TCFMemoryBlockRetrieval(e);
                                TCFModel.this.mem_retrieval.put(e.id, m);
                                o = m;
                                break;
                            }
                        }
                        n = n.parent;
                    }
                    if (!$assertionsDisabled && o != null && !adapter.isInstance(o)) {
                        throw new AssertionError();
                    }
                    this.done(o);
                }
            }.getE();
        }
        return null;
    }

    void onConnected() {
        IProcesses prs;
        IRegisters reg;
        IMemoryMap mmap;
        IRunControl run;
        assert (Protocol.isDispatchThread());
        assert (this.launch_node == null);
        this.channel = this.launch.getChannel();
        this.launch_node = new TCFNodeLaunch(this);
        IMemory mem = (IMemory)this.launch.getService(IMemory.class);
        if (mem != null) {
            mem.addListener(this.mem_listener);
        }
        if ((run = (IRunControl)this.launch.getService(IRunControl.class)) != null) {
            run.addListener(this.run_listener);
        }
        if ((mmap = (IMemoryMap)this.launch.getService(IMemoryMap.class)) != null) {
            mmap.addListener(this.mmap_listenr);
        }
        if ((reg = (IRegisters)this.launch.getService(IRegisters.class)) != null) {
            reg.addListener(this.reg_listener);
        }
        if ((prs = (IProcesses)this.launch.getService(IProcesses.class)) != null) {
            prs.addListener(this.prs_listener);
        }
        this.launchChanged();
    }

    void onDisconnected() {
        assert (Protocol.isDispatchThread());
        if (this.launch_node != null) {
            this.launch_node.dispose();
            this.launch_node = null;
        }
        this.refreshLaunchView();
        assert (this.id2node.size() == 0);
    }

    void onProcessOutput(String process_id, final int stream_id, byte[] data) {
        try {
            IOConsoleOutputStream stream;
            IProcesses.ProcessContext prs = this.launch.getProcessContext();
            if (prs == null || !process_id.equals(prs.getID())) {
                return;
            }
            if (this.console == null) {
                final IOConsole c = new IOConsole("TCF " + process_id, null, ImageCache.getImageDescriptor("icons/tcf.gif"), "UTF-8", true);
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                            manager.addConsoles(new IConsole[]{c});
                            IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (w == null) {
                                return;
                            }
                            IWorkbenchPage page = w.getActivePage();
                            if (page == null) {
                                return;
                            }
                            IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                            view.display((IConsole)c);
                        }
                        catch (Throwable x) {
                            Activator.log("Cannot open console view", x);
                        }
                    }
                });
                this.console = new Console(c);
            }
            if ((stream = this.console.out.get(stream_id)) == null) {
                final IOConsoleOutputStream s = stream = this.console.console.newOutputStream();
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        try {
                            int color_id = 2;
                            switch (stream_id) {
                                case 1: {
                                    color_id = 3;
                                    break;
                                }
                                case 2: {
                                    color_id = 9;
                                    break;
                                }
                                case 3: {
                                    color_id = 5;
                                }
                            }
                            s.setColor(TCFModel.this.display.getSystemColor(color_id));
                        }
                        catch (Throwable x) {
                            Activator.log("Cannot open console view", x);
                        }
                    }
                });
                this.console.out.put(stream_id, stream);
            }
            stream.write(data, 0, data.length);
        }
        catch (Throwable x) {
            Activator.log("Cannot write to console", x);
        }
    }

    void onProcessStreamError(String process_id, int stream_id, Exception x, int lost_size) {
        if (this.channel != null && this.channel.getState() == 2) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Debugger console IO error");
        if (process_id != null) {
            bf.append(". Process ID ");
            bf.append(process_id);
        }
        bf.append(". Stream ");
        bf.append(stream_id);
        if (lost_size > 0) {
            bf.append(". Lost data size ");
            bf.append(lost_size);
        }
        Activator.log(bf.toString(), x);
    }

    void onContextActionsStart(String id) {
        this.running_actions.add(id);
    }

    void onContextActionsDone(String id, String result) {
        this.running_actions.remove(id);
        for (TCFModelProxy p : this.model_proxies.values()) {
            p.run();
        }
        this.finished_actions.put(id, result);
        this.setDebugViewSelection(id);
    }

    String getContextActionResult(String id) {
        return this.finished_actions.get(id);
    }

    boolean isContextActionResultAvailable(String id) {
        return this.finished_actions.containsKey(id);
    }

    void onProxyInstalled(IPresentationContext p, TCFModelProxy mp) {
        this.model_proxies.put(p, mp);
    }

    void onProxyDisposed(IPresentationContext p) {
        assert (this.model_proxies.containsKey(p));
        this.model_proxies.remove(p);
    }

    private void onContextRemoved(final String[] context_ids) {
        boolean close_channel = false;
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.launch.removeContextActions(id, null);
            TCFNode node = this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextRemoved();
                if (node.parent == this.launch_node) {
                    close_channel = true;
                }
            }
            this.finished_actions.remove(id);
            ++n2;
        }
        if (close_channel) {
            this.onLastContextRemoved();
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    Activator.getAnnotationManager().onContextRemoved(TCFModel.this, id);
                    ++n2;
                }
            }
        });
    }

    private void onLastContextRemoved() {
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            public void run() {
                if (TCFModel.this.launch_node == null) {
                    return;
                }
                if (TCFModel.this.launch_node.isDisposed()) {
                    return;
                }
                TCFChildrenExecContext children = TCFModel.this.launch_node.getChildren();
                if (!children.validate(this)) {
                    return;
                }
                if (children.size() != 0) {
                    return;
                }
                TCFModel.this.launch.onLastContextRemoved();
            }
        });
    }

    final void addDelta(TCFNode node, int flags) {
        for (TCFModelProxy p : this.model_proxies.values()) {
            int f = flags & node.getRelevantModelDeltaFlags(p.getPresentationContext());
            if (f == 0) continue;
            p.addDelta(node, f);
        }
    }

    void launchChanged() {
        if (this.launch_node != null) {
            this.launch_node.addModelDelta(3072);
        } else {
            this.refreshLaunchView();
        }
    }

    void dispose() {
        if (this.console != null) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    TCFModel.this.console.close();
                    IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                    manager.removeConsoles((IConsole[])new IOConsole[]{((TCFModel)TCFModel.this).console.console});
                }
            });
        }
    }

    void addNode(String id, TCFNode node) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        assert (this.id2node.get(id) == null);
        assert (!node.isDisposed());
        this.id2node.put(id, node);
    }

    void removeNode(String id) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        this.id2node.remove(id);
        this.mem_retrieval.remove(id);
    }

    public Display getDisplay() {
        return this.display;
    }

    public TCFLaunch getLaunch() {
        return this.launch;
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public TCFNodeLaunch getRootNode() {
        return this.launch_node;
    }

    public TCFNode getNode(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals("")) {
            return this.launch_node;
        }
        assert (Protocol.isDispatchThread());
        return this.id2node.get(id);
    }

    public String getCastToType(String id) {
        return this.cast_to_type_map.get(id);
    }

    public void setCastToType(String id, String type) {
        if (type != null && type.trim().length() == 0) {
            type = null;
        }
        if (type == null) {
            this.cast_to_type_map.remove(id);
        } else {
            this.cast_to_type_map.put(id, type);
        }
        TCFNode node = this.id2node.get(id);
        if (node instanceof ICastToType) {
            ((ICastToType)((Object)node)).onCastToTypeChanged();
        }
    }

    public TCFDataCache<ISymbols.Symbol> getSymbolInfoCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getContext();
    }

    public TCFDataCache<String[]> getSymbolChildrenCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getChildren();
    }

    public void update(IChildrenCountUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].setChildCount(0);
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].setHasChilren(false);
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(ILabelUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            assert (!(o instanceof TCFLaunch));
            ((TCFNode)o).update(updates[i]);
            ++i;
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        return new TCFModelProxy(this);
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        String id = this.getColumnPresentationId(context, element);
        if (id == null) {
            return null;
        }
        if (id.equals("Registers")) {
            return new TCFColumnPresentationRegister();
        }
        if (id.equals("Expressions")) {
            return new TCFColumnPresentationExpression();
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        if ("org.eclipse.debug.ui.RegisterView".equals(context.getId())) {
            return "Registers";
        }
        if ("org.eclipse.debug.ui.VariableView".equals(context.getId())) {
            return "Expressions";
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(context.getId())) {
            return "Expressions";
        }
        return null;
    }

    public void setDebugViewSelection(final String node_id) {
        assert (Protocol.isDispatchThread());
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                TCFNode node = TCFModel.this.getNode(node_id);
                if (node == null) {
                    return;
                }
                if (node.disposed) {
                    return;
                }
                if (TCFModel.this.running_actions.contains(node_id)) {
                    return;
                }
                for (TCFModelProxy proxy : TCFModel.this.model_proxies.values()) {
                    if (!proxy.getPresentationContext().getId().equals("org.eclipse.debug.ui.DebugView")) continue;
                    proxy.setSelection(node);
                }
            }
        });
    }

    public void displaySource(Object model_element, final IWorkbenchPage page, boolean forceSourceLookup) {
        IStructuredSelection selection;
        ISelection context;
        final int cnt = ++display_source_cnt;
        if (page != null && (context = DebugUITools.getDebugContextManager().getContextService(page.getWorkbenchWindow()).getActiveContext()) instanceof IStructuredSelection && !(selection = (IStructuredSelection)context).isEmpty()) {
            model_element = selection.getFirstElement();
        }
        final Object element = model_element;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (cnt != display_source_cnt) {
                    return;
                }
                TCFNodeExecContext exec_ctx = null;
                TCFNodeStackFrame stack_frame = null;
                if (!TCFModel.this.disposed && TCFModel.this.channel.getState() == 1) {
                    if (element instanceof TCFNodeExecContext) {
                        exec_ctx = (TCFNodeExecContext)element;
                        if (!exec_ctx.disposed) {
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            TCFContextState state_data = (TCFContextState)state_cache.getData();
                            if (state_data != null && state_data.is_suspended) {
                                TCFChildrenStackTrace stack_trace = exec_ctx.getStackTrace();
                                if (!stack_trace.validate(this)) {
                                    return;
                                }
                                stack_frame = stack_trace.getTopFrame();
                            }
                        }
                    } else if (element instanceof TCFNodeStackFrame) {
                        TCFNodeStackFrame f = (TCFNodeStackFrame)element;
                        exec_ctx = (TCFNodeExecContext)f.parent;
                        if (!f.disposed && !exec_ctx.disposed) {
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            TCFContextState state_data = (TCFContextState)state_cache.getData();
                            if (state_data != null && state_data.is_suspended) {
                                stack_frame = f;
                            }
                        }
                    }
                }
                if (stack_frame != null) {
                    TCFDataCache<TCFSourceRef> line_info = stack_frame.getLineInfo();
                    if (!line_info.validate((Runnable)this)) {
                        return;
                    }
                    Throwable error = line_info.getError();
                    TCFSourceRef src_ref = (TCFSourceRef)line_info.getData();
                    if (error == null && src_ref != null) {
                        error = src_ref.error;
                    }
                    if (error != null) {
                        Activator.log("Error retrieving source mapping for a stack frame", error);
                    }
                    ILineNumbers.CodeArea area = src_ref == null ? null : src_ref.area;
                    TCFModel.this.displaySource(cnt, page, stack_frame.parent.id, stack_frame.getFrameNo() == 0, area);
                } else {
                    TCFModel.this.displaySource(cnt, page, null, false, null);
                }
            }
        });
    }

    private void displaySource(final int cnt, final IWorkbenchPage page, final String exe_id, final boolean top_frame, final ILineNumbers.CodeArea area) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (cnt != display_source_cnt) {
                    return;
                }
                String editor_id = null;
                IEditorInput editor_input = null;
                int line = 0;
                if (area != null) {
                    ISourceLocator locator = TCFModel.this.getLaunch().getSourceLocator();
                    Object source_element = null;
                    if (locator instanceof ISourceLookupDirector) {
                        source_element = ((ISourceLookupDirector)locator).getSourceElement((Object)area);
                    }
                    if (source_element != null) {
                        TCFModelPresentation presentation = TCFModelPresentation.getDefault();
                        if (presentation != null) {
                            editor_input = presentation.getEditorInput(source_element);
                        }
                        if (editor_input != null) {
                            editor_id = presentation.getEditorId(editor_input, source_element);
                        }
                        line = area.start_line;
                    }
                    if (cnt != display_source_cnt) {
                        return;
                    }
                }
                if (area != null && (editor_input == null || editor_id == null)) {
                    ILaunchConfiguration cfg = TCFModel.this.launch.getLaunchConfiguration();
                    editor_id = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                    editor_input = (IEditorInput)editor_not_found.get(cfg);
                    if (editor_input == null) {
                        editor_input = new CommonSourceNotFoundEditorInput((Object)cfg);
                        editor_not_found.put(cfg, editor_input);
                    }
                }
                ITextEditor text_editor = null;
                IRegion region = null;
                if (editor_input != null && editor_id != null && page != null) {
                    IEditorPart editor = TCFModel.this.openEditor(editor_input, editor_id, page);
                    text_editor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                }
                if (text_editor != null && (region = TCFModel.this.getLineInformation(text_editor, line)) != null) {
                    text_editor.selectAndReveal(region.getOffset(), 0);
                }
                Activator.getAnnotationManager().addStackFrameAnnotation(TCFModel.this, exe_id, top_frame, page, text_editor, region);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLaunchView() {
        Throwable error = this.launch.getError();
        if (error != null) {
            this.launch.setError(null);
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.display.isDisposed()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    if (windows == null) {
                        return;
                    }
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IDebugView view = (IDebugView)window.getActivePage().findView("org.eclipse.debug.ui.DebugView");
                        if (view != null) {
                            ((StructuredViewer)view.getViewer()).refresh((Object)TCFModel.this.launch);
                        }
                        ++n2;
                    }
                }
            });
            if (error != null) {
                this.showMessageBox("TCF Launch Error", error);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void showMessageBox(final String title, final Throwable error) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = TCFModel.this.display.getActiveShell();
                if (shell == null) {
                    Shell s;
                    Shell[] shells = TCFModel.this.display.getShells();
                    HashSet<Shell> set = new HashSet<Shell>();
                    Shell[] shellArray = shells;
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        set.add(s);
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        if (s.getParent() != null) {
                            set.remove(s.getParent().getShell());
                        }
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        shell = s = shellArray[n2];
                        ++n2;
                    }
                }
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText(title);
                mb.setMessage(TCFModel.getErrorMessage(error, true));
                mb.open();
            }
        });
    }

    public static String getErrorMessage(Throwable error, boolean multiline) {
        StringBuffer buf = new StringBuffer();
        while (error != null) {
            String msg = null;
            msg = !multiline && error instanceof IErrorReport ? Command.toErrorString((Object)((IErrorReport)error).getAttributes()) : error.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = error.getClass().getName();
            }
            buf.append(msg);
            error = error.getCause();
            if (error == null) continue;
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            } else if (ch != '.' && ch != ';') {
                buf.append(';');
            }
            buf.append("Caused by:");
            buf.append(multiline ? (char)'\n' : ' ');
        }
        if (buf.length() > 0) {
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private IEditorPart openEditor(final IEditorInput input, final String id, final IWorkbenchPage page) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                    try {
                        editor[0] = page.openEditor(input, id, false, 3);
                    }
                    catch (PartInitException e) {
                        Activator.log("Cannot open editor", e);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)this.display, (Runnable)r);
        return editor[0];
    }

    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber - 1);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    public synchronized void addSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.add(listener);
    }

    public synchronized void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.remove(listener);
    }

    private synchronized void runSuspendTrigger(final TCFNode node) {
        final int generation = ++this.suspend_trigger_generation;
        final ISuspendTriggerListener[] listeners = this.suspend_trigger_listeners.toArray(new ISuspendTriggerListener[this.suspend_trigger_listeners.size()]);
        if (listeners.length == 0) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TCFModel tCFModel = TCFModel.this;
                synchronized (tCFModel) {
                    if (generation != TCFModel.this.suspend_trigger_generation) {
                        return;
                    }
                }
                ISuspendTriggerListener[] iSuspendTriggerListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ISuspendTriggerListener listener = iSuspendTriggerListenerArray[n2];
                    try {
                        listener.suspended((ILaunch)TCFModel.this.launch, (Object)node);
                    }
                    catch (Throwable x) {
                        Activator.log(x);
                    }
                    ++n2;
                }
            }
        });
    }

    private class Console {
        final IOConsole console;
        final Map<Integer, IOConsoleOutputStream> out;

        Console(final IOConsole console) {
            this.console = console;
            this.out = new HashMap<Integer, IOConsoleOutputStream>();
            Thread t = new Thread(){

                public void run() {
                    try {
                        int len;
                        IOConsoleInputStream inp = console.getInputStream();
                        final byte[] buf = new byte[256];
                        while ((len = inp.read(buf)) >= 0) {
                            Protocol.invokeAndWait((Runnable)new Runnable(){

                                public void run() {
                                    try {
                                        TCFModel.this.launch.writeProcessInputStream(buf, 0, len);
                                    }
                                    catch (Exception x) {
                                        TCFModel.this.onProcessStreamError(null, 0, x, 0);
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot read console input", x);
                    }
                }
            };
            t.setName("TCF Launch Console Input");
            t.start();
        }

        void close() {
            for (IOConsoleOutputStream stream : this.out.values()) {
                try {
                    stream.close();
                }
                catch (IOException x) {
                    Activator.log("Cannot close console stream", x);
                }
            }
            try {
                this.console.getInputStream().close();
            }
            catch (IOException x) {
                Activator.log("Cannot close console stream", x);
            }
        }
    }
}

