/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFModelManager {
    private final Map<TCFLaunch, TCFModel> models = new HashMap<TCFLaunch, TCFModel>();
    private final TCFLaunch.Listener tcf_launch_listener = new TCFLaunch.Listener(){

        public void onCreated(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && TCFModelManager.this.models.get(launch) != null) {
                throw new AssertionError();
            }
            TCFModel model = new TCFModel(launch);
            TCFModelManager.this.models.put(launch, model);
        }

        public void onConnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onConnected();
            }
        }

        public void onDisconnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onDisconnected();
            }
        }

        public void onContextActionsDone(TCFLaunch launch, String id, String result) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onContextActionsDone(id, result);
            }
        }

        public void onContextActionsStart(TCFLaunch launch, String id) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onContextActionsStart(id);
            }
        }

        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessOutput(process_id, stream_id, data);
            }
        }

        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessStreamError(process_id, stream_id, error, lost_size);
            }
        }
    };
    private final ILaunchesListener debug_launch_listener = new ILaunchesListener(){

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
                        if (model != null) {
                            model.launchChanged();
                        }
                        ++n2;
                    }
                }
            });
        }

        public void launchesRemoved(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.remove(launch);
                        if (model != null) {
                            model.dispose();
                        }
                        ++n2;
                    }
                }
            });
        }
    };

    public TCFModelManager() {
        assert (Protocol.isDispatchThread());
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.debug_launch_listener);
        TCFLaunch.addListener((TCFLaunch.Listener)this.tcf_launch_listener);
    }

    public void dispose() {
        assert (Protocol.isDispatchThread());
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.debug_launch_listener);
        TCFLaunch.removeListener((TCFLaunch.Listener)this.tcf_launch_listener);
        Iterator<TCFModel> i = this.models.values().iterator();
        while (i.hasNext()) {
            TCFModel model = i.next();
            model.dispose();
            i.remove();
        }
        assert (this.models.isEmpty());
    }

    public TCFModel getModel(TCFLaunch launch) {
        assert (Protocol.isDispatchThread());
        return this.models.get(launch);
    }

    public TCFNode getRootNode(TCFLaunch launch) {
        TCFModel model = this.getModel(launch);
        if (model == null) {
            return null;
        }
        return model.getRootNode();
    }
}

