/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

class TCFModelSelectionPolicy
implements IModelSelectionPolicy {
    private final TCFModel model;

    TCFModelSelectionPolicy(TCFModel model) {
        this.model = model;
    }

    public boolean contains(ISelection selection, IPresentationContext context) {
        IStructuredSelection ss;
        Object e;
        if (selection instanceof IStructuredSelection && (e = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
            TCFNode n = (TCFNode)e;
            return !n.isDisposed() && n.getModel() == this.model;
        }
        return false;
    }

    public boolean isSticky(ISelection selection, IPresentationContext context) {
        IStructuredSelection ss;
        Object e;
        if (selection instanceof IStructuredSelection && (e = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
            return this.isSuspended((TCFNode)e);
        }
        return false;
    }

    private boolean isSuspended(final TCFNode node) {
        return (Boolean)new TCFTask<Boolean>(){

            public void run() {
                TCFNode n = node;
                while (n != null && !n.isDisposed()) {
                    if (n instanceof TCFNodeExecContext) {
                        TCFDataCache<TCFContextState> cache = ((TCFNodeExecContext)n).getState();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFContextState state = (TCFContextState)cache.getData();
                        if (state != null && state.is_suspended) {
                            this.done(true);
                            return;
                        }
                    }
                    n = n.parent;
                }
                this.done(false);
            }
        }.getE();
    }

    public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && existing instanceof IStructuredSelection && candidate instanceof IStructuredSelection) {
            Object el_existing = ((IStructuredSelection)existing).getFirstElement();
            Object el_candidate = ((IStructuredSelection)candidate).getFirstElement();
            if (el_existing == null) {
                return true;
            }
            if (el_existing == el_candidate) {
                return true;
            }
            if (el_existing instanceof TCFNode && el_candidate instanceof TCFNode) {
                if (el_existing instanceof TCFNodeStackFrame && el_candidate instanceof TCFNodeStackFrame) {
                    TCFNodeStackFrame curr = (TCFNodeStackFrame)el_existing;
                    TCFNodeStackFrame next = (TCFNodeStackFrame)el_candidate;
                    return curr.parent == next.parent || !this.isSuspended(curr);
                }
                return !this.isSuspended((TCFNode)el_existing);
            }
        }
        return true;
    }

    public ISelection replaceInvalidSelection(ISelection invalid_selection, ISelection new_selection) {
        return new_selection;
    }
}

