/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFRunnable;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFNode
extends PlatformObject
implements Comparable<TCFNode> {
    protected final String id;
    protected final TCFNode parent;
    protected final TCFModel model;
    protected final IChannel channel;
    protected boolean disposed;

    protected TCFNode(TCFModel model) {
        this.id = null;
        this.parent = null;
        this.channel = model.getChannel();
        this.model = model;
    }

    protected TCFNode(TCFNode parent, String id) {
        assert (Protocol.isDispatchThread());
        assert (parent != null);
        assert (id != null);
        assert (!parent.disposed);
        this.parent = parent;
        this.id = id;
        this.model = parent.model;
        this.model.addNode(id, this);
        this.channel = this.model.getChannel();
    }

    void dispose() {
        assert (!this.disposed);
        if (this.parent != null) {
            this.parent.dispose(this.id);
        }
        if (this.id != null) {
            assert (this.model.getNode(this.id) == this);
            this.model.removeNode(this.id);
        }
        this.disposed = true;
    }

    void dispose(String id) {
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public TCFModel getModel() {
        return this.model;
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public String getID() {
        return this.id;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.model)) {
            return this.model;
        }
        Object o = this.model.getAdapter(adapter, this);
        if (o != null) {
            return o;
        }
        return super.getAdapter(adapter);
    }

    public final TCFNode getParent() {
        assert (Protocol.isDispatchThread());
        return this.parent;
    }

    final void update(final IChildrenCountUpdate result) {
        new TCFRunnable((IRequest)result){

            public void run() {
                if (!this.done) {
                    if (!result.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1) {
                            if (!TCFNode.this.getData(result, (Runnable)this)) {
                                return;
                            }
                        } else {
                            result.setChildCount(0);
                        }
                        result.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final IChildrenUpdate result) {
        new TCFRunnable((IRequest)result){

            public void run() {
                if (!this.done) {
                    if (!result.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1 && !TCFNode.this.getData(result, (Runnable)this)) {
                            return;
                        }
                        result.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final IHasChildrenUpdate result) {
        new TCFRunnable((IRequest)result){

            public void run() {
                if (!this.done) {
                    if (!result.isCanceled()) {
                        IChannel channel = TCFNode.this.model.getLaunch().getChannel();
                        if (!TCFNode.this.disposed && channel.getState() == 1) {
                            if (!TCFNode.this.getData(result, (Runnable)this)) {
                                return;
                            }
                        } else {
                            result.setHasChilren(false);
                        }
                        result.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    final void update(final ILabelUpdate result) {
        new TCFRunnable((IRequest)result){

            public void run() {
                if (!this.done) {
                    if (!result.isCanceled()) {
                        if (!TCFNode.this.disposed && TCFNode.this.channel.getState() == 1) {
                            if (!TCFNode.this.getData(result, (Runnable)this)) {
                                return;
                            }
                        } else {
                            result.setLabel("...", 0);
                        }
                        result.setStatus(Status.OK_STATUS);
                    }
                    this.done();
                }
            }
        };
    }

    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        result.setChildCount(0);
        return true;
    }

    protected boolean getData(IChildrenUpdate result, Runnable done) {
        return true;
    }

    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        result.setHasChilren(false);
        return true;
    }

    protected boolean getData(ILabelUpdate result, Runnable done) {
        result.setLabel(this.id, 0);
        return true;
    }

    final void addModelDelta(int flags) {
        this.model.addDelta(this, flags);
    }

    int getRelevantModelDeltaFlags(IPresentationContext p) {
        return 3075;
    }

    @Override
    public int compareTo(TCFNode n) {
        return this.id.compareTo(n.id);
    }

    public String toString() {
        String s = "[" + Integer.toHexString(this.hashCode()) + "] " + this.id;
        if (this.disposed) {
            s = String.valueOf(s) + ", disposed";
        }
        return s;
    }
}

