/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.tests.ITCFTest;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IDiagnostics;
import org.eclipse.tm.tcf.services.IRunControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestAttachTerminate
implements ITCFTest,
IRunControl.RunControlListener {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final IRunControl rc;
    private int cnt = 0;
    private final HashMap<String, IRunControl.RunControlContext> ctx_map = new HashMap();
    private final HashSet<String> process_ids = new HashSet();

    TestAttachTerminate(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.rc = (IRunControl)channel.getRemoteService(IRunControl.class);
    }

    @Override
    public void start() {
        if (this.diag == null || this.rc == null) {
            this.test_suite.done(this, null);
        } else {
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.diag.getTestList(new IDiagnostics.DoneGetTestList(){

                public void doneGetTestList(IToken token, Throwable error, String[] list) {
                    if (!$assertionsDisabled && !TestAttachTerminate.this.test_suite.isActive(TestAttachTerminate.this)) {
                        throw new AssertionError();
                    }
                    if (error != null) {
                        TestAttachTerminate.this.exit(error);
                    } else {
                        int i = 0;
                        while (i < list.length) {
                            if (list[i].equals("RCBP1")) {
                                TestAttachTerminate.this.startProcess();
                                Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){
                                    int cnt = 0;

                                    public void run() {
                                        if (!TestAttachTerminate.this.test_suite.isActive(TestAttachTerminate.this)) {
                                            return;
                                        }
                                        ++this.cnt;
                                        if (this.cnt < 10) {
                                            Protocol.invokeLater((long)1000L, (Runnable)this);
                                        } else if (((TestAttachTerminate)(this).TestAttachTerminate.this).test_suite.cancel) {
                                            TestAttachTerminate.this.exit(null);
                                        } else if (TestAttachTerminate.this.process_ids.isEmpty()) {
                                            TestAttachTerminate.this.exit(new Error("Missing 'contextAdded' event"));
                                        } else {
                                            TestAttachTerminate.this.exit(new Error("Missing 'contextRemoved' event for " + TestAttachTerminate.this.process_ids));
                                        }
                                    }
                                });
                                return;
                            }
                            ++i;
                        }
                    }
                    TestAttachTerminate.this.exit(null);
                }
            });
        }
    }

    private void startProcess() {
        int i = 0;
        while (i < 4) {
            this.diag.runTest("RCBP1", new IDiagnostics.DoneRunTest(){

                public void doneRunTest(IToken token, Throwable error, String context_id) {
                    TestAttachTerminate testAttachTerminate = TestAttachTerminate.this;
                    testAttachTerminate.cnt = testAttachTerminate.cnt - 1;
                    if (error != null) {
                        TestAttachTerminate.this.exit(error);
                    } else {
                        if (!$assertionsDisabled && context_id == null) {
                            throw new AssertionError();
                        }
                        if (TestAttachTerminate.this.ctx_map.get(context_id) == null) {
                            TestAttachTerminate.this.exit(new Error("Missing 'contextAdded' event for context " + context_id));
                        }
                        TestAttachTerminate.this.process_ids.add(context_id);
                        TestAttachTerminate.this.diag.cancelTest(context_id, new IDiagnostics.DoneCancelTest(){

                            public void doneCancelTest(IToken token, Throwable error) {
                                if (error != null) {
                                    TestAttachTerminate.this.exit(error);
                                }
                            }
                        });
                    }
                }
            });
            ++this.cnt;
            ++i;
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.test_suite.done(this, x);
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String main_context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            assert (context != null);
            this.contextSuspended(context, null, null, null);
            ++n2;
        }
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            if (this.ctx_map.get(ctx.getID()) != null) {
                this.exit(new Error("Invalid 'contextAdded' event"));
            }
            this.ctx_map.put(ctx.getID(), ctx);
            ++n2;
        }
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            if (this.ctx_map.get(ctx.getID()) == null) {
                return;
            }
            this.ctx_map.put(ctx.getID(), ctx);
            ++n2;
        }
    }

    public void contextException(String context, String msg) {
        IRunControl.RunControlContext ctx = this.ctx_map.get(context);
        if (ctx == null) {
            return;
        }
        this.process_ids.contains(ctx.getParentID());
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.ctx_map.remove(id);
            this.process_ids.remove(id);
            ++n2;
        }
        if (this.cnt == 0 && this.process_ids.isEmpty()) {
            this.exit(null);
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        assert (context != null);
        IRunControl.RunControlContext ctx = this.ctx_map.get(context);
        if (ctx != null && this.process_ids.contains(ctx.getParentID())) {
            ctx.resume(0, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error instanceof IErrorReport) {
                        int code = ((IErrorReport)error).getErrorCode();
                        if (code == 12) {
                            return;
                        }
                        if (code == 16) {
                            return;
                        }
                    }
                    if (error != null) {
                        TestAttachTerminate.this.exit(error);
                    }
                }
            });
        }
    }
}

