/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class NonVirtualDestructor
extends AbstractIndexAstChecker {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.NonVirtualDestructorProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    class OnEachClass
    extends ASTVisitor {
        private IASTName className;
        private IBinding virMethodName;
        private IBinding destructorName;

        OnEachClass() {
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier decl) {
            if (this.isClassDecl(decl)) {
                try {
                    boolean err = this.hasErrorCondition(decl);
                    if (err) {
                        String clazz = this.className.toString();
                        String method = this.virMethodName.getName();
                        IASTDeclSpecifier ast = decl;
                        if (this.destructorName != null) {
                            ICPPInternalBinding bin;
                            IASTNode[] decls;
                            if (this.destructorName instanceof ICPPInternalBinding && (decls = (bin = (ICPPInternalBinding)this.destructorName).getDeclarations()) != null && decls.length > 0) {
                                ast = decls[0];
                            }
                            NonVirtualDestructor.this.reportProblem(NonVirtualDestructor.ER_ID, (IASTNode)ast, new Object[]{clazz, method, this.destructorName.getName()});
                        }
                    }
                }
                catch (DOMException dOMException) {
                }
                catch (Exception e) {
                    CodanCheckersActivator.log(e);
                }
                return 1;
            }
            return 3;
        }

        private boolean hasErrorCondition(IASTDeclSpecifier decl) throws DOMException {
            ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)decl;
            this.className = spec.getName();
            IBinding binding = this.className.getBinding();
            if (binding == null) {
                binding = this.className.resolveBinding();
            }
            if (binding instanceof ICPPClassType) {
                ICPPClassType type = (ICPPClassType)binding;
                this.virMethodName = null;
                this.destructorName = null;
                ICPPMethod[] declaredMethods = type.getDeclaredMethods();
                boolean hasOwnVirtualMethod = false;
                boolean hasOwnNonVirDestructor = false;
                boolean hasDestructor = false;
                boolean hasVirtualMethod = false;
                int i = 0;
                while (i < declaredMethods.length) {
                    ICPPMethod icppMethod = declaredMethods[i];
                    if (icppMethod.isVirtual() && !icppMethod.isDestructor()) {
                        hasOwnVirtualMethod = true;
                        this.virMethodName = icppMethod;
                    }
                    if (icppMethod.isDestructor()) {
                        hasDestructor = true;
                        if (!icppMethod.isVirtual()) {
                            hasOwnNonVirDestructor = true;
                            this.destructorName = icppMethod;
                        }
                    }
                    ++i;
                }
                boolean hasVirDestructor = false;
                if (hasOwnVirtualMethod && hasOwnNonVirDestructor) {
                    return true;
                }
                if (!hasOwnVirtualMethod && hasDestructor && !hasOwnNonVirDestructor) {
                    return false;
                }
                ICPPMethod[] allDeclaredMethods = type.getAllDeclaredMethods();
                int i2 = 0;
                while (i2 < allDeclaredMethods.length) {
                    ICPPMethod icppMethod = allDeclaredMethods[i2];
                    if (icppMethod.isVirtual() && !icppMethod.isDestructor()) {
                        hasVirtualMethod = true;
                        if (this.virMethodName == null) {
                            this.virMethodName = icppMethod;
                        }
                    }
                    if (icppMethod.isDestructor()) {
                        hasDestructor = true;
                        if (icppMethod.isVirtual()) {
                            hasVirDestructor = true;
                        } else if (this.destructorName == null) {
                            this.destructorName = icppMethod;
                        }
                    }
                    ++i2;
                }
                if (hasOwnVirtualMethod ? hasDestructor && !hasVirDestructor : hasVirtualMethod && hasOwnNonVirDestructor) {
                    return true;
                }
            }
            return false;
        }

        private boolean isClassDecl(IASTDeclSpecifier decl) {
            return decl instanceof ICPPASTCompositeTypeSpecifier;
        }
    }
}

