/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Iterator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractAstFunctionChecker;
import org.eclipse.cdt.codan.core.cxx.model.CxxModelsCache;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.core.resources.IResource;

public class ReturnChecker
extends AbstractAstFunctionChecker {
    private static final String PARAM_IMPLICIT = "implicit";
    public final String RET_NO_VALUE_ID = "org.eclipse.cdt.codan.checkers.noreturn";
    public final String RET_ERR_VALUE_ID = "org.eclipse.cdt.codan.checkers.errreturnvalue";
    public final String RET_NORET_ID = "org.eclipse.cdt.codan.checkers.errnoreturn";

    protected void processFunction(IASTFunctionDefinition func) {
        ReturnStmpVisitor visitor = new ReturnStmpVisitor(func);
        func.accept((ASTVisitor)visitor);
        if (!visitor.hasret && !this.isVoid(func) && (this.checkImplicitReturn("org.eclipse.cdt.codan.checkers.errnoreturn") || this.isExplicitReturn(func)) && this.endsWithNoExitNode(func)) {
            this.reportProblem("org.eclipse.cdt.codan.checkers.errnoreturn", (IASTNode)func.getDeclSpecifier(), new Object[0]);
        }
    }

    protected boolean checkImplicitReturn(String id) {
        IProblem pt = this.getProblemById(id, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_IMPLICIT);
    }

    protected boolean endsWithNoExitNode(IASTFunctionDefinition func) {
        IControlFlowGraph graph = CxxModelsCache.getInstance().getControlFlowGraph(func);
        Iterator exitNodeIterator = graph.getExitNodeIterator();
        boolean noexitop = false;
        while (exitNodeIterator.hasNext()) {
            IExitNode node = (IExitNode)exitNodeIterator.next();
            if (((ICfgData)node).getData() != null) continue;
            noexitop = true;
            break;
        }
        return noexitop;
    }

    protected boolean isExplicitReturn(IASTFunctionDefinition func) {
        return this.getDeclSpecType(func) != 0;
    }

    public boolean isVoid(IASTFunctionDefinition func) {
        IASTFunctionDeclarator declarator;
        int type = this.getDeclSpecType(func);
        return type == 1 && (declarator = func.getDeclarator()).getPointerOperators().length == 0;
    }

    public boolean isVoid(IType type) {
        if (type instanceof IBasicType) {
            try {
                if (((IBasicType)type).getType() == 1) {
                    return true;
                }
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    protected int getDeclSpecType(IASTFunctionDefinition func) {
        IASTDeclSpecifier declSpecifier = func.getDeclSpecifier();
        int type = -1;
        if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            type = ((IASTSimpleDeclSpecifier)declSpecifier).getType();
        } else if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            IBinding binding = ((IASTNamedTypeSpecifier)declSpecifier).getName().resolveBinding();
            IType utype = CxxAstUtils.getInstance().unwindTypedef((IType)binding);
            if (this.isVoid(utype)) {
                return 1;
            }
        }
        return type;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        if (problem.getId().equals("org.eclipse.cdt.codan.checkers.noreturn") || problem.getId().equals("org.eclipse.cdt.codan.checkers.errnoreturn")) {
            this.addPreference(problem, PARAM_IMPLICIT, CheckersMessages.ReturnChecker_Param0, Boolean.FALSE);
        }
    }

    class ReturnStmpVisitor
    extends ASTVisitor {
        private IASTFunctionDefinition func;
        boolean hasret;

        ReturnStmpVisitor(IASTFunctionDefinition func) {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.func = func;
            this.hasret = false;
        }

        public int visit(IASTDeclaration element) {
            if (element != this.func) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTReturnStatement) {
                this.hasret = true;
                IASTReturnStatement ret = (IASTReturnStatement)stmt;
                if (!ReturnChecker.this.isVoid(this.func)) {
                    if ((ReturnChecker.this.checkImplicitReturn("org.eclipse.cdt.codan.checkers.noreturn") || ReturnChecker.this.isExplicitReturn(this.func)) && ret.getReturnValue() == null) {
                        ReturnChecker.this.reportProblem("org.eclipse.cdt.codan.checkers.noreturn", (IASTNode)ret, new Object[0]);
                    }
                } else if (ret.getReturnValue() != null) {
                    IType type = ret.getReturnValue().getExpressionType();
                    if (ReturnChecker.this.isVoid(type)) {
                        return 1;
                    }
                    ReturnChecker.this.reportProblem("org.eclipse.cdt.codan.checkers.errreturnvalue", (IASTNode)ret.getReturnValue(), new Object[0]);
                }
                return 1;
            }
            return 3;
        }
    }
}

