/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import java.util.Collection;
import org.eclipse.cdt.codan.core.model.AbstractChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.BasicProblemPreference;
import org.eclipse.cdt.codan.core.param.FileScopeProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractCheckerWithProblemPreferences
extends AbstractChecker
implements ICheckerWithPreferences {
    public void initPreferences(IProblemWorkingCopy problem) {
        this.addPreference(problem, new FileScopeProblemPreference(), null);
    }

    public FileScopeProblemPreference getScopePreference(IProblem problem) {
        FileScopeProblemPreference scope = (FileScopeProblemPreference)this.getTopLevelPreferenceMap(problem).getChildDescriptor("fileScope");
        return scope;
    }

    public boolean shouldProduceProblems(IResource res) {
        Collection<IProblem> refProblems = this.getRuntime().getChechersRegistry().getRefProblems(this);
        for (IProblem checkerProblem : refProblems) {
            if (!this.shouldProduceProblem(this.getProblemById(checkerProblem.getId(), res), res.getLocation())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldProduceProblem(IProblem problem, IPath resource) {
        FileScopeProblemPreference scope = this.getScopePreference(problem);
        if (scope == null) {
            return true;
        }
        return scope.isInScope(resource);
    }

    public void reportProblem(String problemId, IProblemLocation loc, Object ... args) {
        if (this.shouldProduceProblem(this.getProblemById(problemId, loc.getFile()), loc.getFile().getLocation())) {
            super.reportProblem(problemId, loc, args);
        }
    }

    public IProblemPreference addPreference(IProblemWorkingCopy problem, String key, String label, Object defaultValue) {
        MapProblemPreference map = this.getTopLevelPreferenceMap(problem);
        BasicProblemPreference info = new BasicProblemPreference(key, label, IProblemPreferenceDescriptor.PreferenceType.typeOf(defaultValue));
        map.addChildDescriptor(info);
        this.setDefaultPreferenceValue(problem, key, defaultValue);
        return info;
    }

    public ListProblemPreference addListPreference(IProblemWorkingCopy problem, String key, String label, String itemLabel) {
        MapProblemPreference map = this.getTopLevelPreferenceMap(problem);
        ListProblemPreference list = new ListProblemPreference(key, label);
        list.setChildDescriptor(new BasicProblemPreference("#", itemLabel, IProblemPreferenceDescriptor.PreferenceType.TYPE_STRING));
        return (ListProblemPreference)map.addChildDescriptor(list);
    }

    public IProblemPreference addPreference(IProblemWorkingCopy problem, IProblemPreference pref, Object defaultValue) {
        MapProblemPreference map = this.getTopLevelPreferenceMap(problem);
        String key = pref.getKey();
        pref = map.addChildDescriptor(pref);
        this.setDefaultPreferenceValue(problem, key, defaultValue);
        return pref;
    }

    protected void setDefaultPreferenceValue(IProblemWorkingCopy problem, String key, Object defaultValue) {
        MapProblemPreference map = this.getTopLevelPreferenceMap(problem);
        if (map.getChildValue(key) == null) {
            map.setChildValue(key, defaultValue);
        }
    }

    protected MapProblemPreference getTopLevelPreferenceMap(IProblem problem) {
        MapProblemPreference map = (MapProblemPreference)problem.getPreference();
        if (map == null) {
            map = new MapProblemPreference("params", "");
            if (problem instanceof IProblemWorkingCopy) {
                ((IProblemWorkingCopy)problem).setPreference(map);
            }
        }
        return map;
    }

    public Object getPreference(IProblem problem, String key) {
        return ((MapProblemPreference)problem.getPreference()).getChildValue(key);
    }
}

