/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.settings.model.CIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.CMacroFileEntry;
import org.eclipse.cdt.core.settings.model.COutputEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageSettingEntriesSerializer {
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ATTRIBUTE_KIND = "kind";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_FLAGS = "flags";
    public static final String ATTRIBUTE_EXCLUDING = "excluding";
    public static final String ATTRIBUTE_SOURCE_ATTACHMENT_PATH = "srcPath";
    public static final String ATTRIBUTE_SOURCE_ATTACHMENT_ROOT_PATH = "srcRootPath";
    public static final String ATTRIBUTE_SOURCE_ATTACHMENT_PREFIX_MAPPING = "srcPrefixMapping";
    public static final String INCLUDE_PATH = "includePath";
    public static final String INCLUDE_FILE = "includeFile";
    public static final String MACRO = "macro";
    public static final String MACRO_FILE = "macroFile";
    public static final String LIBRARY_PATH = "libraryPath";
    public static final String LIBRARY_FILE = "libraryFile";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String OUTPUT_PATH = "outputPath";
    public static final String BUILTIN = "BUILTIN";
    public static final String READONLY = "READONLY";
    public static final String LOCAL = "LOCAL";
    public static final String VALUE_WORKSPACE_PATH = "VALUE_WORKSPACE_PATH";
    public static final String RESOLVED = "RESOLVED";
    public static final String FLAGS_SEPARATOR = "|";

    public static ICSettingEntry[] loadEntries(ICStorageElement el) {
        return LanguageSettingEntriesSerializer.loadEntries(el, 0);
    }

    public static ICSettingEntry[] loadEntries(ICStorageElement el, int kindFilter) {
        List<ICSettingEntry> list = LanguageSettingEntriesSerializer.loadEntriesList(el, kindFilter);
        return list.toArray(new ICSettingEntry[list.size()]);
    }

    public static List<ICSettingEntry> loadEntriesList(ICStorageElement el) {
        return LanguageSettingEntriesSerializer.loadEntriesList(el, 0);
    }

    public static List<ICSettingEntry> loadEntriesList(ICStorageElement el, int kindFilter) {
        ICStorageElement[] children = el.getChildren();
        ArrayList<ICSettingEntry> list = new ArrayList<ICSettingEntry>();
        int i = 0;
        while (i < children.length) {
            ICSettingEntry entry;
            ICStorageElement child = children[i];
            if (ELEMENT_ENTRY.equals(child.getName()) && (entry = LanguageSettingEntriesSerializer.loadEntry(child)) != null && (kindFilter == 0 || (kindFilter & entry.getKind()) != 0)) {
                list.add(entry);
            }
            ++i;
        }
        return list;
    }

    public static ICSettingEntry loadEntry(ICStorageElement el) {
        int kind = LanguageSettingEntriesSerializer.stringToKind(el.getAttribute(ATTRIBUTE_KIND));
        if (kind == 0) {
            return null;
        }
        int flags = LanguageSettingEntriesSerializer.composeFlags(el.getAttribute(ATTRIBUTE_FLAGS));
        String name = el.getAttribute(ATTRIBUTE_NAME);
        switch (kind) {
            case 1: {
                return new CIncludePathEntry(name, flags);
            }
            case 2: {
                return new CIncludeFileEntry(name, flags);
            }
            case 4: {
                String value = el.getAttribute(ATTRIBUTE_VALUE);
                return new CMacroEntry(name, value, flags);
            }
            case 8: {
                return new CMacroFileEntry(name, flags);
            }
            case 16: {
                return new CLibraryPathEntry(name, flags);
            }
            case 32: {
                IPath srcPath = LanguageSettingEntriesSerializer.loadPath(el, ATTRIBUTE_SOURCE_ATTACHMENT_PATH);
                IPath srcRootPath = LanguageSettingEntriesSerializer.loadPath(el, ATTRIBUTE_SOURCE_ATTACHMENT_ROOT_PATH);
                IPath srcPrefixMapping = LanguageSettingEntriesSerializer.loadPath(el, ATTRIBUTE_SOURCE_ATTACHMENT_PREFIX_MAPPING);
                return new CLibraryFileEntry(name, flags, srcPath, srcRootPath, srcPrefixMapping);
            }
            case 64: {
                return new COutputEntry(name, LanguageSettingEntriesSerializer.loadExclusions(el), flags);
            }
            case 128: {
                return new CSourceEntry(name, LanguageSettingEntriesSerializer.loadExclusions(el), flags);
            }
        }
        return null;
    }

    private static IPath loadPath(ICStorageElement el, String attr) {
        String value = el.getAttribute(attr);
        if (value != null) {
            return new Path(value);
        }
        return null;
    }

    private static IPath[] loadExclusions(ICStorageElement el) {
        String attr = el.getAttribute(ATTRIBUTE_EXCLUDING);
        if (attr != null) {
            String[] strs = CDataUtil.stringToArray(attr, FLAGS_SEPARATOR);
            IPath[] paths = new IPath[strs.length];
            int i = 0;
            while (i < strs.length) {
                paths[i] = new Path(strs[i]);
                ++i;
            }
            return paths;
        }
        return null;
    }

    private static void storeExclusions(ICStorageElement el, IPath[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        String[] strs = new String[paths.length];
        int i = 0;
        while (i < strs.length) {
            strs[i] = paths[i].toString();
            ++i;
        }
        String attr = CDataUtil.arrayToString(strs, FLAGS_SEPARATOR);
        el.setAttribute(ATTRIBUTE_EXCLUDING, attr);
    }

    public static void serializeEntries(ICSettingEntry[] entries, ICStorageElement element) {
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                ICStorageElement child = element.createChild(ELEMENT_ENTRY);
                LanguageSettingEntriesSerializer.serializeEntry(entries[i], child);
                ++i;
            }
        }
    }

    public static void serializeEntry(ICSettingEntry entry, ICStorageElement element) {
        String kind = LanguageSettingEntriesSerializer.kindToString(entry.getKind());
        String flags = LanguageSettingEntriesSerializer.composeFlagsString(entry.getFlags());
        String name = entry.getName();
        element.setAttribute(ATTRIBUTE_KIND, kind);
        element.setAttribute(ATTRIBUTE_FLAGS, flags);
        element.setAttribute(ATTRIBUTE_NAME, name);
        switch (entry.getKind()) {
            case 4: {
                String value = entry.getValue();
                element.setAttribute(ATTRIBUTE_VALUE, value);
                break;
            }
            case 64: 
            case 128: {
                IPath[] paths = ((ICExclusionPatternPathEntry)entry).getExclusionPatterns();
                LanguageSettingEntriesSerializer.storeExclusions(element, paths);
                break;
            }
            case 32: {
                ICLibraryFileEntry libFile = (ICLibraryFileEntry)entry;
                IPath path = libFile.getSourceAttachmentPath();
                if (path != null) {
                    element.setAttribute(ATTRIBUTE_SOURCE_ATTACHMENT_PATH, path.toString());
                }
                if ((path = libFile.getSourceAttachmentRootPath()) != null) {
                    element.setAttribute(ATTRIBUTE_SOURCE_ATTACHMENT_ROOT_PATH, path.toString());
                }
                if ((path = libFile.getSourceAttachmentPrefixMapping()) == null) break;
                element.setAttribute(ATTRIBUTE_SOURCE_ATTACHMENT_PREFIX_MAPPING, path.toString());
            }
        }
    }

    public static String kindToString(int kind) {
        switch (kind) {
            case 1: {
                return INCLUDE_PATH;
            }
            case 2: {
                return INCLUDE_FILE;
            }
            case 4: {
                return MACRO;
            }
            case 8: {
                return MACRO_FILE;
            }
            case 16: {
                return LIBRARY_PATH;
            }
            case 32: {
                return LIBRARY_FILE;
            }
            case 128: {
                return SOURCE_PATH;
            }
            case 64: {
                return OUTPUT_PATH;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int stringToKind(String kind) {
        if (INCLUDE_PATH.equals(kind)) {
            return 1;
        }
        if (INCLUDE_FILE.equals(kind)) {
            return 2;
        }
        if (MACRO.equals(kind)) {
            return 4;
        }
        if (MACRO_FILE.equals(kind)) {
            return 8;
        }
        if (LIBRARY_PATH.equals(kind)) {
            return 16;
        }
        if (LIBRARY_FILE.equals(kind)) {
            return 32;
        }
        if (SOURCE_PATH.equals(kind)) {
            return 128;
        }
        if (OUTPUT_PATH.equals(kind)) {
            return 64;
        }
        return 0;
    }

    public static String composeFlagsString(int flags) {
        StringBuffer buf = new StringBuffer();
        if ((flags & 1) != 0) {
            buf.append(BUILTIN);
        }
        if ((flags & 2) != 0) {
            if (buf.length() != 0) {
                buf.append(FLAGS_SEPARATOR);
            }
            buf.append(READONLY);
        }
        if ((flags & 4) != 0) {
            if (buf.length() != 0) {
                buf.append(FLAGS_SEPARATOR);
            }
            buf.append(LOCAL);
        }
        if ((flags & 8) != 0) {
            if (buf.length() != 0) {
                buf.append(FLAGS_SEPARATOR);
            }
            buf.append(VALUE_WORKSPACE_PATH);
        }
        if ((flags & 0x10) != 0) {
            if (buf.length() != 0) {
                buf.append(FLAGS_SEPARATOR);
            }
            buf.append(RESOLVED);
        }
        return buf.toString();
    }

    private static int composeFlags(String flagsString) {
        if (flagsString == null || flagsString.length() == 0) {
            return 0;
        }
        StringTokenizer tokenizer = new StringTokenizer(flagsString, FLAGS_SEPARATOR);
        int flags = 0;
        while (tokenizer.hasMoreElements()) {
            String f = tokenizer.nextToken();
            if (BUILTIN.equals(f)) {
                flags |= 1;
            }
            if (READONLY.equals(f)) {
                flags |= 2;
            }
            if (LOCAL.equals(f)) {
                flags |= 4;
            }
            if (VALUE_WORKSPACE_PATH.equals(f)) {
                flags |= 8;
            }
            if (!RESOLVED.equals(f)) continue;
            flags |= 0x10;
        }
        return flags;
    }
}

