/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    private static final String EOL_XML = "\n";
    private static final String DEFAULT_IDENT = "\t";

    public static void prettyFormat(Document doc) {
        XmlUtil.prettyFormat(doc, DEFAULT_IDENT);
    }

    public static void prettyFormat(Document doc, String ident) {
        doc.normalize();
        Element documentElement = doc.getDocumentElement();
        if (documentElement != null) {
            XmlUtil.prettyFormat(documentElement, "", ident);
        }
    }

    private static void prettyFormat(Node node, String identLevel, String ident) {
        short type;
        NodeList nodelist = node.getChildNodes();
        int iStart = 0;
        Node item = nodelist.item(0);
        if (item != null && ((type = item.getNodeType()) == 1 || type == 8)) {
            Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel + ident);
            node.insertBefore(newChild, item);
            iStart = 1;
        }
        int i = iStart;
        while (i < nodelist.getLength()) {
            item = nodelist.item(i);
            if (item != null) {
                short type2 = item.getNodeType();
                if (type2 == 3 && item.getNodeValue().trim().length() == 0) {
                    if (i + 1 < nodelist.getLength()) {
                        item.setNodeValue(EOL_XML + identLevel + ident);
                    } else {
                        item.setNodeValue(EOL_XML + identLevel);
                    }
                } else if (type2 == 1) {
                    XmlUtil.prettyFormat(item, String.valueOf(identLevel) + ident, ident);
                    if (i + 1 < nodelist.getLength()) {
                        short nextType;
                        Node nextItem = nodelist.item(i + 1);
                        if (nextItem != null && ((nextType = nextItem.getNodeType()) == 1 || nextType == 8)) {
                            Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel + ident);
                            node.insertBefore(newChild, nextItem);
                            ++i;
                        }
                    } else {
                        Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel);
                        node.appendChild(newChild);
                        ++i;
                    }
                }
            }
            ++i;
        }
    }
}

