/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class ProgramRelativePathSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.programRelativePath";
    private IPath fProgramPath = Path.EMPTY;

    public ProgramRelativePathSourceContainer() {
    }

    public ProgramRelativePathSourceContainer(IBinary program) {
        if (program != null) {
            this.fProgramPath = program.getPath();
        }
    }

    public Object[] findSourceElements(String sourceName) throws CoreException {
        if (sourceName == null) {
            return new Object[0];
        }
        Path sourcePath = new Path(sourceName);
        if (sourcePath.isAbsolute()) {
            return new Object[0];
        }
        IPath programPath = this.getProgramLocation();
        if (programPath == Path.EMPTY) {
            return new Object[0];
        }
        sourcePath = (programPath = programPath.removeLastSegments(1)).append((IPath)sourcePath);
        File sourceFile = sourcePath.toFile();
        if (sourceFile.exists() && sourceFile.isFile()) {
            return new Object[]{new LocalFileStorage(sourceFile)};
        }
        return new Object[0];
    }

    public String getName() {
        return SourceLookupMessages.getString("ProgramRelativePathSourceContainer.0");
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    private synchronized IPath getProgramLocation() throws CoreException {
        if (this.fProgramPath.isEmpty()) {
            ISourceLookupDirector director = this.getDirector();
            if (director == null) {
                return this.fProgramPath;
            }
            ILaunchConfiguration configuration = director.getLaunchConfiguration();
            if (configuration == null) {
                return this.fProgramPath;
            }
            ICProject project = null;
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            if (!(projectName == null || (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null && project.exists())) {
                return this.fProgramPath;
            }
            String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
            if (programName == null) {
                return this.fProgramPath;
            }
            IFile exeFile = null;
            try {
                if (project == null) {
                    Path path = new Path(programName);
                    if (path.toFile().exists()) {
                        this.fProgramPath = path;
                        return this.fProgramPath;
                    }
                    return this.fProgramPath;
                }
                exeFile = project.getProject().getFile((IPath)new Path(programName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.fProgramPath;
            }
            if (!exeFile.exists()) {
                return this.fProgramPath;
            }
            this.fProgramPath = exeFile.getLocation();
        }
        return this.fProgramPath;
    }
}

