/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.part.ViewPart;

public class TraceView
extends ViewPart
implements Protocol.ChannelOpenListener {
    private Composite parent;
    private TabFolder tabs;
    private Label no_data;
    private final Map<TabItem, Page> tab2page = new HashMap<TabItem, Page>();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel[] arr;
                IChannel[] iChannelArray = arr = Protocol.getOpenChannels();
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    IChannel c = iChannelArray[n2];
                    TraceView.this.onChannelOpen(c);
                    ++n2;
                }
                Protocol.addChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
            }
        });
        if (this.tab2page.size() == 0) {
            this.hideTabs();
        }
    }

    public void setFocus() {
        if (this.tabs != null) {
            this.tabs.setFocus();
        }
    }

    public void dispose() {
        final Page[] pages = this.tab2page.values().toArray(new Page[this.tab2page.size()]);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Protocol.removeChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
                Page[] pageArray = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    Page p = pageArray[n2];
                    p.channel.removeTraceListener((AbstractChannel.TraceListener)p);
                    ++n2;
                }
            }
        });
        Page[] pageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page p = pageArray[n2];
            p.dispose();
            ++n2;
        }
        assert (this.tab2page.isEmpty());
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
        }
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
        }
        super.dispose();
    }

    public void onChannelOpen(IChannel channel) {
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        AbstractChannel c = (AbstractChannel)channel;
        IPeer rp = c.getRemotePeer();
        final String name = rp.getName();
        final String host = (String)rp.getAttributes().get("Host");
        final String port = (String)rp.getAttributes().get("Port");
        final Page p = new Page(c);
        c.addTraceListener((AbstractChannel.TraceListener)p);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                TraceView.this.showTabs();
                p.tab = new TabItem(TraceView.this.tabs, 0);
                TraceView.this.tab2page.put(p.tab, p);
                String title = name;
                if (host != null) {
                    title = String.valueOf(title) + ", " + host;
                    if (port != null) {
                        title = String.valueOf(title) + ":" + port;
                    }
                }
                p.tab.setText(title);
                p.text = new Text((Composite)TraceView.this.tabs, 2818);
                p.tab.setControl((Control)p.text);
                p.text.setBackground(TraceView.this.parent.getDisplay().getSystemColor(1));
            }
        });
    }

    private void showTabs() {
        boolean b = false;
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
            b = true;
        }
        if (this.tabs == null) {
            this.tabs = new TabFolder(this.parent, 0);
            b = true;
        }
        if (b) {
            this.parent.layout();
        }
    }

    private void hideTabs() {
        boolean b = false;
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
            b = true;
        }
        if (!this.parent.isDisposed()) {
            if (this.no_data == null) {
                this.no_data = new Label(this.parent, 0);
                this.no_data.setText("No open communication channels at this time.");
                b = true;
            }
            if (b) {
                this.parent.layout();
            }
        }
    }

    private class Page
    implements AbstractChannel.TraceListener {
        final AbstractChannel channel;
        private TabItem tab;
        private Text text;
        private final StringBuffer bf = new StringBuffer();
        private int bf_line_cnt = 0;
        private boolean closed;
        private final Thread update_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Page page = Page.this;
                synchronized (page) {
                    while (!Page.this.closed) {
                        if (Page.this.bf_line_cnt > 0) {
                            Runnable r = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    String str = null;
                                    int cnt = 0;
                                    Page page = Page.this;
                                    synchronized (page) {
                                        str = Page.this.bf.toString();
                                        cnt = Page.this.bf_line_cnt;
                                        Page.this.bf.setLength(0);
                                        Page.this.bf_line_cnt = 0;
                                    }
                                    if (Page.this.text == null) {
                                        return;
                                    }
                                    if (Page.this.text.getLineCount() > 1000 - cnt) {
                                        String s = Page.this.text.getText();
                                        int n = 0;
                                        int i = -1;
                                        while (n < cnt) {
                                            int j = s.indexOf(10, i + 1);
                                            if (j < 0) break;
                                            i = j;
                                            ++n;
                                        }
                                        if (i >= 0) {
                                            Page.this.text.setText(s.substring(i + 1));
                                        }
                                    }
                                    Page.this.text.append(str);
                                }
                            };
                            TraceView.this.getSite().getShell().getDisplay().asyncExec(r);
                        }
                        try {
                            Page.this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            }
        };

        Page(AbstractChannel channel) {
            this.channel = channel;
            this.update_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Page page = this;
            synchronized (page) {
                this.closed = true;
                this.update_thread.interrupt();
            }
            try {
                this.update_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TraceView.this.tab2page.remove(this.tab);
            this.tab.dispose();
            this.tab = null;
            this.text = null;
            if (TraceView.this.tab2page.isEmpty()) {
                TraceView.this.hideTabs();
            }
        }

        public synchronized void onChannelClosed(Throwable error) {
            if (error == null) {
                this.channel.removeTraceListener((AbstractChannel.TraceListener)this);
            } else {
                this.bf.append("Channel terminated: " + error);
                ++this.bf_line_cnt;
            }
        }

        public synchronized void onMessageReceived(char type, String token, String service, String name, byte[] data) {
            if (name != null && name.contains("HeartBeat")) {
                return;
            }
            try {
                this.bf.append("Time(ms): " + System.currentTimeMillis() + " Inp: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    int i = 0;
                    while (i < data.length) {
                        int j = i;
                        while (j < data.length && data[j] != 0) {
                            ++j;
                        }
                        this.bf.append(' ');
                        this.bf.append(new String(data, i, j - i, "UTF8"));
                        if (j >= data.length || data[j] == 0) {
                            // empty if block
                        }
                        i = ++j;
                    }
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }

        public synchronized void onMessageSent(char type, String token, String service, String name, byte[] data) {
            if (name != null && name.contains("HeartBeat")) {
                return;
            }
            try {
                this.bf.append("Time(ms): " + System.currentTimeMillis() + " Out: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    int i = 0;
                    while (i < data.length) {
                        int j = i;
                        while (j < data.length && data[j] != 0) {
                            ++j;
                        }
                        this.bf.append(' ');
                        this.bf.append(new String(data, i, j - i, "UTF8"));
                        if (j >= data.length || data[j] == 0) {
                            // empty if block
                        }
                        i = ++j;
                    }
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }
    }
}

