/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import java.math.BigInteger;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.dsf.debug.service.IInstruction;

public class EDCInstruction
implements IInstruction {
    private final IDisassembledInstruction instruction;

    public EDCInstruction(IDisassembledInstruction instruction) {
        this.instruction = instruction;
    }

    public BigInteger getAdress() {
        return this.instruction.getAddress().getValue();
    }

    public String getArgs() {
        String ret = null;
        String asm = this.instruction.getMnemonics();
        StringTokenizer tzer = new StringTokenizer(asm);
        if (tzer.countTokens() == 1) {
            return ret;
        }
        tzer.nextToken();
        ret = tzer.nextToken();
        while (tzer.hasMoreTokens()) {
            ret = String.valueOf(ret) + " " + tzer.nextToken();
        }
        return ret;
    }

    public String getFuntionName() {
        return null;
    }

    public String getInstruction() {
        return this.instruction.getMnemonics();
    }

    public long getOffset() {
        return 0L;
    }

    public String getOpcode() {
        return null;
    }

    public String toString() {
        return this.instruction.toString();
    }
}

