/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;

public class VariableWithValue
extends OperandValue {
    final IVariable variable;
    private final DsfServicesTracker servicesTracker;
    private final Stack.StackFrameDMC frame;

    public VariableWithValue(DsfServicesTracker servicesTracker, Stack.StackFrameDMC frame, IVariable variable) {
        this(servicesTracker, frame, variable, false);
    }

    public VariableWithValue(DsfServicesTracker servicesTracker, Stack.StackFrameDMC frame, IVariable variable, boolean isBitField) {
        super(variable.getType(), isBitField);
        this.servicesTracker = servicesTracker;
        this.frame = frame;
        this.variable = variable;
    }

    public VariableWithValue(DsfServicesTracker servicesTracker, Stack.StackFrameDMC frame, IVariable variable, IType otherType) {
        super(otherType, false);
        this.servicesTracker = servicesTracker;
        this.frame = frame;
        this.variable = variable;
    }

    public DsfServicesTracker getServicesTracker() {
        return this.servicesTracker;
    }

    public Stack.StackFrameDMC getFrame() {
        return this.frame;
    }

    public IVariable getVariable() {
        return this.variable;
    }

    public Number getValue() throws CoreException {
        if (this.value == null) {
            IVariableLocation location = this.getValueLocation();
            IType varType = this.type;
            if (varType != null) {
                this.value = this.getValueByType(varType, location);
            } else assert (false);
        }
        return this.value;
    }

    public IVariableLocation getValueLocation() {
        if (this.valueLocation == null) {
            IEDCModules modules = (IEDCModules)this.servicesTracker.getService(Modules.class);
            IModules.ISymbolDMContext symContext = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)this.frame, IModules.ISymbolDMContext.class);
            ILocationProvider provider = this.variable.getLocationProvider();
            if (provider == null) {
                this.valueLocation = new InvalidVariableLocation(ASTEvalMessages.VariableWithValue_CannotLocateVariable);
                return this.valueLocation;
            }
            IAddress pcValue = this.frame.getIPAddress();
            IEDCModuleDMContext module = modules.getModuleByAddress(symContext, pcValue);
            this.valueLocation = provider.getLocation(this.servicesTracker, this.frame, module.toLinkAddress(pcValue));
            if (this.valueLocation == null) {
                this.valueLocation = new InvalidVariableLocation(ASTEvalMessages.VariableWithValue_CannotLocateVariable);
            }
        }
        return this.valueLocation;
    }

    public OperandValue copyWithType(IType otherType) {
        VariableWithValue value = new VariableWithValue(this.servicesTracker, this.frame, this.variable, otherType);
        value.stringValue = this.stringValue;
        value.valueLocation = this.valueLocation;
        return value;
    }

    public void setType(IType type) {
        this.type = type;
    }
}

