/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.CompileUnitScope;
import org.eclipse.cdt.debug.edc.internal.symbols.LineEntry;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLineEntryProvider
implements IModuleLineEntryProvider {
    private Set<ICompileUnitScope> parsedCUs = new HashSet<ICompileUnitScope>();
    private Map<IPath, List<FileLineEntryProvider>> pathToLineEntryMap = new HashMap<IPath, List<FileLineEntryProvider>>();
    private List<FileLineEntryProvider> fileProviders = new ArrayList<FileLineEntryProvider>();
    private FileLineEntryProvider[] fileProviderArray;

    public void addCompileUnit(ICompileUnitScope cu) {
        if (this.parsedCUs.contains(cu)) {
            return;
        }
        this.parsedCUs.add(cu);
        Collection<ILineEntry> lineEntries = cu.getLineEntries();
        if (lineEntries.size() > 0) {
            HashMap<IPath, FileLineEntryProvider> fileProviders = new HashMap<IPath, FileLineEntryProvider>(4);
            for (ILineEntry entry : lineEntries) {
                IPath path = entry.getFilePath();
                FileLineEntryProvider provider = (FileLineEntryProvider)fileProviders.get(path);
                if (provider == null) {
                    provider = this.getFileLineProviderForCU(cu, path);
                    fileProviders.put(path, provider);
                }
                provider.addLineEntry(entry);
            }
        }
        for (IScope child : cu.getChildren()) {
            this.addCompileUnitChild(cu, child);
        }
    }

    public void addCompileUnitChild(ICompileUnitScope cu, IScope child) {
        IFunctionScope func;
        IPath declFile;
        if (child instanceof IFunctionScope && (declFile = (func = (IFunctionScope)child).getDeclFile()) != null) {
            FileLineEntryProvider provider = this.getFileLineProviderForCU(cu, declFile);
            int declLine = func.getDeclLine();
            int declColumn = func.getDeclColumn();
            Collection<ILineEntry> curEntries = provider.getLineEntriesForLines(declFile, declLine, declLine);
            if (curEntries.isEmpty()) {
                LineEntry entry = new LineEntry(declFile, declLine, declColumn, func.getLowAddress(), func.getLowAddress());
                provider.addLineEntry(entry);
            }
        }
    }

    private FileLineEntryProvider getFileLineProviderForCU(ICompileUnitScope cu, IPath declFile) {
        List<FileLineEntryProvider> providers = this.pathToLineEntryMap.get(declFile);
        if (providers != null) {
            for (FileLineEntryProvider p : providers) {
                if (!p.compileUnitScope.equals(cu)) continue;
                return p;
            }
        }
        FileLineEntryProvider provider = new FileLineEntryProvider(cu, declFile);
        this.registerFileLineEntryProvider(declFile, provider);
        return provider;
    }

    private void registerFileLineEntryProvider(IPath path, FileLineEntryProvider provider) {
        List<FileLineEntryProvider> fileEntries = this.pathToLineEntryMap.get(path);
        if (fileEntries == null) {
            fileEntries = new ArrayList<FileLineEntryProvider>();
            this.pathToLineEntryMap.put(path, fileEntries);
        }
        fileEntries.add(provider);
        this.fileProviders.add(provider);
        this.fileProviderArray = null;
    }

    @Override
    public Collection<ILineEntryProvider> getLineEntryProvidersForFile(IPath sourceFile) {
        List<FileLineEntryProvider> cus = this.pathToLineEntryMap.get(sourceFile);
        if (cus != null) {
            return Collections.unmodifiableCollection(cus);
        }
        for (Map.Entry<IPath, List<FileLineEntryProvider>> entry : this.pathToLineEntryMap.entrySet()) {
            if (PathUtils.isCaseSensitive() || entry.getKey().toOSString().compareToIgnoreCase(sourceFile.toOSString()) != 0) continue;
            cus = entry.getValue();
            this.pathToLineEntryMap.put(sourceFile, entry.getValue());
            return Collections.unmodifiableCollection(cus);
        }
        for (Map.Entry<IPath, List<FileLineEntryProvider>> entry : this.pathToLineEntryMap.entrySet()) {
            if (!entry.getKey().setDevice(null).equals((Object)sourceFile.setDevice(null))) continue;
            cus = entry.getValue();
            return Collections.unmodifiableCollection(cus);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ILineEntry> getLineEntriesForLines(IPath file, int startLineNumber, int endLineNumber) {
        List<FileLineEntryProvider> matches = this.pathToLineEntryMap.get(file);
        if (matches == null) {
            return Collections.emptyList();
        }
        ArrayList<ILineEntry> ret = null;
        for (FileLineEntryProvider provider : matches) {
            Collection<ILineEntry> entries = provider.getLineEntriesForLines(file, startLineNumber, endLineNumber);
            if (entries.isEmpty()) continue;
            if (ret == null) {
                ret = new ArrayList<ILineEntry>(entries);
                continue;
            }
            ret.addAll(entries);
        }
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public ILineEntry getLineEntryAtAddress(IAddress linkAddress) {
        if (this.fileProviderArray == null) {
            this.fileProviderArray = this.fileProviders.toArray(new FileLineEntryProvider[this.fileProviders.size()]);
        }
        FileLineEntryProvider[] fileLineEntryProviderArray = this.fileProviderArray;
        int n = this.fileProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILineEntry entry;
            FileLineEntryProvider provider = fileLineEntryProviderArray[n2];
            if (provider.compileUnitScope.getLowAddress().compareTo((Object)linkAddress) <= 0 && provider.compileUnitScope.getHighAddress().compareTo((Object)linkAddress) > 0 && (entry = provider.getLineEntryAtAddress(linkAddress)) != null) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ILineEntry getNextLineEntry(ILineEntry entry) {
        FileLineEntryProvider[] matchArray;
        List<FileLineEntryProvider> matches = this.pathToLineEntryMap.get(entry.getFilePath());
        if (matches == null) {
            return null;
        }
        FileLineEntryProvider[] fileLineEntryProviderArray = matchArray = matches.toArray(new FileLineEntryProvider[matches.size()]);
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILineEntry next;
            FileLineEntryProvider provider = fileLineEntryProviderArray[n2];
            if (provider.compileUnitScope.getLowAddress().compareTo((Object)entry.getLowAddress()) <= 0 && provider.compileUnitScope.getHighAddress().compareTo((Object)entry.getHighAddress()) > 0 && (next = provider.getNextLineEntry(entry)) != null) {
                return next;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileLineEntryProvider
    implements ILineEntryProvider {
        protected List<ILineEntry> lineEntries = new ArrayList<ILineEntry>();
        protected TreeMap<Integer, List<ILineEntry>> lineEntriesByLine = new TreeMap();
        private IPath filePath;
        private final ICompileUnitScope compileUnitScope;
        private boolean sorted;

        public FileLineEntryProvider(ICompileUnitScope compileUnitScope, IPath path) {
            this.compileUnitScope = compileUnitScope;
            this.filePath = path;
            this.sorted = true;
        }

        public String toString() {
            return this.filePath + " at " + ((CompileUnitScope)this.compileUnitScope).lowAddress + ": " + this.lineEntries.size() + " entries";
        }

        public void addLineEntry(ILineEntry entry) {
            this.lineEntries.add(entry);
            List<ILineEntry> currentMappings = this.lineEntriesByLine.get(entry.getLineNumber());
            if (currentMappings == null) {
                currentMappings = new ArrayList<ILineEntry>();
            }
            currentMappings.add(entry);
            this.lineEntriesByLine.put(entry.getLineNumber(), currentMappings);
            this.sorted = false;
        }

        @Override
        public ILineEntry getLineEntryAtAddress(IAddress linkAddress) {
            int insertion;
            if (!this.sorted) {
                Collections.sort(this.lineEntries);
                this.sorted = true;
            }
            if ((insertion = Collections.binarySearch(this.lineEntries, linkAddress)) >= 0) {
                return this.lineEntries.get(insertion);
            }
            if (insertion == -1) {
                return null;
            }
            ILineEntry entry = this.lineEntries.get((insertion = -insertion - 1) - 1);
            if (linkAddress.compareTo((Object)entry.getHighAddress()) < 0) {
                return entry;
            }
            return null;
        }

        @Override
        public Collection<ILineEntry> getLineEntriesForLines(IPath path, int startLineNumber, int endLineNumber) {
            if (!this.filePath.setDevice(null).equals((Object)path.setDevice(null)) && !PathUtils.isCaseSensitive() && this.filePath.toOSString().compareToIgnoreCase(path.toOSString()) != 0) {
                return Collections.emptyList();
            }
            List<ILineEntry> entries = new ArrayList<ILineEntry>();
            List<ILineEntry> startMappings = this.lineEntriesByLine.get(startLineNumber);
            if (startMappings != null) {
                if (startLineNumber == endLineNumber) {
                    entries.addAll(startMappings);
                } else {
                    List<ILineEntry> endMappings;
                    entries = endLineNumber == -1 ? this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), this.lineEntries.size()) : ((endMappings = this.lineEntriesByLine.get(endLineNumber)) != null ? this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), this.lineEntries.indexOf(endMappings.get(endMappings.size() - 1)) + 1) : this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), this.lineEntries.size()));
                }
            }
            return Collections.unmodifiableCollection(entries);
        }

        @Override
        public ILineEntry getNextLineEntry(ILineEntry lineEntry) {
            SortedMap<Integer, List<ILineEntry>> subMap;
            if (lineEntry.getFilePath().equals((Object)this.filePath) && !(subMap = this.lineEntriesByLine.tailMap(lineEntry.getLineNumber() + 1)).isEmpty()) {
                IFunctionScope function = this.ignoreInlineFunctions(this.compileUnitScope.getFunctionAtAddress(lineEntry.getLowAddress()));
                if (function == null) {
                    return null;
                }
                for (ILineEntry nextEntry : (List)subMap.get(subMap.firstKey())) {
                    IFunctionScope nextFunction = this.ignoreInlineFunctions(this.compileUnitScope.getFunctionAtAddress(nextEntry.getLowAddress()));
                    if (!function.equals(nextFunction) || nextEntry.getLowAddress().compareTo((Object)lineEntry.getHighAddress()) < 0) continue;
                    return nextEntry;
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private IFunctionScope ignoreInlineFunctions(IFunctionScope function) {
            if (function != null) ** GOTO lbl4
            return null;
lbl-1000:
            // 1 sources

            {
                function = (IFunctionScope)function.getParent();
lbl4:
                // 2 sources

                ** while (function.getParent() instanceof IFunctionScope)
            }
lbl5:
            // 1 sources

            return function;
        }
    }
}

