/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.disassembler.EDCInstruction;
import org.eclipse.cdt.debug.edc.disassembler.EDCMixedInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IInstruction;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMixedInstruction;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disassembly
extends AbstractEDCService
implements IDisassembly {
    public Disassembly(DsfSession session) {
        super(session, new String[]{IDisassembly.class.getName(), Disassembly.class.getName()});
    }

    public void getInstructions(IDisassembly.IDisassemblyDMContext context, BigInteger startAddress, BigInteger endAddress, DataRequestMonitor<IInstruction[]> drm) {
        final IDisassembler disassembler = this.getTargetEnvironmentService().getDisassembler();
        if (disassembler == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No disassembler is available yet.", null));
            drm.done();
            return;
        }
        long size = endAddress.longValue() - startAddress.longValue() + 16L;
        IMemory memoryService = (IMemory)this.getServicesTracker().getService(IMemory.class);
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
        Addr64 start = new Addr64(startAddress);
        Addr64 end = new Addr64(endAddress);
        memoryService.getMemory(mem_dmc, (IAddress)start, 0L, 1, (int)size, (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), drm, (IAddress)start, (IAddress)end, drm){
            private final /* synthetic */ IAddress val$start;
            private final /* synthetic */ IAddress val$end;
            private final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$start = iAddress;
                this.val$end = iAddress2;
                this.val$drm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                MemoryByte[] memBytes = (MemoryByte[])this.getData();
                byte[] bytes = new byte[memBytes.length];
                int i = 0;
                while (i < memBytes.length) {
                    bytes[i] = memBytes[i].getValue();
                    ++i;
                }
                ByteBuffer codeBuf = ByteBuffer.wrap(bytes);
                HashMap<String, Object> options = new HashMap<String, Object>();
                try {
                    List<IDisassembledInstruction> insts = disassembler.disassembleInstructions(this.val$start, this.val$end, codeBuf, options);
                    IInstruction[] ret = new IInstruction[insts.size()];
                    int i2 = 0;
                    while (i2 < insts.size()) {
                        ret[i2] = new EDCInstruction(insts.get(i2));
                        ++i2;
                    }
                    this.val$drm.setData((Object)ret);
                    this.val$drm.done();
                }
                catch (CoreException e) {
                    this.val$drm.setStatus(e.getStatus());
                    this.val$drm.done();
                }
            }
        });
    }

    public void getInstructions(final IDisassembly.IDisassemblyDMContext context, String filename, int linenum, final int lines, final DataRequestMonitor<IInstruction[]> drm) {
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        modulesService.calcAddressInfo(sym_dmc, filename, linenum, 0, (DataRequestMonitor)new DataRequestMonitor<IModules.AddressRange[]>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                IModules.AddressRange[] addr_ranges = (IModules.AddressRange[])this.getData();
                IAddress start = addr_ranges[0].getStartAddress();
                IAddress end = start.add((long)(lines * 4));
                Disassembly.this.getInstructions(context, start.getValue(), end.getValue(), (DataRequestMonitor<IInstruction[]>)drm);
            }
        });
    }

    public void getMixedInstructions(IDisassembly.IDisassemblyDMContext context, BigInteger startAddress, BigInteger endAddress, final DataRequestMonitor<IMixedInstruction[]> drm) {
        IModules.ISymbolDMContext sym_dmc;
        Addr64 start = new Addr64(startAddress);
        Addr64 end = new Addr64(endAddress);
        IEDCSymbols symbolsService = (IEDCSymbols)this.getServicesTracker().getService(Symbols.class);
        ILineEntry startEntry = symbolsService.getLineEntryForAddress(sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class), (IAddress)start);
        if (startEntry == null) {
            this.getInstructions(context, startAddress, endAddress, new DataRequestMonitor<IInstruction[]>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    IMixedInstruction[] ret = new IMixedInstruction[]{new EDCMixedInstruction("unknown", 0, (IInstruction[])this.getData())};
                    drm.setData((Object)ret);
                    drm.done();
                }
            });
        } else {
            final List<ILineEntry> codeLines = symbolsService.getLineEntriesForAddressRange(sym_dmc, (IAddress)start, (IAddress)end);
            final String srcFile = startEntry.getFilePath().toOSString();
            IEDCModules modulesService = (IEDCModules)this.getServicesTracker().getService(Modules.class);
            final IEDCModuleDMContext module = modulesService.getModuleByAddress(sym_dmc, (IAddress)start);
            startAddress = module.toRuntimeAddress(codeLines.get(0).getLowAddress()).getValue();
            this.getInstructions(context, startAddress, endAddress, new DataRequestMonitor<IInstruction[]>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    IInstruction[] instructions = (IInstruction[])this.getData();
                    int instsCnt = instructions.length;
                    int lineCnt = codeLines.size();
                    ArrayList<EDCMixedInstruction> mixedInstructions = new ArrayList<EDCMixedInstruction>();
                    ArrayList<IInstruction> instsForLine = new ArrayList<IInstruction>();
                    int k = 0;
                    int i = 0;
                    while (i < lineCnt && k < instsCnt) {
                        instsForLine.clear();
                        ILineEntry line = (ILineEntry)codeLines.get(i);
                        while (k < instsCnt && module.toLinkAddress((IAddress)new Addr64(instructions[k].getAdress())).compareTo((Object)line.getHighAddress()) < 0) {
                            instsForLine.add(instructions[k]);
                            ++k;
                        }
                        mixedInstructions.add(new EDCMixedInstruction(srcFile, line.getLineNumber(), instsForLine.toArray(new IInstruction[instsForLine.size()])));
                        ++i;
                    }
                    drm.setData((Object)mixedInstructions.toArray(new IMixedInstruction[mixedInstructions.size()]));
                    drm.done();
                }
            });
        }
    }

    public void getMixedInstructions(final IDisassembly.IDisassemblyDMContext context, String filename, int linenum, final int lines, final DataRequestMonitor<IMixedInstruction[]> drm) {
        IDisassembler disassembler = this.getTargetEnvironmentService().getDisassembler();
        if (disassembler == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No disassembler is available yet.", null));
            drm.done();
            return;
        }
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        modulesService.calcAddressInfo(sym_dmc, filename, linenum, 0, (DataRequestMonitor)new DataRequestMonitor<IModules.AddressRange[]>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                IModules.AddressRange[] addr_ranges = (IModules.AddressRange[])this.getData();
                IAddress start = addr_ranges[0].getStartAddress();
                IAddress end = start.add((long)(lines * 4));
                Disassembly.this.getMixedInstructions(context, start.getValue(), end.getValue(), (DataRequestMonitor<IMixedInstruction[]>)drm);
            }
        });
    }
}

