/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses
extends MIProcesses {
    private IGDBControl fGdb;
    private Map<Integer, String> fProcessNames = new HashMap<Integer, String>();

    public GDBProcesses(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), MIProcesses.class.getName(), GDBProcesses.class.getName()}, new Hashtable());
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        IProcesses.IProcessDMContext procDmc = this.createProcessContext(commandControl.getContext(), "");
        IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, "");
        this.fGdb.getInferiorProcess().setContainerContext(containerDmc);
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    @Override
    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            String inferiorPidStr;
            MIInferiorProcess inferior;
            MIInferiorProcess inferiorProcess;
            String pidStr = ((IMIProcessDMContext)dmc).getProcId();
            if ((pidStr == null || pidStr.length() == 0) && (inferiorProcess = this.fGdb.getInferiorProcess()) != null) {
                pidStr = inferiorProcess.getPid();
            }
            int pid = -1;
            try {
                pid = Integer.parseInt(pidStr);
            }
            catch (NumberFormatException numberFormatException) {}
            String name = this.fProcessNames.get(pid);
            if (name == null && (inferior = this.fGdb.getInferiorProcess()) != null && (inferiorPidStr = inferior.getPid()) != null && Integer.parseInt(inferiorPidStr) == pid) {
                IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
                name = backend.getProgramPath().lastSegment();
            }
            if (name == null) {
                name = "Unknown name";
                IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
                name = backend.getProgramPath().lastSegment();
            }
            rm.setData((Object)new MIProcesses.MIThreadDMData(name, pidStr));
            rm.done();
        } else {
            super.getExecutionData(dmc, rm);
        }
    }

    @Override
    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        MIInferiorProcess inferiorProcess = this.fGdb.getInferiorProcess();
        if (!this.fGdb.isConnected() && inferiorProcess != null && inferiorProcess.getState() != MIInferiorProcess.State.TERMINATED) {
            rm.setData((Object)true);
        } else {
            rm.setData((Object)false);
        }
        rm.done();
    }

    @Override
    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        super.attachDebuggerToProcess(procCtx, new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBProcesses.this.fGdb.setConnected(true);
                MIInferiorProcess inferiorProcess = GDBProcesses.this.fGdb.getInferiorProcess();
                if (inferiorProcess != null) {
                    inferiorProcess.setPid(((IMIProcessDMContext)procCtx).getProcId());
                }
                rm.setData((Object)((IDMContext)this.getData()));
                rm.done();
            }
        });
    }

    @Override
    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    @Override
    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        super.detachDebuggerFromProcess(dmc, new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBProcesses.this.fGdb.setConnected(false);
                MIInferiorProcess inferiorProcess = GDBProcesses.this.fGdb.getInferiorProcess();
                if (inferiorProcess != null) {
                    inferiorProcess.setPid(null);
                }
                rm.done();
            }
        });
    }

    @Override
    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        MIInferiorProcess inferiorProcess = this.fGdb.getInferiorProcess();
        if (this.fGdb.isConnected() && inferiorProcess != null && inferiorProcess.getState() != MIInferiorProcess.State.TERMINATED) {
            super.getProcessesBeingDebugged(dmc, rm);
        } else {
            rm.setData((Object)new IDMContext[0]);
            rm.done();
        }
    }

    @Override
    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend.getSessionType() == SessionType.LOCAL) {
            IProcessList list = null;
            try {
                list = CCorePlugin.getDefault().getProcessList();
            }
            catch (CoreException coreException) {}
            if (list == null) {
                this.fProcessNames.clear();
                rm.setData(null);
            } else {
                IProcessInfo[] procInfos;
                this.fProcessNames.clear();
                IProcessInfo[] iProcessInfoArray = procInfos = list.getProcessList();
                int n = procInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessInfo procInfo = iProcessInfoArray[n2];
                    this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                    ++n2;
                }
                rm.setData((Object)this.makeProcessDMCs(controlDmc, procInfos));
            }
            rm.done();
        } else {
            this.fProcessNames.clear();
            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
            rm.done();
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        IProcesses.IProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = this.createProcessContext(controlDmc, Integer.toString(processes[i].getPid()));
            ++i;
        }
        return procDmcs;
    }

    @Override
    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        if (thread instanceof IMIProcessDMContext) {
            this.fGdb.terminate(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
    }

    private class GDBContainerDMC
    extends MIProcesses.MIContainerDMC
    implements IMemory.IMemoryDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }
}

