/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.StringTokenizer;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIBreakpoint {
    int number = -1;
    String type = "";
    String disp = "";
    boolean enabled = false;
    String address = "";
    String func = "";
    String fullName = "";
    String file = "";
    int line = -1;
    String cond = "";
    int times = 0;
    String exp = "";
    String threadId = "0";
    int ignore = 0;
    String commands = "";
    int passcount = 0;
    boolean isWpt = false;
    boolean isAWpt = false;
    boolean isRWpt = false;
    boolean isWWpt = false;
    boolean isHdw = false;
    boolean isTpt = false;
    boolean isCatchpoint;
    private String catchpointType;

    public MIBreakpoint() {
    }

    public MIBreakpoint(MIBreakpoint other) {
        this.number = other.number;
        this.type = new String(other.type);
        this.disp = new String(other.disp);
        this.enabled = other.enabled;
        this.address = new String(other.address);
        this.func = new String(other.func);
        this.fullName = new String(other.fullName);
        this.file = new String(other.file);
        this.line = other.line;
        this.cond = new String(other.cond);
        this.times = other.times;
        this.exp = new String(other.exp);
        this.threadId = new String(other.threadId);
        this.ignore = other.ignore;
        this.commands = other.commands;
        this.passcount = other.passcount;
        this.isWpt = other.isWpt;
        this.isAWpt = other.isAWpt;
        this.isRWpt = other.isRWpt;
        this.isWWpt = other.isWWpt;
        this.isHdw = other.isHdw;
        this.isTpt = other.isTpt;
        this.isCatchpoint = other.isCatchpoint;
        this.catchpointType = other.catchpointType;
    }

    public MIBreakpoint(MITuple tuple) {
        this.parse(tuple);
    }

    public MIBreakpoint(String cliResult) {
        if (cliResult.startsWith("Catchpoint ")) {
            int bkptNumber = 0;
            StringTokenizer tokenizer = new StringTokenizer(cliResult);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String sub = tokenizer.nextToken();
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bkptNumber = Integer.parseInt(sub);
                        break;
                    }
                    case 2: {
                        if (sub.startsWith("(")) {
                            sub = sub.substring(1, sub.length() - 1);
                        }
                        this.catchpointType = sub;
                    }
                }
                ++i;
            }
            this.number = bkptNumber;
            this.isCatchpoint = true;
            this.enabled = true;
        } else assert (false) : "unexpected CLI output: " + cliResult;
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getLine() {
        return this.line;
    }

    public String getCondition() {
        return this.cond;
    }

    public void setCondition(String condition) {
        this.cond = condition;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public void setIgnoreCount(int ignoreCount) {
        this.ignore = ignoreCount;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public int getTimes() {
        return this.times;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getCatchpointType() {
        return this.catchpointType;
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isHardware() {
        return this.isHdw;
    }

    public void setHardware(boolean b) {
        this.isWpt = b;
        this.isHdw = b;
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void isWatchpoint(boolean b) {
        this.isWpt = b;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean b) {
        this.isWpt = b;
        this.isAWpt = b;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean b) {
        this.isWpt = b;
        this.isRWpt = b;
    }

    public boolean isWriteWatchpoint() {
        return this.isWWpt;
    }

    public void setWriteWatchpoint(boolean b) {
        this.isWpt = b;
        this.isWWpt = b;
    }

    public boolean isTracepoint() {
        return this.isTpt;
    }

    public boolean isCatchpoint() {
        return this.isCatchpoint;
    }

    public int getPassCount() {
        return this.passcount;
    }

    public void setPassCount(int count) {
        if (!this.isTpt) {
            return;
        }
        this.passcount = count;
    }

    public String getCommands() {
        return this.commands;
    }

    public void setCommands(String cmds) {
        this.commands = cmds;
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("number")) {
                try {
                    this.number = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("type")) {
                this.type = str;
                if (this.type.startsWith("hw")) {
                    this.isHdw = true;
                    this.isWWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("acc")) {
                    this.isAWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("read")) {
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("tracepoint") || this.type.startsWith("fast tracepoint")) {
                    this.isTpt = true;
                }
            } else if (var.equals("disp")) {
                this.disp = str;
            } else if (var.equals("enabled")) {
                this.enabled = str.equals("y");
            } else if (var.equals("addr")) {
                try {
                    this.address = str.trim();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("func")) {
                this.func = str;
            } else if (var.equals("file")) {
                this.file = str;
            } else if (var.equals("fullname")) {
                this.fullName = str;
            } else if (var.equals("thread")) {
                this.threadId = str;
            } else if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("times")) {
                try {
                    this.times = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("what") || var.equals("exp")) {
                this.exp = str;
            } else if (var.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("pass")) {
                try {
                    this.passcount = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("cond")) {
                this.cond = str;
            }
            ++i;
        }
    }
}

