/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.ErrorPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyPartCallback;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IInstruction;
import org.eclipse.cdt.dsf.debug.service.IMixedInstruction;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisassemblyBackendDsf
implements IDisassemblyBackend,
DsfSession.SessionEndedListener {
    private volatile IRunControl.IExecutionDMContext fTargetContext;
    private DsfServicesTracker fServicesTracker;
    private IStack.IFrameDMContext fTargetFrameContext;
    protected IStack.IFrameDMData fTargetFrameData;
    private String fDsfSessionId;
    private IDisassemblyPartCallback fCallback;

    public void init(IDisassemblyPartCallback callback) {
        assert (callback != null);
        this.fCallback = callback;
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public void dispose() {
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public static boolean supportsDebugContext_(IAdaptable context) {
        return context.getAdapter(IDMVMContext.class) != null;
    }

    public boolean supportsDebugContext(IAdaptable context) {
        return DisassemblyBackendDsf.supportsDebugContext_(context);
    }

    public boolean hasDebugContext() {
        return this.fTargetContext != null;
    }

    public IDisassemblyBackend.SetDebugContextResult setDebugContext(IAdaptable context) {
        IStack.IFrameDMContext frame;
        IRunControl.IExecutionDMContext newExeDmc;
        assert (this.supportsDebugContext(context)) : "caller should not have invoked us";
        IDMVMContext vmContext = (IDMVMContext)context.getAdapter(IDMVMContext.class);
        IDMContext dmContext = vmContext.getDMContext();
        IDisassemblyBackend.SetDebugContextResult result = new IDisassemblyBackend.SetDebugContextResult();
        result.sessionId = this.fDsfSessionId;
        String dsfSessionId = dmContext.getSessionId();
        if (!dsfSessionId.equals(this.fDsfSessionId)) {
            IStack.IFrameDMContext frame2;
            IRunControl.IExecutionDMContext executionContext;
            if (DisassemblyUtils.DEBUG) {
                System.out.println("DisassemblyBackendDsf() " + dsfSessionId);
            }
            this.fTargetContext = null;
            if (dmContext instanceof IStack.IFrameDMContext && (executionContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(frame2 = (IStack.IFrameDMContext)dmContext), IRunControl.IExecutionDMContext.class)) != null) {
                this.fTargetContext = executionContext;
                this.fTargetFrameContext = frame2;
            }
            if (this.fTargetContext != null) {
                DsfSession prevSession;
                if (this.fDsfSessionId != null && (prevSession = DsfSession.getSession((String)this.fDsfSessionId)) != null) {
                    try {
                        prevSession.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                prevSession.removeServiceEventListener((Object)DisassemblyBackendDsf.this);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
                result.sessionId = this.fDsfSessionId = dsfSessionId;
                if (this.fServicesTracker != null) {
                    this.fServicesTracker.dispose();
                }
                this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), this.fDsfSessionId);
                result.contextChanged = true;
                final DsfSession newSession = DsfSession.getSession((String)dsfSessionId);
                if (newSession != null) {
                    try {
                        newSession.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                newSession.addServiceEventListener((Object)DisassemblyBackendDsf.this, null);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
            }
        } else if (dmContext instanceof IStack.IFrameDMContext && (newExeDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(frame = (IStack.IFrameDMContext)dmContext), IRunControl.IExecutionDMContext.class)) != null) {
            IDisassembly.IDisassemblyDMContext oldDisDmc;
            IDisassembly.IDisassemblyDMContext newDisDmc = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)newExeDmc, IDisassembly.IDisassemblyDMContext.class);
            result.contextChanged = !newDisDmc.equals(oldDisDmc = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IDisassembly.IDisassemblyDMContext.class));
            this.fTargetContext = newExeDmc;
            this.fTargetFrameContext = frame;
            if (!result.contextChanged) {
                this.fCallback.gotoFrameIfActive(frame.getLevel());
            }
        }
        return result;
    }

    public void clearDebugContext() {
        final DsfSession session = DsfSession.getSession((String)this.fDsfSessionId);
        if (session != null) {
            try {
                session.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session.removeServiceEventListener((Object)DisassemblyBackendDsf.this);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
        this.fTargetContext = null;
        if (this.fServicesTracker != null) {
            this.fServicesTracker.dispose();
            this.fServicesTracker = null;
        }
    }

    public void retrieveFrameAddress(final int frame) {
        DsfExecutor executor = this.getSession().getExecutor();
        executor.execute((Runnable)new DsfRunnable(){

            public void run() {
                DisassemblyBackendDsf.this.retrieveFrameAddressInSessionThread(frame);
            }
        });
    }

    void retrieveFrameAddressInSessionThread(final int frame) {
        IStack stack = (IStack)this.fServicesTracker.getService(IStack.class);
        DsfExecutor executor = this.getSession().getExecutor();
        if (this.fTargetFrameContext == null) {
            if (frame == 0) {
                stack.getTopFrame((IDMContext)this.fTargetContext, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)executor, null){

                    protected void handleCompleted() {
                        DisassemblyBackendDsf.this.fCallback.setUpdatePending(false);
                        DisassemblyBackendDsf.this.fTargetFrameContext = (IStack.IFrameDMContext)this.getData();
                        if (DisassemblyBackendDsf.this.fTargetFrameContext != null) {
                            DisassemblyBackendDsf.this.retrieveFrameAddressInSessionThread(frame);
                        }
                    }
                });
            }
            return;
        }
        assert (frame == this.fTargetFrameContext.getLevel());
        stack.getFrameData(this.fTargetFrameContext, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)executor, null){

            protected void handleCompleted() {
                IStack.IFrameDMData frameData;
                DisassemblyBackendDsf.this.fCallback.setUpdatePending(false);
                DisassemblyBackendDsf.this.fTargetFrameData = frameData = (IStack.IFrameDMData)this.getData();
                if (!this.isCanceled() && frameData != null) {
                    final IAddress address = frameData.getAddress();
                    final BigInteger addressValue = address.getValue();
                    if (DisassemblyUtils.DEBUG) {
                        System.out.println("retrieveFrameAddress done " + DisassemblyUtils.getAddressText((BigInteger)addressValue));
                    }
                    DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                        public void run() {
                            if (address.getSize() * 8 != DisassemblyBackendDsf.this.fCallback.getAddressSize()) {
                                DisassemblyBackendDsf.this.fCallback.addressSizeChanged(address.getSize() * 8);
                            }
                            if (frame == 0) {
                                DisassemblyBackendDsf.this.fCallback.updatePC(addressValue);
                            } else {
                                DisassemblyBackendDsf.this.fCallback.gotoFrame(frame, addressValue);
                            }
                        }
                    });
                } else {
                    IStatus status = this.getStatus();
                    if (status != null && !status.isOK()) {
                        DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)DisassemblyBackendDsf.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                            }
                        });
                    }
                }
            }
        });
    }

    public boolean isSuspended() {
        DsfSession session = this.getSession();
        if (session == null || !session.isActive()) {
            return false;
        }
        if (session.getExecutor().isInExecutorThread()) {
            IRunControl runControl = this.getRunControl();
            if (runControl == null) {
                return false;
            }
            return runControl.isSuspended(this.fTargetContext);
        }
        Query<Boolean> query = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                try {
                    IRunControl runControl = DisassemblyBackendDsf.this.getRunControl();
                    if (runControl == null) {
                        rm.setData((Object)false);
                    } else {
                        rm.setData((Object)runControl.isSuspended(DisassemblyBackendDsf.this.fTargetContext));
                    }
                }
                finally {
                    rm.done();
                }
            }
        };
        session.getExecutor().execute((Runnable)query);
        try {
            return (Boolean)query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        return false;
    }

    private DsfSession getSession() {
        return DsfSession.getSession((String)this.fDsfSessionId);
    }

    private IRunControl getRunControl() {
        return this.getService(IRunControl.class);
    }

    private <V> V getService(Class<V> serviceClass) {
        if (this.fServicesTracker != null) {
            return (V)this.fServicesTracker.getService(serviceClass);
        }
        return null;
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        if (this.fTargetContext == null) {
            return;
        }
        IRunControl.IExecutionDMContext context = (IRunControl.IExecutionDMContext)event.getDMContext();
        if (context.equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)this.fTargetContext, (IDMContext)context)) {
            this.fCallback.asyncExec(new Runnable(){

                public void run() {
                    DisassemblyBackendDsf.this.fCallback.handleTargetEnded();
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        if (this.fTargetContext == null) {
            return;
        }
        IRunControl.IExecutionDMContext context = (IRunControl.IExecutionDMContext)event.getDMContext();
        if (context.equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)this.fTargetContext, (IDMContext)context)) {
            this.fCallback.handleTargetSuspended();
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        if (this.fTargetContext == null) {
            return;
        }
        IRunControl.IExecutionDMContext context = (IRunControl.IExecutionDMContext)event.getDMContext();
        if (context.equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)this.fTargetContext, (IDMContext)context)) {
            this.fCallback.handleTargetResumed();
        }
    }

    public void sessionEnded(DsfSession session) {
        if (session.getId().equals(this.fDsfSessionId)) {
            this.clearDebugContext();
            this.fCallback.handleTargetEnded();
        }
    }

    public int getFrameLevel() {
        if (this.fTargetFrameContext != null) {
            return this.fTargetFrameContext.getLevel();
        }
        return -1;
    }

    public boolean hasFrameContext() {
        return this.fTargetFrameContext != null;
    }

    public String getFrameFile() {
        return this.fTargetFrameData.getFile();
    }

    public int getFrameLine() {
        return this.fTargetFrameData.getLine();
    }

    public void retrieveDisassembly(final BigInteger startAddress, BigInteger endAddress, final String file, int lineNumber, int lines, boolean mixed, final boolean showSymbols, final boolean showDisassembly, final int linesHint) {
        final BigInteger finalEndAddress = startAddress.add(BigInteger.valueOf(32L)).max(endAddress);
        DsfSession session = this.getSession();
        if (session == null) {
            return;
        }
        DsfExecutor executor = session.getExecutor();
        IDisassembly.IDisassemblyDMContext context = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IDisassembly.IDisassemblyDMContext.class);
        if (mixed) {
            DataRequestMonitor<IMixedInstruction[]> disassemblyRequest = new DataRequestMonitor<IMixedInstruction[]>((Executor)executor, null){

                public void handleCompleted() {
                    final IMixedInstruction[] data = (IMixedInstruction[])this.getData();
                    if (!this.isCanceled() && data != null) {
                        DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                if (!DisassemblyBackendDsf.this.insertDisassembly(startAddress, finalEndAddress, data, showSymbols, showDisassembly)) {
                                    DisassemblyBackendDsf.this.fCallback.retrieveDisassembly(startAddress, finalEndAddress, linesHint, false, true);
                                }
                            }
                        });
                    } else {
                        final IStatus status = this.getStatus();
                        if (status != null && !status.isOK()) {
                            if (file != null) {
                                DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                    public void run() {
                                        DisassemblyBackendDsf.this.fCallback.retrieveDisassembly(startAddress, finalEndAddress, linesHint, true, true);
                                    }
                                });
                            } else {
                                DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                    public void run() {
                                        DisassemblyBackendDsf.this.fCallback.doScrollLocked(new Runnable(){

                                            public void run() {
                                                DisassemblyBackendDsf.this.fCallback.insertError(startAddress, status.getMessage());
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        DisassemblyBackendDsf.this.fCallback.setUpdatePending(false);
                    }
                }
            };
            if (file != null) {
                executor.execute(new Runnable((DataRequestMonitor)disassemblyRequest, context, file, lineNumber, lines){
                    private final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    private final /* synthetic */ IDisassembly.IDisassemblyDMContext val$context;
                    private final /* synthetic */ String val$file;
                    private final /* synthetic */ int val$lineNumber;
                    private final /* synthetic */ int val$lines;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                        this.val$context = iDisassemblyDMContext;
                        this.val$file = string;
                        this.val$lineNumber = n;
                        this.val$lines = n2;
                    }

                    public void run() {
                        IDisassembly disassembly = (IDisassembly)DisassemblyBackendDsf.this.fServicesTracker.getService(IDisassembly.class);
                        if (disassembly == null) {
                            this.val$disassemblyRequest.cancel();
                            this.val$disassemblyRequest.done();
                            return;
                        }
                        disassembly.getMixedInstructions(this.val$context, this.val$file, this.val$lineNumber, this.val$lines * 2, this.val$disassemblyRequest);
                    }
                });
            } else {
                executor.execute(new Runnable((DataRequestMonitor)disassemblyRequest, context, startAddress, finalEndAddress){
                    private final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    private final /* synthetic */ IDisassembly.IDisassemblyDMContext val$context;
                    private final /* synthetic */ BigInteger val$startAddress;
                    private final /* synthetic */ BigInteger val$finalEndAddress;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                        this.val$context = iDisassemblyDMContext;
                        this.val$startAddress = bigInteger;
                        this.val$finalEndAddress = bigInteger2;
                    }

                    public void run() {
                        IDisassembly disassembly = (IDisassembly)DisassemblyBackendDsf.this.fServicesTracker.getService(IDisassembly.class);
                        if (disassembly == null) {
                            this.val$disassemblyRequest.cancel();
                            this.val$disassemblyRequest.done();
                            return;
                        }
                        disassembly.getMixedInstructions(this.val$context, this.val$startAddress, this.val$finalEndAddress, this.val$disassemblyRequest);
                    }
                });
            }
        } else {
            DataRequestMonitor<IInstruction[]> disassemblyRequest = new DataRequestMonitor<IInstruction[]>((Executor)executor, null){

                public void handleCompleted() {
                    if (!this.isCanceled() && this.getData() != null) {
                        DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                if (!DisassemblyBackendDsf.this.insertDisassembly(startAddress, finalEndAddress, (IInstruction[])this.getData(), showSymbols, showDisassembly)) {
                                    DisassemblyBackendDsf.this.fCallback.doScrollLocked(new Runnable(){

                                        public void run() {
                                            DisassemblyBackendDsf.this.fCallback.insertError(startAddress, DisassemblyMessages.DisassemblyBackendDsf_error_UnableToRetrieveData);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        final IStatus status = this.getStatus();
                        if (status != null && !status.isOK()) {
                            DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                public void run() {
                                    DisassemblyBackendDsf.this.fCallback.doScrollLocked(new Runnable(){

                                        public void run() {
                                            DisassemblyBackendDsf.this.fCallback.insertError(startAddress, status.getMessage());
                                        }
                                    });
                                }
                            });
                        }
                        DisassemblyBackendDsf.this.fCallback.setUpdatePending(false);
                    }
                }
            };
            executor.execute(new Runnable((DataRequestMonitor)disassemblyRequest, context, startAddress, finalEndAddress){
                private final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                private final /* synthetic */ IDisassembly.IDisassemblyDMContext val$context;
                private final /* synthetic */ BigInteger val$startAddress;
                private final /* synthetic */ BigInteger val$finalEndAddress;
                {
                    this.val$disassemblyRequest = dataRequestMonitor;
                    this.val$context = iDisassemblyDMContext;
                    this.val$startAddress = bigInteger;
                    this.val$finalEndAddress = bigInteger2;
                }

                public void run() {
                    IDisassembly disassembly = (IDisassembly)DisassemblyBackendDsf.this.fServicesTracker.getService(IDisassembly.class);
                    if (disassembly == null) {
                        this.val$disassemblyRequest.cancel();
                        this.val$disassemblyRequest.done();
                        return;
                    }
                    disassembly.getInstructions(this.val$context, this.val$startAddress, this.val$finalEndAddress, this.val$disassemblyRequest);
                }
            });
        }
    }

    private boolean insertDisassembly(BigInteger startAddress, BigInteger endAddress, IInstruction[] instructions, boolean showSymbols, boolean showDisassembly) {
        if (!this.fCallback.hasViewer() || this.fDsfSessionId == null) {
            return true;
        }
        if (DisassemblyUtils.DEBUG) {
            System.out.println("insertDisassembly " + DisassemblyUtils.getAddressText((BigInteger)startAddress));
        }
        assert (this.fCallback.getUpdatePending());
        if (!this.fCallback.getUpdatePending()) {
            return true;
        }
        boolean insertedStartAddress = startAddress == null;
        try {
            this.fCallback.lockScroller();
            AddressRangePosition p = null;
            int j = 0;
            while (j < instructions.length) {
                IInstruction instruction = instructions[j];
                BigInteger address = instruction.getAdress();
                if (startAddress == null || startAddress.compareTo(BigInteger.ZERO) < 0) {
                    startAddress = address;
                    this.fCallback.setGotoAddressPending(address);
                }
                if (p == null || !p.containsAddress(address)) {
                    p = this.fCallback.getPositionOfAddress(address);
                }
                if (p instanceof ErrorPosition && p.fValid) {
                    p.fValid = false;
                    this.fCallback.getDocument().addInvalidAddressRange(p);
                } else {
                    if (p == null || address.compareTo(endAddress) > 0) {
                        if (DisassemblyUtils.DEBUG) {
                            System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                        }
                        boolean bl = insertedStartAddress;
                        return bl;
                    }
                    if (p.fValid) {
                        if (DisassemblyUtils.DEBUG) {
                            System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                        }
                        if (!p.fAddressOffset.equals(address)) {
                            p.fValid = false;
                            this.fCallback.getDocument().addInvalidAddressRange(p);
                        } else {
                            boolean bl = insertedStartAddress;
                            return bl;
                        }
                    }
                }
                try {
                    boolean hasSource = false;
                    String compilationPath = null;
                    String functionName = instruction.getFuntionName();
                    if (functionName != null && functionName.length() > 0 && instruction.getOffset() == 0L) {
                        p = this.fCallback.getDocument().insertLabel(p, address, functionName, showSymbols && (!hasSource || showDisassembly));
                    }
                    BigInteger instrLength = null;
                    if (j < instructions.length - 1) {
                        instrLength = instructions[j + 1].getAdress().subtract(instruction.getAdress()).abs();
                    }
                    if (instrLength == null) {
                        break;
                    }
                    String opCode = functionName != null && functionName.length() > 0 ? String.valueOf(functionName) + '+' + instruction.getOffset() : "";
                    insertedStartAddress = insertedStartAddress || address.compareTo(startAddress) == 0;
                    p = this.fCallback.getDocument().insertDisassemblyLine(p, address, instrLength.intValue(), opCode, instruction.getInstruction(), compilationPath, -1);
                    if (p == null && insertedStartAddress) {
                        break;
                    }
                    ++j;
                    continue;
                }
                catch (BadLocationException e) {
                    DisassemblyUtils.internalError((Throwable)e);
                }
                break;
            }
        }
        finally {
            this.fCallback.setUpdatePending(false);
            if (insertedStartAddress) {
                this.fCallback.updateInvalidSource();
                this.fCallback.unlockScroller();
                this.fCallback.doPending();
                this.fCallback.updateVisibleArea();
            } else {
                this.fCallback.unlockScroller();
            }
        }
        return insertedStartAddress;
    }

    /*
     * Exception decompiling
     */
    private boolean insertDisassembly(BigInteger startAddress, BigInteger endAddress, IMixedInstruction[] mixedInstructions, boolean showSymbols, boolean showDisassembly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object insertSource(Position pos, BigInteger address, final String file, int lineNumber) {
        Object sourceElement = null;
        final ISourceLookup.ISourceLookupDMContext ctx = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, ISourceLookup.ISourceLookupDMContext.class);
        final DsfExecutor executor = this.getSession().getExecutor();
        Query<Object> query = new Query<Object>(){

            protected void execute(final DataRequestMonitor<Object> rm) {
                DataRequestMonitor<Object> request = new DataRequestMonitor<Object>((Executor)executor, rm){

                    protected void handleSuccess() {
                        rm.setData(this.getData());
                        rm.done();
                    }
                };
                ISourceLookup lookup = (ISourceLookup)DisassemblyBackendDsf.this.getService(ISourceLookup.class);
                lookup.getSource(ctx, file, (DataRequestMonitor)request);
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            sourceElement = query.get();
        }
        catch (InterruptedException exc) {
            DisassemblyUtils.internalError((Throwable)exc);
        }
        catch (ExecutionException exc) {
            DisassemblyUtils.internalError((Throwable)exc);
        }
        return sourceElement;
    }

    public void gotoSymbol(final String symbol) {
        final DsfExecutor executor = this.getSession().getExecutor();
        executor.execute((Runnable)new DsfRunnable(){

            public void run() {
                final IExpressions expressions = (IExpressions)DisassemblyBackendDsf.this.getService(IExpressions.class);
                if (expressions == null) {
                    return;
                }
                final IExpressions.IExpressionDMContext exprDmc = expressions.createExpression((IDMContext)DisassemblyBackendDsf.this.fTargetContext, symbol);
                expressions.getExpressionAddressData(exprDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)executor, null){

                    protected void handleSuccess() {
                        IExpressions.IExpressionDMAddress data = (IExpressions.IExpressionDMAddress)this.getData();
                        final IAddress address = data.getAddress();
                        if (address != null) {
                            DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                public void run() {
                                    DisassemblyBackendDsf.this.fCallback.gotoAddress(address.getValue());
                                }
                            });
                        }
                    }

                    protected void handleError() {
                        IFormattedValues.FormattedValueDMContext valueDmc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format");
                        expressions.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)executor, null){

                            protected void handleSuccess() {
                                IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                                String value = data.getFormattedValue();
                                final BigInteger address = DisassemblyUtils.decodeAddress((String)value);
                                if (address != null) {
                                    DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                        public void run() {
                                            DisassemblyBackendDsf.this.fCallback.gotoAddress(address);
                                        }
                                    });
                                }
                            }

                            protected void handleError() {
                                DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                                    public void run() {
                                        ErrorDialog.openError((Shell)DisassemblyBackendDsf.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void retrieveDisassembly(final String file, final int lines, final BigInteger endAddress, boolean mixed, final boolean showSymbols, final boolean showDisassembly) {
        String debuggerPath = file;
        final ISourceLookup.ISourceLookupDMContext ctx = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, ISourceLookup.ISourceLookupDMContext.class);
        final DsfExecutor executor = this.getSession().getExecutor();
        Query<String> query = new Query<String>(){

            protected void execute(final DataRequestMonitor<String> rm) {
                DataRequestMonitor<String> request = new DataRequestMonitor<String>((Executor)executor, rm){

                    protected void handleSuccess() {
                        rm.setData((Object)((String)this.getData()));
                        rm.done();
                    }
                };
                ISourceLookup lookup = (ISourceLookup)DisassemblyBackendDsf.this.getService(ISourceLookup.class);
                lookup.getDebuggerPath(ctx, (Object)file, (DataRequestMonitor)request);
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            debuggerPath = (String)query.get();
        }
        catch (InterruptedException exc) {
            DisassemblyUtils.internalError((Throwable)exc);
        }
        catch (ExecutionException exc) {
            DisassemblyUtils.internalError((Throwable)exc);
        }
        IDisassembly.IDisassemblyDMContext context = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IDisassembly.IDisassemblyDMContext.class);
        String finalFile = debuggerPath;
        DataRequestMonitor<IMixedInstruction[]> disassemblyRequest = new DataRequestMonitor<IMixedInstruction[]>((Executor)executor, null){

            public void handleCompleted() {
                final IMixedInstruction[] data = (IMixedInstruction[])this.getData();
                if (!this.isCanceled() && data != null) {
                    DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                        public void run() {
                            if (!DisassemblyBackendDsf.this.insertDisassembly(null, endAddress, data, showSymbols, showDisassembly)) {
                                DisassemblyBackendDsf.this.retrieveDisassembly(file, lines, endAddress, false, showSymbols, showDisassembly);
                            }
                        }
                    });
                } else {
                    IStatus status = this.getStatus();
                    if (status != null && !status.isOK()) {
                        DisassemblyBackendDsf.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)DisassemblyBackendDsf.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                            }
                        });
                    }
                    DisassemblyBackendDsf.this.fCallback.setUpdatePending(false);
                }
            }
        };
        assert (!this.fCallback.getUpdatePending());
        this.fCallback.setUpdatePending(true);
        executor.execute(new Runnable((DataRequestMonitor)disassemblyRequest, context, finalFile, lines){
            private final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
            private final /* synthetic */ IDisassembly.IDisassemblyDMContext val$context;
            private final /* synthetic */ String val$finalFile;
            private final /* synthetic */ int val$lines;
            {
                this.val$disassemblyRequest = dataRequestMonitor;
                this.val$context = iDisassemblyDMContext;
                this.val$finalFile = string;
                this.val$lines = n;
            }

            public void run() {
                IDisassembly disassembly = (IDisassembly)DisassemblyBackendDsf.this.fServicesTracker.getService(IDisassembly.class);
                if (disassembly == null) {
                    this.val$disassemblyRequest.cancel();
                    this.val$disassemblyRequest.done();
                    return;
                }
                disassembly.getMixedInstructions(this.val$context, this.val$finalFile, 1, this.val$lines, this.val$disassemblyRequest);
            }
        });
    }

    public String evaluateExpression(final String expression) {
        if (this.fTargetFrameContext == null) {
            return null;
        }
        final DsfExecutor executor = DsfSession.getSession((String)this.fDsfSessionId).getExecutor();
        Query<IFormattedValues.FormattedValueDMData> query = new Query<IFormattedValues.FormattedValueDMData>(){

            protected void execute(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
                IRunControl.IExecutionDMContext exeCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)DisassemblyBackendDsf.this.fTargetFrameContext, IRunControl.IExecutionDMContext.class);
                IRunControl rc = (IRunControl)DisassemblyBackendDsf.this.getService(IRunControl.class);
                if (rc == null || !rc.isSuspended(exeCtx)) {
                    rm.done();
                    return;
                }
                IExpressions expressions = (IExpressions)DisassemblyBackendDsf.this.getService(IExpressions.class);
                if (expressions == null) {
                    rm.done();
                    return;
                }
                IExpressions.IExpressionDMContext exprDmc = expressions.createExpression((IDMContext)DisassemblyBackendDsf.this.fTargetFrameContext, expression);
                IFormattedValues.FormattedValueDMContext valueDmc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format");
                expressions.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)executor, rm){

                    protected void handleSuccess() {
                        IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                        rm.setData((Object)data);
                        rm.done();
                    }
                });
            }
        };
        executor.execute((Runnable)query);
        IFormattedValues.FormattedValueDMData data = null;
        try {
            data = (IFormattedValues.FormattedValueDMData)query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        if (data != null) {
            return data.getFormattedValue();
        }
        return null;
    }
}

