/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AddressBarContributionItem;
import org.eclipse.jface.action.Action;

public class JumpToAddressAction
extends Action {
    DisassemblyPart fDisassemblyPart = null;

    public JumpToAddressAction(DisassemblyPart disassemblyPart) {
        this.fDisassemblyPart = disassemblyPart;
    }

    public void run() {
        AddressBarContributionItem addressBar = this.fDisassemblyPart.getAddressBar();
        if (addressBar != null && addressBar.isEnabled() && this.fDisassemblyPart.isSuspended()) {
            String location = addressBar.getText();
            if (location == null || location.trim().length() == 0) {
                return;
            }
            location = location.trim();
            BigInteger address = null;
            try {
                address = DisassemblyUtils.decodeAddress((String)location);
                if (address.compareTo(BigInteger.ZERO) < 0) {
                    address = null;
                    addressBar.setWarningIconVisible(true);
                    this.fDisassemblyPart.generateErrorDialog(DisassemblyMessages.Disassembly_GotoAddressDialog_error_invalid_address);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            addressBar.setWarningIconVisible(false);
            if (address != null) {
                this.fDisassemblyPart.gotoAddress(address);
            } else {
                this.fDisassemblyPart.gotoSymbol(location);
            }
        }
    }

    protected void activateDisassemblyContext() {
        this.fDisassemblyPart.activateDisassemblyContext();
    }

    protected void deactivateDisassemblyContext() {
        this.fDisassemblyPart.deactivateDisassemblyContext();
    }
}

