/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigScope;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultSIFileReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerConfigProfile {
    private final String id;
    private ScannerInfoCollector scannerInfoCollector;
    private BuildOutputProvider buildOutputProvider;
    private Map<String, ScannerInfoProvider> scannerInfoProviders = new LinkedHashMap<String, ScannerInfoProvider>();
    private Boolean supportsContext;

    public ScannerConfigProfile(String profileId) {
        this.id = profileId;
        this.load();
    }

    private void load() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", "ScannerConfigurationDiscoveryProfile");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String rProfileId = extensions[i].getUniqueIdentifier();
                if (rProfileId != null && rProfileId.equals(this.getId())) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String providerId;
                        String name = configElements[j].getName();
                        if (this.scannerInfoCollector == null && name.equals("scannerInfoCollector")) {
                            this.scannerInfoCollector = new ScannerInfoCollector(configElements[j]);
                        } else if (name.equals("buildOutputProvider")) {
                            this.buildOutputProvider = new BuildOutputProvider(configElements[j]);
                        } else if (name.equals("scannerInfoProvider") && (providerId = configElements[j].getAttribute("providerId")) != null && this.scannerInfoProviders.get(providerId) == null) {
                            this.scannerInfoProviders.put(providerId, new ScannerInfoProvider(configElements[j]));
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getSIProviderIds() {
        return new ArrayList<String>(this.scannerInfoProviders.keySet());
    }

    public BuildOutputProvider getBuildOutputProviderElement() {
        return this.buildOutputProvider;
    }

    public ScannerInfoCollector getScannerInfoCollectorElement() {
        return this.scannerInfoCollector;
    }

    public ScannerConfigScope getProfileScope() {
        ScannerConfigScope scope = null;
        if (this.scannerInfoCollector != null) {
            if (this.scannerInfoCollector.getScope().equals(ScannerConfigScope.PROJECT_SCOPE.toString())) {
                scope = ScannerConfigScope.PROJECT_SCOPE;
            } else if (this.scannerInfoCollector.getScope().equals(ScannerConfigScope.FILE_SCOPE.toString())) {
                scope = ScannerConfigScope.FILE_SCOPE;
            }
        }
        return scope;
    }

    public ScannerInfoProvider getScannerInfoProviderElement(String providerId) {
        return this.scannerInfoProviders.get(providerId);
    }

    public boolean supportsContext() {
        if (this.supportsContext == null) {
            Object o;
            ScannerInfoCollector cr = this.getScannerInfoCollectorElement();
            if (cr != null && (o = cr.createScannerInfoCollector()) != null) {
                Class<?> clazz = o.getClass();
                try {
                    clazz.getMethod("setInfoContext", InfoContext.class);
                    this.supportsContext = Boolean.TRUE;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (this.supportsContext == null) {
                this.supportsContext = Boolean.FALSE;
            }
        }
        return this.supportsContext;
    }

    protected abstract class Action {
        protected IConfigurationElement configElem;

        protected Action(IConfigurationElement configElem) {
            this.configElem = configElem;
        }

        public Object createExternalScannerInfoProvider() {
            if (this.configElem.getAttribute("class") != null) {
                try {
                    return this.configElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    MakeCorePlugin.log(e);
                }
            }
            return null;
        }

        public String getAttribute(String name) {
            return this.configElem.getAttribute(name);
        }
    }

    public final class BuildOutputProvider {
        private Open openFileAction;
        private ScannerInfoConsoleParser scannerInfoConsoleParser;

        public BuildOutputProvider(IConfigurationElement provider) {
            IConfigurationElement[] actions = provider.getChildren("open");
            if (actions.length > 0) {
                this.openFileAction = new Open(actions[0]);
            }
            IConfigurationElement[] parsers = provider.getChildren("scannerInfoConsoleParser");
            this.scannerInfoConsoleParser = new ScannerInfoConsoleParser(parsers[0]);
        }

        public Action getAction() {
            return this.openFileAction;
        }

        public ScannerInfoConsoleParser getScannerInfoConsoleParser() {
            return this.scannerInfoConsoleParser;
        }
    }

    public final class Open
    extends Action {
        public Open(IConfigurationElement open) {
            super(open);
        }

        public Object createExternalScannerInfoProvider() {
            Object provider = super.createExternalScannerInfoProvider();
            if (provider == null) {
                provider = new DefaultSIFileReader();
            }
            return provider;
        }
    }

    public final class Run
    extends Action {
        public Run(IConfigurationElement run) {
            super(run);
        }

        public Object createExternalScannerInfoProvider() {
            Object provider = super.createExternalScannerInfoProvider();
            if (provider == null) {
                provider = new DefaultRunSIProvider();
            }
            return provider;
        }
    }

    public class ScannerInfoCollector {
        private IConfigurationElement configElem;

        public ScannerInfoCollector(IConfigurationElement configElem) {
            this.configElem = configElem;
        }

        public Object createScannerInfoCollector() {
            try {
                return this.configElem.createExecutableExtension("class");
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                return null;
            }
        }

        public String getScope() {
            return this.configElem.getAttribute("scope");
        }
    }

    public final class ScannerInfoConsoleParser {
        private IConfigurationElement configElem;

        public ScannerInfoConsoleParser(IConfigurationElement configElem) {
            this.configElem = configElem;
        }

        public Object createScannerInfoConsoleParser() {
            try {
                return this.configElem.createExecutableExtension("class");
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                return null;
            }
        }

        public String getCompilerCommands() {
            return this.configElem.getAttribute("compilerCommands");
        }
    }

    public final class ScannerInfoProvider {
        public static final String RUN = "run";
        public static final String OPEN = "open";
        private String providerId;
        private String providerKind;
        private Action action;
        private ScannerInfoConsoleParser scannerInfoConsoleParser;

        public ScannerInfoProvider(IConfigurationElement provider) {
            this.providerId = provider.getAttribute("providerId");
            IConfigurationElement[] actions = provider.getChildren();
            this.providerKind = actions[0].getName();
            if (this.providerKind.equals(RUN)) {
                this.action = new Run(actions[0]);
            } else if (this.providerKind.equals(OPEN)) {
                this.action = new Open(actions[0]);
            }
            IConfigurationElement[] parsers = provider.getChildren("scannerInfoConsoleParser");
            this.scannerInfoConsoleParser = new ScannerInfoConsoleParser(parsers[0]);
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getProviderKind() {
            return this.providerKind;
        }

        public Action getAction() {
            return this.action;
        }

        public ScannerInfoConsoleParser getScannerInfoConsoleParser() {
            return this.scannerInfoConsoleParser;
        }
    }
}

