/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean checked = false;
    private static IPath binDir = null;
    private IBuildEnvironmentVariable path;

    public static IPath getBinDir() {
        if (!checked) {
            MingwEnvironmentVariableSupplier.findBinDir();
        }
        return binDir;
    }

    private static void findBinDir() {
        String mingwPath;
        WindowsRegistry registry;
        Path subPath = new Path("mingw\\bin");
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        IPath binPathTemp = installPath.append((IPath)subPath);
        if (binPathTemp.toFile().isDirectory()) {
            binDir = binPathTemp;
        }
        if (binDir == null && (binPathTemp = installPath.removeLastSegments(1).append((IPath)subPath)).toFile().isDirectory()) {
            binDir = binPathTemp;
        }
        if (binDir == null) {
            String[] paths;
            String pathVariable = System.getenv("PATH");
            String[] stringArray = paths = pathVariable.split(";");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                File pathFile;
                String pathStr = stringArray[n2];
                if ((pathStr.endsWith("\\") || pathStr.endsWith("/")) && pathStr.length() > 1) {
                    pathStr = pathStr.substring(0, pathStr.length() - 1);
                }
                if ((pathFile = new File(String.valueOf(pathStr) + "\\mingw32-gcc.exe")).exists()) {
                    binDir = new Path(pathStr);
                    break;
                }
                ++n2;
            }
        }
        if (binDir == null && (registry = WindowsRegistry.getRegistry()) != null && (mingwPath = registry.getLocalMachineValue("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MinGW", "InstallLocation")) != null && (binPathTemp = new Path(mingwPath).append("bin")).toFile().isDirectory()) {
            binDir = binPathTemp;
        }
        if (binDir == null && (binPathTemp = new Path("C:\\MinGW\\bin")).toFile().isDirectory()) {
            binDir = binPathTemp;
        }
        checked = true;
    }

    public static IPath getMsysBinDir() {
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        IPath msysBinPath = installPath.append("msys\\bin");
        return msysBinPath.toFile().isDirectory() ? msysBinPath : null;
    }

    public MingwEnvironmentVariableSupplier() {
        IPath binPath = MingwEnvironmentVariableSupplier.getBinDir();
        if (binPath != null) {
            String pathStr = binPath.toOSString();
            IPath msysBinPath = MingwEnvironmentVariableSupplier.getMsysBinDir();
            if (msysBinPath != null) {
                pathStr = String.valueOf(pathStr) + ';' + msysBinPath.toOSString();
            }
            this.path = new MingwBuildEnvironmentVariable("PATH", pathStr, 3);
        }
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (this.path != null && variableName.equals(this.path.getName())) {
            return this.path;
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        if (this.path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[1];
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[0] = this.path;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class MingwBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public MingwBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return ";";
        }
    }
}

