/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class NewMakeProjFromExistingPage
extends WizardPage {
    Text projectName;
    Text location;
    Button langc;
    Button langcpp;
    IWorkspaceRoot root;
    List tcList;
    Map<String, IToolChain> tcMap = new HashMap<String, IToolChain>();

    protected NewMakeProjFromExistingPage() {
        super(Messages.NewMakeProjFromExistingPage_0);
        this.setTitle(Messages.NewMakeProjFromExistingPage_1);
        this.setDescription(Messages.NewMakeProjFromExistingPage_2);
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addProjectNameSelector(comp);
        this.addSourceSelector(comp);
        this.addLanguageSelector(comp);
        this.addToolchainSelector(comp);
        this.setControl((Control)comp);
    }

    public void addProjectNameSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_3);
        this.projectName = new Text((Composite)group, 2048);
        this.projectName.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMakeProjFromExistingPage.this.validateProjectName();
            }
        });
    }

    public void validateProjectName() {
        String name = this.projectName.getText();
        IProject project = this.root.getProject(name);
        if (project.exists()) {
            this.setErrorMessage(Messages.NewMakeProjFromExistingPage_4);
        } else {
            this.setErrorMessage(null);
        }
    }

    public void addSourceSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_5);
        this.location = new Text((Composite)group, 2048);
        this.location.setLayoutData((Object)new GridData(4, 4, true, true));
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMakeProjFromExistingPage.this.validateSource();
            }
        });
        this.validateSource();
        Button browse = new Button((Composite)group, 0);
        browse.setLayoutData((Object)new GridData(4, 4, false, true));
        browse.setText(Messages.NewMakeProjFromExistingPage_6);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewMakeProjFromExistingPage.this.location.getShell());
                dialog.setMessage(Messages.NewMakeProjFromExistingPage_7);
                String dir = dialog.open();
                if (dir != null) {
                    NewMakeProjFromExistingPage.this.location.setText(dir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    void validateSource() {
        File file = new File(this.location.getText());
        if (file.isDirectory()) {
            this.setErrorMessage(null);
            this.projectName.setText(file.getName());
        } else {
            this.setErrorMessage(Messages.NewMakeProjFromExistingPage_8);
        }
    }

    public void addLanguageSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_9);
        this.langc = new Button((Composite)group, 32);
        this.langc.setText("C");
        this.langc.setSelection(true);
        this.langcpp = new Button((Composite)group, 32);
        this.langcpp.setText("C++");
        this.langcpp.setSelection(true);
    }

    public void addToolchainSelector(Composite parent) {
        IToolChain[] toolChains;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_10);
        this.tcList = new List((Composite)group, 4);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tcList.add(Messages.NewMakeProjFromExistingPage_11);
        IToolChain[] iToolChainArray = toolChains = ManagedBuildManager.getRealToolChains();
        int n = toolChains.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain toolChain = iToolChainArray[n2];
            if (!toolChain.isAbstract() && !toolChain.isSystemObject()) {
                this.tcMap.put(toolChain.getUniqueRealName(), toolChain);
            }
            ++n2;
        }
        ArrayList<String> names = new ArrayList<String>(this.tcMap.keySet());
        Collections.sort(names);
        for (String name : names) {
            this.tcList.add(name);
        }
        this.tcList.setSelection(0);
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public String getLocation() {
        return this.location.getText();
    }

    public boolean isC() {
        return this.langc.getSelection();
    }

    public boolean isCPP() {
        return this.langcpp.getSelection();
    }

    public IToolChain getToolChain() {
        String[] selection = this.tcList.getSelection();
        return selection.length != 0 ? this.tcMap.get(selection[0]) : null;
    }
}

