/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.rename.Messages;
import org.eclipse.cdt.internal.ui.refactoring.rename.TextSearchWrapper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.IDE;

public class CRefactory {
    public static final int OPTION_ASK_SCOPE = 1;
    public static final int OPTION_IN_COMMENT = 2;
    public static final int OPTION_IN_STRING_LITERAL = 4;
    public static final int OPTION_IN_INCLUDE_DIRECTIVE = 8;
    public static final int OPTION_IN_MACRO_DEFINITION = 16;
    public static final int OPTION_IN_PREPROCESSOR_DIRECTIVE = 32;
    public static final int OPTION_IN_INACTIVE_CODE = 64;
    public static final int OPTION_IN_CODE = 128;
    public static final int OPTION_DO_VIRTUAL = 256;
    public static final int ARGUMENT_UNKNOWN = 0;
    public static final int ARGUMENT_LOCAL_VAR = 1;
    public static final int ARGUMENT_PARAMETER = 2;
    public static final int ARGUMENT_FILE_LOCAL_VAR = 3;
    public static final int ARGUMENT_GLOBAL_VAR = 4;
    public static final int ARGUMENT_FIELD = 5;
    public static final int ARGUMENT_FILE_LOCAL_FUNCTION = 6;
    public static final int ARGUMENT_GLOBAL_FUNCTION = 7;
    public static final int ARGUMENT_VIRTUAL_METHOD = 8;
    public static final int ARGUMENT_NON_VIRTUAL_METHOD = 9;
    public static final int ARGUMENT_TYPE = 10;
    public static final int ARGUMENT_MACRO = 11;
    public static final int ARGUMENT_INCLUDE_DIRECTIVE = 12;
    public static final int ARGUMENT_ENUMERATOR = 13;
    public static final int ARGUMENT_CLASS_TYPE = 14;
    public static final int ARGUMENT_NAMESPACE = 15;
    private static CRefactory sInstance = new CRefactory();
    private TextSearchWrapper fTextSearch;

    public static CRefactory getInstance() {
        return sInstance;
    }

    private CRefactory() {
    }

    public void rename(Shell shell, ICElement arg) {
        if (!IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (boolean)false)) {
            return;
        }
        CRefactoringArgument iarg = new CRefactoringArgument(arg);
        CRenameProcessor processor = new CRenameProcessor(this, iarg);
        try {
            processor.lockIndex();
            try {
                CRenameRefactoring r = new CRenameRefactoring(processor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)new CRenameRefactoringWizard(r));
                op.run(shell, Messages.CRefactory_title_rename);
            }
            finally {
                processor.unlockIndex();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void rename(Shell shell, IWorkingCopy wc, ITextSelection s) {
        IResource res = wc.getResource();
        if (!(res instanceof IFile)) {
            return;
        }
        if (!IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (boolean)false)) {
            return;
        }
        CRefactoringArgument iarg = new CRefactoringArgument((IFile)res, s.getOffset(), s.getLength());
        CRenameProcessor processor = new CRenameProcessor(this, iarg);
        try {
            processor.lockIndex();
            try {
                CRenameRefactoring r = new CRenameRefactoring(processor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)new CRenameRefactoringWizard(r));
                op.run(shell, Messages.CRefactory_title_rename);
            }
            finally {
                processor.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public TextSearchWrapper getTextSearch() {
        if (this.fTextSearch == null) {
            return new TextSearchWrapper();
        }
        return this.fTextSearch;
    }

    public String[] getCCppPatterns() {
        IContentType[] cts = Platform.getContentTypeManager().getAllContentTypes();
        HashSet<String> all = new HashSet<String>();
        IContentType[] iContentTypeArray = cts;
        int n = cts.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType type = iContentTypeArray[n2];
            boolean useit = false;
            while (!useit && type != null) {
                String id = type.getId();
                if (id.equals("org.eclipse.cdt.core.cHeader") || id.equals("org.eclipse.cdt.core.cSource") || id.equals("org.eclipse.cdt.core.cxxHeader") || id.equals("org.eclipse.cdt.core.cxxSource")) {
                    useit = true;
                    continue;
                }
                type = type.getBaseType();
            }
            if (useit) {
                String[] exts = type.getFileSpecs(8);
                all.addAll(Arrays.asList(exts));
            }
            ++n2;
        }
        String[] result = new String[all.size()];
        Iterator it = all.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = "*." + (String)it.next();
            ++i;
        }
        return result;
    }
}

