/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.adapters;

import java.util.Collection;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;

class TCFLaunchLabelProvider
implements IElementLabelProvider {
    TCFLaunchLabelProvider() {
    }

    public void update(ILabelUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            ILabelUpdate result = updates[i];
            TCFLaunch launch = (TCFLaunch)result.getElement();
            result.setImageDescriptor(ImageCache.getImageDescriptor("icons/tcf.gif"), 0);
            String status = "";
            if (launch.isConnecting()) {
                status = "Connecting";
            } else if (launch.isExited()) {
                status = "Exited";
                int code = launch.getExitCode();
                if (code > 0) {
                    status = String.valueOf(status) + ", exit code " + code;
                }
                if (code < 0) {
                    status = String.valueOf(status) + ", signal " + -code;
                    Collection sigs = launch.getSignalList();
                    if (sigs != null) {
                        for (Map m : sigs) {
                            String s;
                            Number num = (Number)m.get("Code");
                            if (num == null || num.intValue() != -code || (s = (String)m.get("Name")) == null) continue;
                            status = String.valueOf(status) + " (" + s + ")";
                            break;
                        }
                    }
                }
            } else if (launch.isDisconnected()) {
                status = "Disconnected";
            }
            Throwable error = launch.getError();
            if (error != null) {
                status = String.valueOf(status) + " - " + TCFModel.getErrorMessage(error, false);
                result.setForeground(new RGB(255, 0, 0), 0);
            }
            if (status.length() > 0) {
                status = " (" + status + ")";
            }
            String name = "?";
            ILaunchConfiguration cfg = launch.getLaunchConfiguration();
            if (cfg != null) {
                name = cfg.getName();
            }
            result.setLabel(String.valueOf(name) + status, 0);
            result.done();
            ++i;
        }
    }
}

