/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFRunnable;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StepCommand
implements IDebugCommandHandler {
    protected final TCFModel model;

    public StepCommand(TCFModel model) {
        this.model = model;
    }

    protected abstract boolean canExecute(IRunControl.RunControlContext var1);

    protected abstract void execute(IDebugCommandRequest var1, IRunControl.RunControlContext var2, boolean var3, Runnable var4);

    public final void canExecute(final IEnabledStateRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                boolean res = false;
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    node = elements[i] instanceof TCFNode ? (TCFNode)elements[i] : StepCommand.this.model.getRootNode();
                    while (node != null && !node.isDisposed()) {
                        IRunControl.RunControlContext ctx = null;
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            ctx = (IRunControl.RunControlContext)cache.getData();
                        }
                        if (ctx == null || !StepCommand.this.canExecute(ctx)) {
                            node = node.getParent();
                            continue;
                        }
                        TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)node).getState();
                        if (!state_cache.validate((Runnable)this)) {
                            return;
                        }
                        TCFContextState state_data = (TCFContextState)state_cache.getData();
                        if (state_data == null || !state_data.is_suspended) break;
                        res = true;
                        break;
                    }
                    ++i;
                }
                monitor.setEnabled(res);
                monitor.setStatus(Status.OK_STATUS);
                this.done();
            }
        };
    }

    public final boolean execute(final IDebugCommandRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                HashSet<IRunControl.RunControlContext> set = new HashSet<IRunControl.RunControlContext>();
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    node = elements[i] instanceof TCFNode ? (TCFNode)elements[i] : StepCommand.this.model.getRootNode();
                    while (node != null && !node.isDisposed()) {
                        IRunControl.RunControlContext ctx = null;
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            ctx = (IRunControl.RunControlContext)cache.getData();
                        }
                        if (ctx == null || !StepCommand.this.canExecute(ctx)) {
                            node = node.getParent();
                            continue;
                        }
                        set.add(ctx);
                        break;
                    }
                    ++i;
                }
                StepCommand.this.execute(monitor, this, set);
            }
        };
        return true;
    }

    private void execute(final IDebugCommandRequest monitor, final TCFRunnable request, final Set<IRunControl.RunControlContext> set) {
        int i = 0;
        final String[] ids = new String[set.size()];
        for (IRunControl.RunControlContext ctx : set) {
            ids[i++] = ctx.getID();
        }
        this.model.getDisplay().asyncExec(new Runnable(){

            public void run() {
                boolean src = false;
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    Annotation a = Activator.getAnnotationManager().findAnnotation(StepCommand.this.model, id);
                    if (a != null) {
                        src = true;
                    }
                    ++n2;
                }
                final boolean src_step = src;
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        final HashSet<1> wait_list = new HashSet<1>();
                        for (IRunControl.RunControlContext ctx : set) {
                            Runnable done = new Runnable(){

                                public void run() {
                                    wait_list.remove(this);
                                    if (wait_list.isEmpty()) {
                                        request.done();
                                    }
                                }
                            };
                            wait_list.add(done);
                            StepCommand.this.execute(monitor, ctx, src_step, done);
                        }
                    }
                });
            }
        });
    }
}

