/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFRunnable;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;

public class SuspendCommand
implements ISuspendHandler {
    private final TCFModel model;

    public SuspendCommand(TCFModel model) {
        this.model = model;
    }

    public void canExecute(final IEnabledStateRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                boolean res = false;
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    node = elements[i] instanceof TCFNode ? (TCFNode)elements[i] : SuspendCommand.this.model.getRootNode();
                    while (node != null && !node.isDisposed()) {
                        IRunControl.RunControlContext ctx = null;
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            ctx = (IRunControl.RunControlContext)cache.getData();
                        }
                        if (ctx == null) {
                            node = node.getParent();
                            continue;
                        }
                        if (ctx.isContainer()) {
                            if (!ctx.canSuspend()) break;
                            res = true;
                            break;
                        }
                        TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)node).getState();
                        if (!state_cache.validate((Runnable)this)) {
                            return;
                        }
                        TCFContextState state_data = (TCFContextState)state_cache.getData();
                        if (state_data == null || state_data.is_suspended || !ctx.canSuspend()) break;
                        res = true;
                        break;
                    }
                    ++i;
                }
                monitor.setEnabled(res);
                monitor.setStatus(Status.OK_STATUS);
                this.done();
            }
        };
    }

    public boolean execute(final IDebugCommandRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                HashSet<IRunControl.RunControlContext> set = new HashSet<IRunControl.RunControlContext>();
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    node = elements[i] instanceof TCFNode ? (TCFNode)elements[i] : SuspendCommand.this.model.getRootNode();
                    while (node != null && !node.isDisposed()) {
                        IRunControl.RunControlContext ctx = null;
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            ctx = (IRunControl.RunControlContext)cache.getData();
                        }
                        if (ctx == null) {
                            node = node.getParent();
                            continue;
                        }
                        set.add(ctx);
                        break;
                    }
                    ++i;
                }
                final HashSet<IToken> cmds = new HashSet<IToken>();
                for (IRunControl.RunControlContext ctx : set) {
                    cmds.add(ctx.suspend(new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (!$assertionsDisabled && !cmds.contains(token)) {
                                throw new AssertionError();
                            }
                            cmds.remove(token);
                            if (error != null) {
                                monitor.setStatus((IStatus)new Status(4, "org.eclipse.tm.tcf.debug.ui", 0, "Cannot suspend", (Throwable)error));
                            }
                            if (cmds.isEmpty()) {
                                this.done();
                            }
                        }
                    }));
                }
            }
        };
        return true;
    }
}

