/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.launch.ITCFLaunchContext;
import org.eclipse.tm.internal.tcf.debug.ui.launch.TCFLaunchContext;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TCFMainTab
extends AbstractLaunchConfigurationTab {
    private Text project_text;
    private Text local_program_text;
    private Text remote_program_text;
    private Text working_dir_text;
    private Button default_dir_button;
    private Button terminal_button;
    private Exception init_error;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp);
        this.createApplicationGroup(comp);
        this.createWorkingDirGroup(comp);
        this.createVerticalSpacer(comp, 1);
        this.createTerminalOption(comp, 1);
    }

    private void createProjectGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Project");
        Label label = new Label((Composite)group, 0);
        label.setText("Project Name:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.project_text = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.project_text.setLayoutData((Object)gd);
        this.project_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button project_button = this.createPushButton((Composite)group, "Browse...", null);
        project_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleProjectButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createApplicationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Application");
        this.createLocalExeFileGroup((Composite)group);
        this.createRemoteExeFileGroup((Composite)group);
    }

    private void createLocalExeFileGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label program_label = new Label(comp, 0);
        program_label.setText("Local File Path:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        program_label.setLayoutData((Object)gd);
        this.local_program_text = new Text(comp, 2052);
        this.local_program_text.setLayoutData((Object)new GridData(768));
        this.local_program_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button search_button = this.createPushButton(comp, "Search...", null);
        search_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleSearchButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse_button = this.createPushButton(comp, "Browse...", null);
        browse_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleBinaryBrowseButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRemoteExeFileGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label program_label = new Label(comp, 0);
        program_label.setText("Remote File Path:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        program_label.setLayoutData((Object)gd);
        this.remote_program_text = new Text(comp, 2052);
        this.remote_program_text.setLayoutData((Object)new GridData(768));
        this.remote_program_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createWorkingDirGroup(Composite comp) {
        Group group = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Working directory");
        this.working_dir_text = new Text((Composite)group, 2052);
        this.working_dir_text.setLayoutData((Object)new GridData(768));
        this.default_dir_button = new Button((Composite)group, 32);
        this.default_dir_button.setText("Use default");
        this.default_dir_button.setLayoutData((Object)new GridData(4, 1, true, false));
        this.default_dir_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.working_dir_text.setEnabled(!this.default_dir_button.getSelection());
    }

    private void createTerminalOption(Composite parent, int colSpan) {
        Composite terminal_comp = new Composite(parent, 0);
        GridLayout terminal_layout = new GridLayout();
        terminal_layout.numColumns = 1;
        terminal_layout.marginHeight = 0;
        terminal_layout.marginWidth = 0;
        terminal_comp.setLayout((Layout)terminal_layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        terminal_comp.setLayoutData((Object)gd);
        this.terminal_button = this.createCheckButton(terminal_comp, "Use Terminal");
        this.terminal_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.terminal_button.setEnabled(true);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            this.project_text.setText(config.getAttribute("org.eclipse.tm.tcf.debug.ProjectName", ""));
            this.local_program_text.setText(config.getAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", ""));
            this.remote_program_text.setText(config.getAttribute("org.eclipse.tm.tcf.debug.ProgramFile", ""));
            this.working_dir_text.setText(config.getAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory", ""));
            this.default_dir_button.setSelection(!config.hasAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory"));
            this.terminal_button.setSelection(config.getAttribute("org.eclipse.tm.tcf.debug.UseTerminal", true));
            this.working_dir_text.setEnabled(!this.default_dir_button.getSelection());
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    private IProject getProject() {
        String name = this.project_text.getText().trim();
        if (name.length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.tm.tcf.debug.ProjectName", this.project_text.getText());
        config.setAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", this.local_program_text.getText());
        config.setAttribute("org.eclipse.tm.tcf.debug.ProgramFile", this.remote_program_text.getText());
        if (this.default_dir_button.getSelection()) {
            config.removeAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory");
        } else {
            config.setAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory", this.working_dir_text.getText());
        }
        config.setAttribute("org.eclipse.tm.tcf.debug.UseTerminal", this.terminal_button.getSelection());
    }

    private void handleSearchButtonSelected() {
        IProject project = this.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Project required", (String)"Enter project before searching for program");
            return;
        }
        ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(project);
        if (launch_context == null) {
            return;
        }
        String path = launch_context.chooseBinary(this.getShell(), project);
        if (path != null) {
            this.local_program_text.setText(path);
        }
    }

    private void handleBinaryBrowseButtonSelected() {
        FileDialog file_dialog = new FileDialog(this.getShell(), 0);
        file_dialog.setFileName(this.local_program_text.getText());
        String path = file_dialog.open();
        if (path != null) {
            this.local_program_text.setText(path);
        }
    }

    private void handleProjectButtonSelected() {
        try {
            IProject project = this.chooseProject();
            if (project == null) {
                return;
            }
            this.project_text.setText(project.getName());
        }
        catch (Exception e) {
            Activator.log("Cannot get project description", e);
        }
    }

    private IProject chooseProject() {
        try {
            Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            LabelProvider label_provider = new LabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return "";
                    }
                    return ((IProject)element).getName();
                }
            };
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)label_provider);
            dialog.setTitle("Project Selection");
            dialog.setMessage("Choose project to constrain search for program");
            dialog.setElements(projects);
            IProject cProject = this.getProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (IProject)dialog.getFirstResult();
            }
        }
        catch (Exception e) {
            Activator.log("Cannot show project list dialog", e);
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration config) {
        String local_name;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        String project_name = this.project_text.getText().trim();
        if (project_name.length() != 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(project_name);
            if (!project.exists()) {
                this.setErrorMessage("Project does not exist");
                return false;
            }
            if (!project.isOpen()) {
                this.setErrorMessage("Project must be opened");
                return false;
            }
        }
        if ((local_name = this.local_program_text.getText().trim()).equals(".") || local_name.equals("..")) {
            this.setErrorMessage("Invalid local program name");
            return false;
        }
        String remote_name = this.remote_program_text.getText().trim();
        if (remote_name.equals(".") || remote_name.equals("..")) {
            this.setErrorMessage("Invalid remote program name");
            return false;
        }
        if (local_name.length() > 0) {
            IProject project = this.getProject();
            Path program_path = new Path(local_name);
            if (!program_path.isAbsolute()) {
                if (project == null) {
                    File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                    File file = new File(ws, local_name);
                    if (!file.exists()) {
                        this.setErrorMessage("File not found: " + file);
                        return false;
                    }
                    if (file.isDirectory()) {
                        this.setErrorMessage("Program path is directory name: " + file);
                        return false;
                    }
                    program_path = new Path(file.getAbsolutePath());
                } else {
                    if (!project.getFile(local_name).exists()) {
                        this.setErrorMessage("Program does not exist");
                        return false;
                    }
                    program_path = project.getFile(local_name).getLocation();
                }
            } else {
                File file = program_path.toFile();
                if (!file.exists()) {
                    this.setErrorMessage("Program file does not exist");
                    return false;
                }
                if (file.isDirectory()) {
                    this.setErrorMessage("Program path is directory name");
                    return false;
                }
            }
            if (project != null) {
                try {
                    ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(project);
                    if (launch_context != null && !launch_context.isBinary(project, (IPath)program_path)) {
                        this.setErrorMessage("Program is not a recongnized executable");
                        return false;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    this.setErrorMessage(e.getLocalizedMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.tm.tcf.debug.ProjectName", "");
        config.setAttribute("org.eclipse.tm.tcf.debug.UseTerminal", true);
        config.setAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory", null);
        ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(null);
        if (launch_context != null) {
            launch_context.setDefaults(this.getLaunchConfigurationDialog(), config);
        }
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/tcf.gif");
    }
}

