/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch.setup;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.AbstractRemoteShell;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.TimeOutInputStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class SSHClient
extends AbstractRemoteShell {
    private final Session session;
    private final Channel channel;

    SSHClient(Shell parent, String host, String user, String password) throws Exception {
        BundleContext ctx = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = ctx.getServiceReference(IJSchService.class.getName());
        IJSchService s = (IJSchService)ctx.getService(ref);
        this.session = s.createSession(host, 22, user);
        this.session.setPassword(password);
        new UserInfoPrompter(this.session);
        this.session.connect(30000);
        this.channel = this.session.openChannel("shell");
        Pipe inp = new Pipe();
        Pipe out = new Pipe();
        this.channel.setInputStream((InputStream)inp.inp);
        this.channel.setOutputStream((OutputStream)out.out);
        this.out = new PrintWriter(inp.out, true);
        this.inp = new BufferedReader(new InputStreamReader((InputStream)new TimeOutInputStream(out.inp, 512, 60000L), "UTF-8"));
        this.channel.connect(30000);
        this.write("export PS1=\"***SHELL***>\"\n");
        this.expect("***SHELL***>\"\n");
        this.waitPrompt();
    }

    public void close() throws IOException {
        this.channel.disconnect();
        this.session.disconnect();
    }

    private static class Pipe {
        final PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream inp = new PipedInputStream();

        Pipe() throws IOException {
            this.inp.connect(this.out);
        }
    }
}

