/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.util.Random;
import org.eclipse.tm.internal.tcf.debug.tests.ITCFTest;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.util.TCFFileInputStream;
import org.eclipse.tm.tcf.util.TCFFileOutputStream;

class TestFileSystem
implements ITCFTest,
IFileSystem.DoneStat,
IFileSystem.DoneOpen,
IFileSystem.DoneClose,
IFileSystem.DoneWrite,
IFileSystem.DoneRead,
IFileSystem.DoneRename,
IFileSystem.DoneRealPath,
IFileSystem.DoneRemove,
IFileSystem.DoneRoots,
IFileSystem.DoneReadDir {
    private final TCFTestSuite test_suite;
    private final int channel_id;
    private static final int STATE_PRE = 0;
    private static final int STATE_WRITE = 1;
    private static final int STATE_READ = 2;
    private static final int STATE_OUT = 3;
    private static final int STATE_INP = 4;
    private static final int STATE_EXIT = 5;
    private final IFileSystem files;
    private final byte[] data = new byte[4096];
    private String root;
    private String tmp_path;
    private String file_name;
    private IFileSystem.IFileHandle handle;
    private int state = 0;

    TestFileSystem(TCFTestSuite test_suite, IChannel channel, int channel_id) {
        this.test_suite = test_suite;
        this.channel_id = channel_id;
        this.files = (IFileSystem)channel.getRemoteService(IFileSystem.class);
    }

    public void start() {
        if (this.files == null) {
            this.test_suite.done(this, null);
        } else {
            this.files.roots((IFileSystem.DoneRoots)this);
        }
    }

    public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
        assert (this.state == 0);
        if (error != null) {
            this.exit((Throwable)error);
        } else if (entries == null || entries.length == 0) {
            this.exit(new Exception("Invalid FileSysrem.roots responce: empty roots array"));
        } else {
            IFileSystem.DirEntry[] dirEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IFileSystem.DirEntry d = dirEntryArray[n2];
                if (!d.filename.startsWith("A:") && !d.filename.startsWith("B:")) {
                    this.root = d.filename;
                    break;
                }
                ++n2;
            }
            if (this.root == null) {
                this.exit(new Exception("Invalid FileSystem.roots responce: no suitable root"));
            } else {
                this.files.opendir(this.root, (IFileSystem.DoneOpen)this);
            }
        }
    }

    public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
        assert (this.state == 0);
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            if (entries != null && this.tmp_path == null) {
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry e = dirEntryArray[n2];
                    if (e.filename.equals("tmp") || e.filename.equalsIgnoreCase("temp")) {
                        this.tmp_path = String.valueOf(this.root) + "/" + e.filename;
                        break;
                    }
                    ++n2;
                }
            }
            if (eof) {
                if (this.tmp_path == null) {
                    this.exit(new Exception("File system test filed: cannot find temporary directory"));
                    return;
                }
                this.files.close(this.handle, (IFileSystem.DoneClose)this);
            } else {
                this.files.readdir(this.handle, (IFileSystem.DoneReadDir)this);
            }
        }
    }

    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 2) {
            if (attrs.size != (long)this.data.length) {
                this.exit(new Exception("Invalid FileSysrem.fstat responce: wrong file size"));
            } else {
                this.files.close(this.handle, (IFileSystem.DoneClose)this);
            }
        } else {
            this.file_name = String.valueOf(this.tmp_path) + "/tcf-test-" + this.channel_id + ".tmp";
            this.files.open(this.file_name, 26, null, (IFileSystem.DoneOpen)this);
        }
    }

    public void doneOpen(IToken token, IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.handle = handle;
            if (this.state == 2) {
                this.files.read(handle, 0L, this.data.length + 1, (IFileSystem.DoneRead)this);
            } else if (this.state == 1) {
                new Random().nextBytes(this.data);
                this.files.write(handle, 0L, this.data, 0, this.data.length, (IFileSystem.DoneWrite)this);
            } else if (this.state == 4) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            int pos = 0;
                            int len = TestFileSystem.this.data.length * 16;
                            byte[] buf = new byte[333];
                            int buf_pos = 0;
                            int buf_len = 0;
                            Random rnd = new Random();
                            boolean mark = true;
                            boolean reset = true;
                            int mark_pos = rnd.nextInt(len - 1);
                            int reset_pos = mark_pos + rnd.nextInt(len - mark_pos);
                            if (!$assertionsDisabled && reset_pos < mark_pos) {
                                throw new AssertionError();
                            }
                            TCFFileInputStream inp = new TCFFileInputStream(handle, 133);
                            while (true) {
                                if (mark && pos == mark_pos) {
                                    inp.mark(len);
                                    mark = false;
                                }
                                if (reset && pos == reset_pos) {
                                    inp.reset();
                                    reset = false;
                                    pos = mark_pos;
                                    buf_len = 0;
                                    buf_pos = 0;
                                }
                                int ch = 0;
                                if (buf_pos >= buf_len && (pos >= mark_pos || pos + buf.length <= mark_pos)) {
                                    buf_pos = 0;
                                    buf_len = inp.read(buf, 0, buf.length);
                                    if (buf_len < 0) break;
                                }
                                if (buf_pos < buf_len) {
                                    ch = buf[buf_pos++] & 0xFF;
                                } else {
                                    ch = inp.read();
                                    if (ch < 0) break;
                                }
                                int dt = TestFileSystem.this.data[pos % TestFileSystem.this.data.length] & 0xFF;
                                if (ch != dt) {
                                    this.error(new Exception("Invalid TCFFileInputStream.read responce: wrong data at offset " + pos + ", expected " + dt + ", actual " + ch));
                                }
                                ++pos;
                            }
                            if (pos != TestFileSystem.this.data.length * 16) {
                                this.error(new Exception("Invalid TCFFileInputStream.read responce: wrong file length: expected " + TestFileSystem.this.data.length + ", actual " + pos));
                            }
                            inp.close();
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    TestFileSystem.this.state = 5;
                                    TestFileSystem.this.files.rename(TestFileSystem.this.file_name, String.valueOf(TestFileSystem.this.file_name) + ".rnm", (IFileSystem.DoneRename)TestFileSystem.this);
                                }
                            });
                        }
                        catch (Throwable x) {
                            this.error(x);
                        }
                    }

                    private void error(final Throwable x) {
                        Protocol.invokeLater((Runnable)new Runnable(){

                            public void run() {
                                TestFileSystem.this.exit(x);
                            }
                        });
                    }
                };
                thread.setName("TCF FileSystem Test");
                thread.start();
            } else if (this.state == 3) {
                new Random().nextBytes(this.data);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            int pos = 0;
                            int len = TestFileSystem.this.data.length * 16;
                            Random rnd = new Random();
                            TCFFileOutputStream out = new TCFFileOutputStream(handle, 121);
                            while (pos < len) {
                                int m = pos % TestFileSystem.this.data.length;
                                int n = rnd.nextInt(1021);
                                if (n > TestFileSystem.this.data.length - m) {
                                    n = TestFileSystem.this.data.length - m;
                                }
                                out.write(TestFileSystem.this.data, m, n);
                                if ((pos += n) == len) break;
                                out.write(TestFileSystem.this.data[pos % TestFileSystem.this.data.length] & 0xFF);
                                ++pos;
                            }
                            out.close();
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    TestFileSystem.this.state = 4;
                                    TestFileSystem.this.files.open(TestFileSystem.this.file_name, 1, null, (IFileSystem.DoneOpen)TestFileSystem.this);
                                }
                            });
                        }
                        catch (Throwable x) {
                            this.error(x);
                        }
                    }

                    private void error(final Throwable x) {
                        Protocol.invokeLater((Runnable)new Runnable(){

                            public void run() {
                                TestFileSystem.this.exit(x);
                            }
                        });
                    }
                };
                thread.setName("TCF FileSystem Test");
                thread.start();
            } else {
                assert (this.state == 0);
                this.files.readdir(handle, (IFileSystem.DoneReadDir)this);
            }
        }
    }

    public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.files.close(this.handle, (IFileSystem.DoneClose)this);
        }
    }

    public void doneRead(IToken token, IFileSystem.FileSystemException error, byte[] data, boolean eof) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (!eof) {
            this.exit(new Exception("Invalid FileSysrem.read responce: EOF expected"));
        } else if (data.length != this.data.length) {
            this.exit(new Exception("Invalid FileSysrem.read responce: wrong data array size"));
        } else {
            int i = 0;
            while (i < data.length) {
                if (data[i] != this.data[i]) {
                    this.exit(new Exception("Invalid FileSysrem.read responce: wrong data at offset " + i + ", expected " + this.data[i] + ", actual " + data[i]));
                    return;
                }
                ++i;
            }
            this.files.fstat(this.handle, (IFileSystem.DoneStat)this);
        }
    }

    public void doneClose(IToken token, IFileSystem.FileSystemException error) {
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.handle = null;
            if (this.state == 0) {
                this.files.realpath(this.tmp_path, (IFileSystem.DoneRealPath)this);
            } else if (this.state == 1) {
                this.state = 2;
                this.files.open(this.file_name, 1, null, (IFileSystem.DoneOpen)this);
            } else if (this.state == 2) {
                this.state = 3;
                this.files.open(this.file_name, 2, null, (IFileSystem.DoneOpen)this);
            } else assert (false);
        }
    }

    public void doneRename(IToken token, IFileSystem.FileSystemException error) {
        assert (this.state == 5);
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.files.realpath(String.valueOf(this.file_name) + ".rnm", (IFileSystem.DoneRealPath)this);
        }
    }

    public void doneRealPath(IToken token, IFileSystem.FileSystemException error, String path) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 0) {
            this.state = 1;
            this.tmp_path = path;
            this.files.stat(this.tmp_path, (IFileSystem.DoneStat)this);
        } else if (!path.equals(String.valueOf(this.file_name) + ".rnm")) {
            this.exit(new Exception("Invalid FileSysrem.realpath responce: " + path));
        } else {
            this.files.remove(String.valueOf(this.file_name) + ".rnm", (IFileSystem.DoneRemove)this);
        }
    }

    public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
        assert (this.state == 5);
        this.exit((Throwable)error);
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.test_suite.done(this, x);
    }
}

