/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.regex.Pattern;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class NamingConventionFunctionChecker
extends AbstractIndexAstChecker
implements ICheckerWithPreferences {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.NamingConventionFunctionChecker";
    public static final String PARAM_KEY = "pattern";

    public void processAst(IASTTranslationUnit ast) {
        final IProblem pt = this.getProblemById(ER_ID, (IResource)this.getFile());
        try {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitDeclarations = true;
                }

                public int visit(IASTDeclaration element) {
                    IASTName astName;
                    String name;
                    String parameter;
                    Pattern pattern;
                    if (element instanceof IASTFunctionDefinition && !(pattern = Pattern.compile(parameter = (String)NamingConventionFunctionChecker.this.getPreference(pt, NamingConventionFunctionChecker.PARAM_KEY))).matcher(name = (astName = ((IASTFunctionDefinition)element).getDeclarator().getName()).toString()).find()) {
                        NamingConventionFunctionChecker.this.reportProblem(NamingConventionFunctionChecker.ER_ID, (IASTNode)astName, new Object[]{name, parameter});
                    }
                    return 1;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_KEY, CheckersMessages.NamingConventionFunctionChecker_LabelNamePattern, "^[a-z]");
    }

    public boolean runInEditor() {
        return true;
    }
}

