/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.core.CodanPreferencesLoader;
import org.eclipse.cdt.codan.internal.core.model.CodanProblem;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemCategory;
import org.eclipse.cdt.codan.internal.core.model.ProblemProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckersRegistry
implements Iterable<IChecker>,
ICheckersRegistry {
    private static final String NAME_ATTR = "name";
    private static final String ID_ATTR = "id";
    private static final String EXTENSION_POINT_NAME = "checkers";
    private static final String CHECKER_ELEMENT = "checker";
    private static final String PROBLEM_ELEMENT = "problem";
    private static final String CATEGORY_ELEMENT = "category";
    private static final Object DEFAULT = "DEFAULT";
    private Collection<IChecker> checkers = new ArrayList<IChecker>();
    private static CheckersRegistry instance;
    private HashMap<Object, IProblemProfile> profiles = new HashMap();
    private HashMap<IChecker, Collection<IProblem>> problemList = new HashMap();

    private CheckersRegistry() {
        instance = this;
        this.profiles.put(DEFAULT, new ProblemProfile());
        this.readCheckersRegistry();
    }

    private void readCheckersRegistry() {
        IConfigurationElement configurationElement;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.core", EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processCategories(configurationElement);
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processProblem(configurationElement);
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processChecker(configurationElement);
            ++i;
        }
        for (IChecker c : this.problemList.keySet()) {
            if (!(c instanceof ICheckerWithPreferences)) continue;
            Collection<IProblem> list = this.problemList.get(c);
            for (IProblem p : list) {
                if (!(p instanceof IProblemWorkingCopy)) continue;
                try {
                    ((ICheckerWithPreferences)((Object)c)).initPreferences((IProblemWorkingCopy)p);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    CodanCorePlugin.log(t);
                }
            }
        }
    }

    private void processCategories(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals(CATEGORY_ELEMENT)) {
            String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
            if (id == null) {
                return;
            }
            String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR);
            if (name == null) {
                return;
            }
            CodanProblemCategory cat = new CodanProblemCategory(id, name);
            String category = CheckersRegistry.getAtt(configurationElement, "parentCategory", false);
            this.addCategory(cat, category);
        }
    }

    private void processChecker(IConfigurationElement configurationElement) {
        block11: {
            try {
                IProblem p;
                IConfigurationElement ref;
                int n;
                int n2;
                IConfigurationElement[] iConfigurationElementArray;
                if (!configurationElement.getName().equals(CHECKER_ELEMENT)) break block11;
                String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
                if (id == null) {
                    return;
                }
                String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR, false);
                if (name == null) {
                    name = id;
                }
                IChecker checkerObj = null;
                try {
                    Object checker = configurationElement.createExecutableExtension("class");
                    checkerObj = (IChecker)checker;
                    this.addChecker(checkerObj);
                }
                catch (CoreException e) {
                    CodanCorePlugin.log(e);
                    return;
                }
                IConfigurationElement[] children1 = configurationElement.getChildren("problemRef");
                boolean hasRef = false;
                IConfigurationElement[] children2 = configurationElement.getChildren(PROBLEM_ELEMENT);
                if (children2 != null) {
                    iConfigurationElementArray = children2;
                    n2 = children2.length;
                    n = 0;
                    while (n < n2) {
                        ref = iConfigurationElementArray[n];
                        p = this.processProblem(ref);
                        this.addRefProblem(checkerObj, p);
                        hasRef = true;
                        ++n;
                    }
                }
                if (children1 != null) {
                    iConfigurationElementArray = children1;
                    n2 = children1.length;
                    n = 0;
                    while (n < n2) {
                        ref = iConfigurationElementArray[n];
                        hasRef = true;
                        p = this.getDefaultProfile().findProblem(ref.getAttribute("refId"));
                        this.addRefProblem(checkerObj, p);
                        ++n;
                    }
                }
                if (!hasRef) {
                    CodanProblem p2 = new CodanProblem(id, name);
                    this.addProblem(p2, null);
                    this.addRefProblem(checkerObj, p2);
                }
            }
            catch (Throwable e) {
                CodanCorePlugin.log(e);
            }
        }
    }

    private CodanProblem processProblem(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals(PROBLEM_ELEMENT)) {
            CodanSeverity cSev;
            String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
            if (id == null) {
                return null;
            }
            String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR);
            if (name == null) {
                name = id;
            }
            CodanProblem p = new CodanProblem(id, name);
            String category = CheckersRegistry.getAtt(configurationElement, CATEGORY_ELEMENT, false);
            if (category == null) {
                category = "org.eclipse.cdt.codan.core.categories.ProgrammingProblems";
            }
            String enab = CheckersRegistry.getAtt(configurationElement, "defaultEnabled", false);
            String sev = CheckersRegistry.getAtt(configurationElement, "defaultSeverity", false);
            String patt = CheckersRegistry.getAtt(configurationElement, "messagePattern", false);
            String desc = CheckersRegistry.getAtt(configurationElement, "description", false);
            String markerType = CheckersRegistry.getAtt(configurationElement, "markerType", false);
            if (enab != null) {
                p.setEnabled(Boolean.valueOf(enab));
            }
            if (sev != null && (cSev = CodanSeverity.valueOf(sev)) != null) {
                p.setSeverity(cSev);
            }
            if (patt != null) {
                p.setMessagePattern(patt);
            }
            if (markerType != null) {
                p.setMarkerType(markerType);
            }
            p.setDescription(desc);
            this.addProblem(p, category);
            return p;
        }
        return null;
    }

    private static String getAtt(IConfigurationElement configurationElement, String name) {
        return CheckersRegistry.getAtt(configurationElement, name, true);
    }

    private static String getAtt(IConfigurationElement configurationElement, String name, boolean req) {
        String elementValue = configurationElement.getAttribute(name);
        if (elementValue == null && req) {
            CodanCorePlugin.log("Extension " + configurationElement.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: " + configurationElement.getName() + "." + name);
        }
        return elementValue;
    }

    @Override
    public Iterator<IChecker> iterator() {
        return this.checkers.iterator();
    }

    public static CheckersRegistry getInstance() {
        if (instance == null) {
            return new CheckersRegistry();
        }
        return instance;
    }

    @Override
    public void addChecker(IChecker checker) {
        this.checkers.add(checker);
    }

    @Override
    public void addProblem(IProblem p, String category) {
        IProblemCategory cat = this.getDefaultProfile().findCategory(category);
        if (cat == null) {
            cat = this.getDefaultProfile().getRoot();
        }
        ((ProblemProfile)this.getDefaultProfile()).addProblem(p, cat);
    }

    @Override
    public void addCategory(IProblemCategory p, String category) {
        IProblemCategory cat = this.getDefaultProfile().findCategory(category);
        if (cat == null) {
            cat = this.getDefaultProfile().getRoot();
        }
        ((ProblemProfile)this.getDefaultProfile()).addCategory(p, cat);
    }

    @Override
    public void addRefProblem(IChecker c, IProblem p) {
        Collection<IProblem> plist = this.problemList.get(c);
        if (plist == null) {
            plist = new ArrayList<IProblem>();
            this.problemList.put(c, plist);
        }
        plist.add(p);
    }

    @Override
    public Collection<IProblem> getRefProblems(IChecker checker) {
        return this.problemList.get(checker);
    }

    @Override
    public IProblemProfile getDefaultProfile() {
        return this.profiles.get(DEFAULT);
    }

    @Override
    public IProblemProfile getWorkspaceProfile() {
        IProblemProfile wp = this.profiles.get(ResourcesPlugin.getWorkspace());
        if (wp == null) {
            try {
                wp = (IProblemProfile)this.getDefaultProfile().clone();
                CodanPreferencesLoader loader = new CodanPreferencesLoader(wp);
                loader.load(CodanPreferencesLoader.getWorkspaceNode());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                wp = this.getDefaultProfile();
            }
            this.profiles.put(ResourcesPlugin.getWorkspace(), wp);
        }
        return wp;
    }

    @Override
    public void updateProfile(IResource element, IProblemProfile profile) {
        IProblemProfile defaultProfile = this.getDefaultProfile();
        this.profiles.clear();
        this.profiles.put(DEFAULT, defaultProfile);
        if (profile != null && element != null) {
            this.profiles.put(element, profile);
        }
    }

    @Override
    public IProblemProfile getResourceProfile(IResource element) {
        IProblemProfile prof = this.profiles.get(element);
        if (prof == null) {
            if (element instanceof IProject) {
                try {
                    prof = (IProblemProfile)this.getWorkspaceProfile().clone();
                    CodanPreferencesLoader loader = new CodanPreferencesLoader(prof);
                    Preferences projectNode = CodanPreferencesLoader.getProjectNode((IProject)element);
                    boolean useWorkspace = projectNode.getBoolean("useParentScope", false);
                    if (!useWorkspace) {
                        loader.load(projectNode);
                    }
                    this.profiles.put(element, prof);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                prof = element.getParent() != null ? this.getResourceProfile((IResource)element.getParent()) : this.getResourceProfile((IResource)element.getProject());
            }
        }
        return prof;
    }

    @Override
    public IProblemProfile getResourceProfileWorkingCopy(IResource element) {
        try {
            IProblemProfile prof = (IProblemProfile)this.getResourceProfile(element).clone();
            return prof;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isCheckerEnabled(IChecker checker, IResource resource) {
        IProblemProfile resourceProfile = this.getResourceProfile(resource);
        Collection<IProblem> refProblems = this.getRefProblems(checker);
        for (IProblem p : refProblems) {
            IProblem problem = resourceProfile.findProblem(p.getId());
            if (problem == null) {
                throw new IllegalArgumentException("Id is not registered");
            }
            if (!problem.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public int getCheckersSize() {
        return this.checkers.size();
    }
}

