/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.widgets;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.FileScopeProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.preferences.FileScopePreferencePage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FileScopeComposite
extends Composite {
    private FileScopePreferencePage page;
    private IProblem problem;
    private PreferenceStore prefStore;
    private FileScopeProblemPreference scope;

    public FileScopeComposite(Composite parent, IProblem problem, IResource resource) {
        super(parent, 0);
        if (problem == null) {
            throw new NullPointerException();
        }
        this.setLayout((Layout)new GridLayout(2, false));
        this.problem = problem;
        this.prefStore = new PreferenceStore();
        IProblemPreference info = problem.getPreference();
        FileScopeProblemPreference scopeIn = null;
        if (info == null || !(info instanceof MapProblemPreference) || (scopeIn = (FileScopeProblemPreference)((MapProblemPreference)info).getChildDescriptor("fileScope")) == null) {
            Label label = new Label((Composite)this, 0);
            label.setText(CodanUIMessages.ParametersComposite_None);
            return;
        }
        this.scope = (FileScopeProblemPreference)scopeIn.clone();
        this.scope.setResource(resource);
        this.initPrefStore();
        this.page = new FileScopePreferencePage(this.scope);
        this.page.setPreferenceStore((IPreferenceStore)this.prefStore);
        this.page.noDefaultAndApplyButton();
        this.page.createControl(parent);
        this.page.getControl().setLayoutData((Object)new GridData(1808));
    }

    public void save(IProblemWorkingCopy problem) {
        if (this.page != null) {
            this.page.performOk();
        }
        this.savePrefStore();
    }

    private void savePrefStore() {
        if (this.scope == null) {
            return;
        }
        String key = this.scope.getQualifiedKey();
        ((MapProblemPreference)this.problem.getPreference()).setChildValue("fileScope", (Object)this.scope);
        this.prefStore.setValue(key, this.scope.exportValue());
    }

    private void initPrefStore() {
        if (this.scope == null) {
            return;
        }
        String key = this.scope.getQualifiedKey();
        this.prefStore.setValue(key, this.scope.exportValue());
    }

    public IProblem getProblem() {
        return this.problem;
    }
}

