/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;

public class AbstractLRHangingTest
extends TestCase {
    public static long THREAD_TIMEOUT_LIMIT = 60000L;
    public static String CONTENT_ASIST_CURSOR = " /*<ctrl-space>*/ ";
    private String errMsg = "";

    public AbstractLRHangingTest() {
    }

    public AbstractLRHangingTest(String name) {
        super(name);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }

    protected void runThreadByLimitedTime(long limitTime, Thread testThread) throws Exception {
        testThread.start();
        testThread.join(limitTime);
        if (testThread.isAlive()) {
            testThread.interrupt();
            AbstractLRHangingTest.fail((String)("timeout by " + limitTime / 1000L + " seconds"));
        }
    }

    public void resetErrMsg() {
        this.errMsg = "";
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    protected void runTestCase(final String code, final ILanguage language) throws Exception {
        Thread testThread = new Thread(){

            public void run() {
                String errMsg = "";
                AbstractLRHangingTest.this.resetErrMsg();
                int offset = code.indexOf(CONTENT_ASIST_CURSOR);
                int index = 0;
                while (offset >= 0) {
                    IASTCompletionNode node = null;
                    try {
                        node = ParseHelper.getCompletionNode(code, language, offset);
                    }
                    catch (Exception exception) {
                        errMsg = errMsg.length() == 0 ? "caught an exception when the code is parsed for cursor number " + index : String.valueOf(errMsg) + "\n" + "caught an exception when the code is parsed for cursor number " + index;
                    }
                    if (node == null) {
                        errMsg = errMsg.length() == 0 ? "return completion node is null when the code is parsed for cursor number " + index : String.valueOf(errMsg) + "\n" + "return completion node is null when the code is parsed for cursor number " + index;
                    }
                    offset = code.indexOf(CONTENT_ASIST_CURSOR, offset + 1);
                    ++index;
                }
                AbstractLRHangingTest.this.setErrMsg(errMsg);
            }
        };
        this.runThreadByLimitedTime(THREAD_TIMEOUT_LIMIT, testThread);
        this.errMsg.length();
    }
}

