/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension;

import java.util.LinkedList;
import org.eclipse.tm.tcf.protocol.IEventQueue;

public class SimpleEventQueue
extends Thread
implements IEventQueue {
    private final LinkedList<Runnable> queue = new LinkedList();

    public SimpleEventQueue() {
        this.setName("TCF Event Dispatch");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                Runnable r = null;
                SimpleEventQueue simpleEventQueue = this;
                synchronized (simpleEventQueue) {
                    while (true) {
                        if (!this.queue.isEmpty()) {
                            r = this.queue.removeFirst();
                            break;
                        }
                        this.wait();
                    }
                }
                try {
                    r.run();
                }
                catch (Throwable x) {
                    System.err.println("Error dispatching TCF event:");
                    x.printStackTrace();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.exit(1);
            return;
        }
        catch (Throwable x) {
            x.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized int getCongestion() {
        int n = this.queue.size() - 100;
        if (n > 100) {
            n = 100;
        }
        return n;
    }

    public synchronized void invokeLater(Runnable runnable) {
        this.queue.add(runnable);
        this.notify();
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this;
    }
}

